/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class VerifyTapeSpectraS3Request
extends AbstractRequest {
    private final String tapeId;
    private Priority taskPriority;

    public VerifyTapeSpectraS3Request(UUID tapeId) {
        this.tapeId = tapeId.toString();
        this.getQueryParams().put("operation", "verify");
    }

    public VerifyTapeSpectraS3Request(String tapeId) {
        this.tapeId = tapeId;
        this.getQueryParams().put("operation", "verify");
    }

    public VerifyTapeSpectraS3Request withTaskPriority(Priority taskPriority) {
        this.taskPriority = taskPriority;
        this.updateQueryParam("task_priority", taskPriority);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape/" + this.tapeId;
    }

    public String getTapeId() {
        return this.tapeId;
    }

    public Priority getTaskPriority() {
        return this.taskPriority;
    }
}

