/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.HeadBucketRequest;
import com.spectralogic.ds3client.commands.HeadBucketResponse;
import com.spectralogic.ds3client.commands.PutBucketRequest;
import com.spectralogic.ds3client.commands.PutObjectRequest;
import com.spectralogic.ds3client.commands.spectrads3.GetActiveJobSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.GetBulkJobSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.GetBulkJobSpectraS3Response;
import com.spectralogic.ds3client.commands.spectrads3.ModifyJobSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.ModifyJobSpectraS3Response;
import com.spectralogic.ds3client.commands.spectrads3.PutBucketSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.PutBulkJobSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.PutBulkJobSpectraS3Response;
import com.spectralogic.ds3client.helpers.DeleteBucket;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.FileSystemHelper;
import com.spectralogic.ds3client.helpers.FileSystemHelperImpl;
import com.spectralogic.ds3client.helpers.FileTreeWalker;
import com.spectralogic.ds3client.helpers.FolderNameFilter;
import com.spectralogic.ds3client.helpers.JobRecoveryException;
import com.spectralogic.ds3client.helpers.JobRecoveryNotActiveException;
import com.spectralogic.ds3client.helpers.JobRecoveryTypeException;
import com.spectralogic.ds3client.helpers.ObjectStorageSpaceVerificationResult;
import com.spectralogic.ds3client.helpers.ReadJobImpl;
import com.spectralogic.ds3client.helpers.WriteJobImpl;
import com.spectralogic.ds3client.helpers.events.EventRunner;
import com.spectralogic.ds3client.helpers.events.SameThreadEventRunner;
import com.spectralogic.ds3client.helpers.options.ReadJobOptions;
import com.spectralogic.ds3client.helpers.options.WriteJobOptions;
import com.spectralogic.ds3client.helpers.pagination.FileSystemKey;
import com.spectralogic.ds3client.helpers.pagination.GetBucketKeyLoaderFactory;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcherImpl;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferStrategyBuilder;
import com.spectralogic.ds3client.helpers.util.PartialObjectHelpers;
import com.spectralogic.ds3client.models.ChecksumType;
import com.spectralogic.ds3client.models.Contents;
import com.spectralogic.ds3client.models.JobChunkClientProcessingOrderGuarantee;
import com.spectralogic.ds3client.models.JobRequestType;
import com.spectralogic.ds3client.models.MasterObjectList;
import com.spectralogic.ds3client.models.bulk.Ds3Object;
import com.spectralogic.ds3client.models.common.Range;
import com.spectralogic.ds3client.networking.FailedRequestException;
import com.spectralogic.ds3client.utils.ByteArraySeekableByteChannel;
import com.spectralogic.ds3client.utils.collections.LazyIterable;
import com.spectralogic.ds3client.utils.collections.StreamWrapper;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Ds3ClientHelpersImpl
extends Ds3ClientHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(Ds3ClientHelpersImpl.class);
    private static final int DEFAULT_LIST_OBJECTS_RETRIES = 5;
    public static final String DEFAULT_DELIMITER = null;
    private final Ds3Client client;
    private final int maxChunkAttempts;
    private final int secondsBetweenChunkAttempts;
    private final int maxObjectTransferAttempts;
    private final EventRunner eventRunner;
    private final FileSystemHelper fileSystemHelper;

    public Ds3ClientHelpersImpl(Ds3Client client) {
        this(client, -1);
    }

    public Ds3ClientHelpersImpl(Ds3Client client, int maxChunkAttempts) {
        this(client, maxChunkAttempts, 5);
    }

    public Ds3ClientHelpersImpl(Ds3Client client, int maxChunkAttempts, int maxObjectTransferAttempts) {
        this(client, maxChunkAttempts, maxObjectTransferAttempts, -1);
    }

    public Ds3ClientHelpersImpl(Ds3Client client, int maxChunkAttempts, int maxObjectTransferAttempts, int secondsBetweenChunkAttempts) {
        this(client, maxChunkAttempts, maxObjectTransferAttempts, secondsBetweenChunkAttempts, new SameThreadEventRunner());
    }

    public Ds3ClientHelpersImpl(Ds3Client client, int maxChunkAttempts, int maxObjectTransferAttempts, int secondsBetweenChunkAttempts, EventRunner eventRunner) {
        this(client, maxChunkAttempts, maxObjectTransferAttempts, secondsBetweenChunkAttempts, eventRunner, new FileSystemHelperImpl());
    }

    public Ds3ClientHelpersImpl(Ds3Client client, int maxChunkAttempts, int maxObjectTransferAttempts, int secondsBetweenChunkAttempts, EventRunner eventRunner, FileSystemHelper fileSystemHelper) {
        this.client = client;
        this.maxChunkAttempts = maxChunkAttempts;
        this.maxObjectTransferAttempts = maxObjectTransferAttempts;
        this.secondsBetweenChunkAttempts = secondsBetweenChunkAttempts;
        this.eventRunner = eventRunner;
        this.fileSystemHelper = fileSystemHelper;
    }

    @Override
    public Ds3ClientHelpers.Job startWriteJob(String bucket, Iterable<Ds3Object> objectsToWrite) throws IOException {
        return this.startWriteJob(bucket, objectsToWrite, WriteJobOptions.create());
    }

    @Override
    public Ds3ClientHelpers.Job startWriteJob(String bucket, Iterable<Ds3Object> objectsToWrite, WriteJobOptions options) throws IOException {
        if (options == null) {
            return this.innerStartWriteJob(bucket, objectsToWrite, WriteJobOptions.create(), this.makeTransferStrategyBuilder());
        }
        return this.innerStartWriteJob(bucket, objectsToWrite, options, this.makeTransferStrategyBuilder());
    }

    private TransferStrategyBuilder makeTransferStrategyBuilder() {
        return new TransferStrategyBuilder().withDs3Client(this.client).withNumChunkAttemptRetries(this.maxChunkAttempts).withNumTransferRetries(this.maxObjectTransferAttempts).withChunkRetryDelayInSeconds(this.secondsBetweenChunkAttempts).withEventRunner(this.eventRunner).withEventDispatcher(new EventDispatcherImpl(this.eventRunner));
    }

    private Ds3ClientHelpers.Job innerStartWriteJob(String bucket, Iterable<Ds3Object> objectsToWrite, WriteJobOptions options, TransferStrategyBuilder transferStrategyBuilder) throws IOException {
        PutBulkJobSpectraS3Request request = new PutBulkJobSpectraS3Request(bucket, objectsToWrite).withPriority(options.getPriority()).withAggregating(options.isAggregating()).withForce(options.isForce()).withIgnoreNamingConflicts(options.doIgnoreNamingConflicts());
        if (options.getMaxUploadSize() > 0L) {
            request.withMaxUploadSize(options.getMaxUploadSize());
        }
        PutBulkJobSpectraS3Response putBulkJobSpectraS3Response = this.client.putBulkJobSpectraS3(request);
        transferStrategyBuilder.withMasterObjectList(putBulkJobSpectraS3Response.getMasterObjectList()).withChecksumType(options.getChecksumType());
        return new WriteJobImpl(transferStrategyBuilder);
    }

    @Override
    public Ds3ClientHelpers.Job startWriteJob(TransferStrategy transferStrategy) throws IOException {
        return new WriteJobImpl(transferStrategy);
    }

    @Override
    public Ds3ClientHelpers.Job startWriteJobUsingStreamedBehavior(String bucket, Iterable<Ds3Object> objectsToWrite) throws IOException {
        return this.startWriteJobUsingStreamedBehavior(bucket, objectsToWrite, WriteJobOptions.create());
    }

    @Override
    public Ds3ClientHelpers.Job startWriteJobUsingStreamedBehavior(String bucket, Iterable<Ds3Object> objectsToWrite, WriteJobOptions options) throws IOException {
        Preconditions.checkNotNull((Object)options, (Object)"options may not be null.");
        TransferStrategyBuilder transferStrategyBuilder = this.makeTransferStrategyBuilder();
        transferStrategyBuilder.usingStreamedTransferBehavior();
        return this.innerStartWriteJob(bucket, objectsToWrite, options, transferStrategyBuilder);
    }

    @Override
    public Ds3ClientHelpers.Job startWriteJobUsingRandomAccessBehavior(String bucket, Iterable<Ds3Object> objectsToWrite) throws IOException {
        return this.startWriteJobUsingRandomAccessBehavior(bucket, objectsToWrite, WriteJobOptions.create());
    }

    @Override
    public Ds3ClientHelpers.Job startWriteJobUsingRandomAccessBehavior(String bucket, Iterable<Ds3Object> objectsToWrite, WriteJobOptions options) throws IOException {
        Preconditions.checkNotNull((Object)options, (Object)"options may not be null.");
        TransferStrategyBuilder transferStrategyBuilder = this.makeTransferStrategyBuilder();
        transferStrategyBuilder.usingRandomAccessTransferBehavior();
        return this.innerStartWriteJob(bucket, objectsToWrite, options, transferStrategyBuilder);
    }

    @Override
    public Ds3ClientHelpers.Job startReadJob(String bucket, Iterable<Ds3Object> objectsToRead) throws IOException {
        return this.startReadJob(bucket, objectsToRead, ReadJobOptions.create());
    }

    @Override
    public Ds3ClientHelpers.Job startReadJob(String bucket, Iterable<Ds3Object> objects, ReadJobOptions options) throws IOException {
        GetBulkJobSpectraS3Request getBulkJobSpectraS3Request = options == null ? this.makeGetBulkJobSpectraS3Request(bucket, objects, ReadJobOptions.create()) : this.makeGetBulkJobSpectraS3Request(bucket, objects, options);
        getBulkJobSpectraS3Request.withChunkClientProcessingOrderGuarantee(JobChunkClientProcessingOrderGuarantee.NONE);
        return this.innerStartReadJob(objects, getBulkJobSpectraS3Request, this.makeTransferStrategyBuilder());
    }

    private GetBulkJobSpectraS3Request makeGetBulkJobSpectraS3Request(String bucket, Iterable<Ds3Object> objects, ReadJobOptions options) {
        return new GetBulkJobSpectraS3Request(bucket, objects).withPriority(options.getPriority()).withName(options.getName());
    }

    private Ds3ClientHelpers.Job innerStartReadJob(Iterable<Ds3Object> objects, GetBulkJobSpectraS3Request getBulkJobSpectraS3Request, TransferStrategyBuilder transferStrategyBuilder) throws IOException {
        GetBulkJobSpectraS3Response getBulkJobSpectraS3Response = this.client.getBulkJobSpectraS3(getBulkJobSpectraS3Request);
        ImmutableMultimap<String, Range> partialRanges = PartialObjectHelpers.getPartialObjectsRanges(objects);
        MasterObjectList masterObjectList = getBulkJobSpectraS3Response.getMasterObjectList();
        transferStrategyBuilder.withMasterObjectList(masterObjectList).withRangesForBlobs(PartialObjectHelpers.mapRangesToBlob(masterObjectList.getObjects(), partialRanges));
        return new ReadJobImpl(transferStrategyBuilder);
    }

    @Override
    public Ds3ClientHelpers.Job startReadJob(TransferStrategy transferStrategy) throws IOException {
        return new ReadJobImpl(transferStrategy);
    }

    @Override
    public Ds3ClientHelpers.Job startReadJobUsingStreamedBehavior(String bucket, Iterable<Ds3Object> objectsToRead) throws IOException {
        return this.startReadJobUsingStreamedBehavior(bucket, objectsToRead, ReadJobOptions.create());
    }

    @Override
    public Ds3ClientHelpers.Job startReadJobUsingStreamedBehavior(String bucket, Iterable<Ds3Object> objects, ReadJobOptions options) throws IOException {
        Preconditions.checkNotNull((Object)options, (Object)"options may not be null.");
        GetBulkJobSpectraS3Request getBulkJobSpectraS3Request = this.makeGetBulkJobSpectraS3Request(bucket, objects, options);
        getBulkJobSpectraS3Request.withChunkClientProcessingOrderGuarantee(JobChunkClientProcessingOrderGuarantee.IN_ORDER);
        TransferStrategyBuilder transferStrategyBuilder = this.makeTransferStrategyBuilder();
        transferStrategyBuilder.usingStreamedTransferBehavior();
        return this.innerStartReadJob(objects, getBulkJobSpectraS3Request, transferStrategyBuilder);
    }

    @Override
    public Ds3ClientHelpers.Job startReadJobUsingRandomAccessBehavior(String bucket, Iterable<Ds3Object> objectsToRead) throws IOException {
        return this.startReadJobUsingRandomAccessBehavior(bucket, objectsToRead, ReadJobOptions.create());
    }

    @Override
    public Ds3ClientHelpers.Job startReadJobUsingRandomAccessBehavior(String bucket, Iterable<Ds3Object> objects, ReadJobOptions options) throws IOException {
        Preconditions.checkNotNull((Object)options, (Object)"options may not be null.");
        GetBulkJobSpectraS3Request getBulkJobSpectraS3Request = this.makeGetBulkJobSpectraS3Request(bucket, objects, options);
        getBulkJobSpectraS3Request.withChunkClientProcessingOrderGuarantee(JobChunkClientProcessingOrderGuarantee.NONE);
        TransferStrategyBuilder transferStrategyBuilder = this.makeTransferStrategyBuilder();
        transferStrategyBuilder.usingRandomAccessTransferBehavior();
        return this.innerStartReadJob(objects, getBulkJobSpectraS3Request, transferStrategyBuilder);
    }

    @Override
    public Ds3ClientHelpers.Job startReadAllJob(String bucket) throws IOException {
        return this.innerStartReadAllJob(bucket, ReadJobOptions.create());
    }

    @Override
    public Ds3ClientHelpers.Job startReadAllJob(String bucket, ReadJobOptions options) throws IOException {
        if (options == null) {
            return this.innerStartReadAllJob(bucket, ReadJobOptions.create());
        }
        return this.innerStartReadAllJob(bucket, options);
    }

    private Ds3ClientHelpers.Job innerStartReadAllJob(String bucket, ReadJobOptions options) throws IOException {
        return this.startReadJob(bucket, this.makeBlobList(bucket), options);
    }

    private Iterable<Ds3Object> makeBlobList(String bucket) throws IOException {
        Iterable<Contents> contentsList = this.listObjects(bucket);
        return this.toDs3Iterable(contentsList, FolderNameFilter.filter());
    }

    @Override
    public Ds3ClientHelpers.Job startReadAllJobUsingStreamedBehavior(String bucket) throws IOException {
        return this.startReadAllJobUsingStreamedBehavior(bucket, ReadJobOptions.create());
    }

    @Override
    public Ds3ClientHelpers.Job startReadAllJobUsingStreamedBehavior(String bucket, ReadJobOptions options) throws IOException {
        Preconditions.checkNotNull((Object)options, (Object)"options may not be null.");
        return this.startReadJobUsingStreamedBehavior(bucket, this.makeBlobList(bucket), options);
    }

    @Override
    public Ds3ClientHelpers.Job startReadAllJobUsingRandomAccessBehavior(String bucket) throws IOException {
        return this.startReadAllJobUsingRandomAccessBehavior(bucket, ReadJobOptions.create());
    }

    @Override
    public Ds3ClientHelpers.Job startReadAllJobUsingRandomAccessBehavior(String bucket, ReadJobOptions options) throws IOException {
        Preconditions.checkNotNull((Object)options, (Object)"options may not be null.");
        return this.startReadJobUsingRandomAccessBehavior(bucket, this.makeBlobList(bucket), options);
    }

    @Override
    public Ds3ClientHelpers.Job recoverWriteJob(UUID jobId) throws IOException, JobRecoveryException {
        this.innerVerifyJobActive(jobId);
        ModifyJobSpectraS3Response jobResponse = this.modifyJobSpectraS3Response(jobId, JobRequestType.PUT);
        TransferStrategyBuilder transferStrategyBuilder = this.makeTransferStrategyBuilder().withMasterObjectList(jobResponse.getMasterObjectListResult()).withChecksumType(ChecksumType.Type.NONE);
        return new WriteJobImpl(transferStrategyBuilder);
    }

    private void innerVerifyJobActive(UUID jobId) throws IOException, JobRecoveryNotActiveException {
        try {
            this.client.getActiveJobSpectraS3(new GetActiveJobSpectraS3Request(jobId));
        }
        catch (FailedRequestException e) {
            if (e.getStatusCode() == 404) {
                throw new JobRecoveryNotActiveException(jobId, (Throwable)e);
            }
            throw e;
        }
    }

    private ModifyJobSpectraS3Response modifyJobSpectraS3Response(UUID jobId, JobRequestType jobRequestType) throws IOException, JobRecoveryException {
        ModifyJobSpectraS3Response jobResponse = this.client.modifyJobSpectraS3(new ModifyJobSpectraS3Request(jobId.toString()));
        if (jobRequestType != jobResponse.getMasterObjectListResult().getRequestType()) {
            throw new JobRecoveryTypeException(jobRequestType.toString(), jobResponse.getMasterObjectListResult().getRequestType().toString());
        }
        return jobResponse;
    }

    @Override
    public Ds3ClientHelpers.Job recoverWriteJobUsingStreamedBehavior(UUID jobId) throws IOException, JobRecoveryException {
        this.innerVerifyJobActive(jobId);
        ModifyJobSpectraS3Response jobResponse = this.modifyJobSpectraS3Response(jobId, JobRequestType.PUT);
        TransferStrategyBuilder transferStrategyBuilder = this.makeTransferStrategyBuilder().withMasterObjectList(jobResponse.getMasterObjectListResult()).withChecksumType(ChecksumType.Type.NONE).usingStreamedTransferBehavior();
        return new WriteJobImpl(transferStrategyBuilder);
    }

    @Override
    public Ds3ClientHelpers.Job recoverWriteJobUsingRandomAccessBehavior(UUID jobId) throws IOException, JobRecoveryException {
        this.innerVerifyJobActive(jobId);
        ModifyJobSpectraS3Response jobResponse = this.modifyJobSpectraS3Response(jobId, JobRequestType.PUT);
        TransferStrategyBuilder transferStrategyBuilder = this.makeTransferStrategyBuilder().withMasterObjectList(jobResponse.getMasterObjectListResult()).withChecksumType(ChecksumType.Type.NONE).usingRandomAccessTransferBehavior();
        return new WriteJobImpl(transferStrategyBuilder);
    }

    @Override
    public Ds3ClientHelpers.Job recoverReadJob(UUID jobId) throws IOException, JobRecoveryException {
        this.innerVerifyJobActive(jobId);
        MasterObjectList masterObjectList = this.masterObjectListForGetJob(jobId);
        TransferStrategyBuilder transferStrategyBuilder = this.makeTransferStrategyBuilder().withMasterObjectList(masterObjectList).withRangesForBlobs(PartialObjectHelpers.mapRangesToBlob(masterObjectList.getObjects(), (ImmutableMultimap<String, Range>)ImmutableMultimap.of()));
        return new ReadJobImpl(transferStrategyBuilder);
    }

    private MasterObjectList masterObjectListForGetJob(UUID jobId) throws IOException, JobRecoveryException {
        ModifyJobSpectraS3Response jobResponse = this.modifyJobSpectraS3Response(jobId, JobRequestType.GET);
        return jobResponse.getMasterObjectListResult();
    }

    @Override
    public Ds3ClientHelpers.Job recoverReadJobsingStreamedBehavior(UUID jobId) throws IOException, JobRecoveryException {
        this.innerVerifyJobActive(jobId);
        MasterObjectList masterObjectList = this.masterObjectListForGetJob(jobId);
        TransferStrategyBuilder transferStrategyBuilder = this.makeTransferStrategyBuilder().withMasterObjectList(masterObjectList).withRangesForBlobs(PartialObjectHelpers.mapRangesToBlob(masterObjectList.getObjects(), (ImmutableMultimap<String, Range>)ImmutableMultimap.of())).usingStreamedTransferBehavior();
        return new ReadJobImpl(transferStrategyBuilder);
    }

    @Override
    public Ds3ClientHelpers.Job recoverReadJobUsingRandomAccessBehavior(UUID jobId) throws IOException, JobRecoveryException {
        this.innerVerifyJobActive(jobId);
        MasterObjectList masterObjectList = this.masterObjectListForGetJob(jobId);
        TransferStrategyBuilder transferStrategyBuilder = this.makeTransferStrategyBuilder().withMasterObjectList(masterObjectList).withRangesForBlobs(PartialObjectHelpers.mapRangesToBlob(masterObjectList.getObjects(), (ImmutableMultimap<String, Range>)ImmutableMultimap.of())).usingRandomAccessTransferBehavior();
        return new ReadJobImpl(transferStrategyBuilder);
    }

    @Override
    public void ensureBucketExists(String bucket) throws IOException {
        HeadBucketResponse response = this.client.headBucket(new HeadBucketRequest(bucket));
        if (response.getStatus() == HeadBucketResponse.Status.DOESNTEXIST) {
            try {
                this.client.putBucket(new PutBucketRequest(bucket));
            }
            catch (FailedRequestException e) {
                if (e.getStatusCode() != 409) {
                    throw e;
                }
                LOG.warn("Creating {} failed because it was created by another thread or process", (Object)bucket);
            }
        }
    }

    @Override
    public void ensureBucketExists(String bucket, UUID dataPolicy) throws IOException {
        HeadBucketResponse response = this.client.headBucket(new HeadBucketRequest(bucket));
        if (response.getStatus() == HeadBucketResponse.Status.DOESNTEXIST) {
            try {
                this.client.putBucketSpectraS3(new PutBucketSpectraS3Request(bucket).withDataPolicyId(dataPolicy));
            }
            catch (FailedRequestException e) {
                if (e.getStatusCode() != 409) {
                    throw e;
                }
                LOG.warn("Creating {} failed because it was created by another thread or process", (Object)bucket);
            }
        }
    }

    @Override
    public Iterable<Contents> listObjects(String bucket) throws IOException {
        return this.listObjects(bucket, null);
    }

    @Override
    public Iterable<Contents> listObjects(String bucket, String keyPrefix) throws IOException {
        return this.listObjects(bucket, keyPrefix, null, Integer.MAX_VALUE);
    }

    @Override
    public Iterable<Contents> listObjects(String bucket, String keyPrefix, String nextMarker) throws IOException {
        return this.listObjects(bucket, keyPrefix, nextMarker, Integer.MAX_VALUE);
    }

    @Override
    public Iterable<Contents> listObjects(String bucket, String keyPrefix, String nextMarker, int maxKeys) {
        return this.listObjects(bucket, keyPrefix, nextMarker, maxKeys, 5);
    }

    @Override
    public Iterable<Contents> listObjects(String bucket, String keyPrefix, String nextMarker, int maxKeys, int retries) {
        return new LazyIterable<Contents>(new GetBucketKeyLoaderFactory<Contents>(this.client, bucket, keyPrefix, DEFAULT_DELIMITER, nextMarker, maxKeys, retries, GetBucketKeyLoaderFactory.contentsFunction));
    }

    @Override
    public Iterable<Ds3Object> listObjectsForDirectory(Path directory) throws IOException {
        return FileTreeWalker.INSTANCE.walk(directory);
    }

    @Override
    public Iterable<FileSystemKey> remoteListDirectory(String bucket, String keyPrefix) throws IOException {
        return this.remoteListDirectory(bucket, keyPrefix, null);
    }

    @Override
    public Iterable<FileSystemKey> remoteListDirectory(String bucket, String keyPrefix, String nextMarker) throws IOException {
        return this.remoteListDirectory(bucket, keyPrefix, nextMarker, 1000);
    }

    @Override
    public Iterable<FileSystemKey> remoteListDirectory(String bucket, String keyPrefix, String nextMarker, int maxKeys) throws IOException {
        return this.remoteListDirectory(bucket, keyPrefix, "/", keyPrefix, maxKeys);
    }

    @Override
    public Iterable<FileSystemKey> remoteListDirectory(String bucket, String keyPrefix, String delimiter, String nextMarker, int maxKeys) throws IOException {
        return new LazyIterable<FileSystemKey>(new GetBucketKeyLoaderFactory<FileSystemKey>(this.client, bucket, keyPrefix, delimiter, nextMarker, maxKeys, 5, GetBucketKeyLoaderFactory.getFileSystemKeysFunction));
    }

    @Override
    public void deleteBucket(String bucket) throws IOException {
        DeleteBucket.INSTANCE.deleteBucket(this, bucket);
    }

    @Override
    public Iterable<Ds3Object> addPrefixToDs3ObjectsList(Iterable<Ds3Object> objectsList, String prefix) {
        Stream<Ds3Object> objectIterable = StreamSupport.stream(objectsList.spliterator(), false);
        return StreamWrapper.wrapStream(objectIterable.map(obj -> new Ds3Object(prefix + obj.getName(), obj.getSize())));
    }

    @Override
    public Iterable<Ds3Object> removePrefixFromDs3ObjectsList(Iterable<Ds3Object> objectsList, String prefix) {
        Stream<Ds3Object> objectIterable = StreamSupport.stream(objectsList.spliterator(), false);
        return StreamWrapper.wrapStream(objectIterable.map(obj -> new Ds3Object(Ds3ClientHelpersImpl.stripLeadingPath(obj.getName(), prefix), obj.getSize())));
    }

    @Override
    public ObjectStorageSpaceVerificationResult objectsFromBucketWillFitInDirectory(String bucketName, Collection<String> objectNames, Path destinationDirectory) {
        return this.fileSystemHelper.objectsFromBucketWillFitInDirectory(this, bucketName, objectNames, destinationDirectory);
    }

    @Override
    public void createFolder(String bucketName, String folderName) throws IOException {
        String normalizedFolderName = Ds3ClientHelpersImpl.ensureNameEndsWithSlash(folderName);
        Ds3Object ds3Object = new Ds3Object(normalizedFolderName, 0L);
        PutBulkJobSpectraS3Response jobResponse = this.client.putBulkJobSpectraS3(new PutBulkJobSpectraS3Request(bucketName, (Iterable<Ds3Object>)ImmutableList.of((Object)ds3Object)));
        PutObjectRequest folderRequest = new PutObjectRequest(bucketName, normalizedFolderName, (SeekableByteChannel)new ByteArraySeekableByteChannel(0), jobResponse.getMasterObjectList().getJobId(), 0L, 0L);
        this.client.putObject(folderRequest);
    }

    @Override
    public Ds3Client getClient() {
        return this.client;
    }

    private static String ensureNameEndsWithSlash(String folderName) {
        if (folderName.endsWith("/")) {
            return folderName;
        }
        return folderName + "/";
    }
}

