/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.channels;

import com.spectralogic.ds3client.helpers.TruncateNotAllowedException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class WindowedSeekableByteChannel
implements SeekableByteChannel {
    private final SeekableByteChannel channel;
    private final Object lock;
    private final long offset;
    private final long length;
    private long position = 0L;
    private boolean isOpen = true;
    private final Copy readCopy = new ReadCopy();
    private final Copy writeCopy = new WriteCopy();

    public WindowedSeekableByteChannel(SeekableByteChannel channel, Object lock, long offset, long length) {
        this.channel = channel;
        this.lock = lock;
        this.offset = offset;
        this.length = length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return this.isOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.isOpen = false;
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.copy(dst, this.readCopy);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.copy(src, this.writeCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copy(ByteBuffer buffer, Copy copy) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            if (this.position >= this.length) {
                return -1;
            }
            int oldLimit = buffer.limit();
            long distanceFromEnd = this.length - this.position;
            if ((long)buffer.remaining() > distanceFromEnd) {
                buffer.limit(oldLimit + (int)distanceFromEnd - buffer.remaining());
            }
            this.channel.position(this.offset + this.position);
            int bytesCopied = copy.copy(buffer);
            this.position += (long)bytesCopied;
            buffer.limit(oldLimit);
            return bytesCopied;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            return this.position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            this.position = newPosition;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            return this.length;
        }
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new TruncateNotAllowedException();
    }

    private void checkClosed() {
        if (!this.isOpen) {
            throw new IllegalStateException("Object already closed");
        }
    }

    private final class WriteCopy
    implements Copy {
        private WriteCopy() {
        }

        @Override
        public int copy(ByteBuffer buffer) throws IOException {
            return WindowedSeekableByteChannel.this.channel.write(buffer);
        }
    }

    private final class ReadCopy
    implements Copy {
        private ReadCopy() {
        }

        @Override
        public int copy(ByteBuffer buffer) throws IOException {
            return WindowedSeekableByteChannel.this.channel.read(buffer);
        }
    }

    private static interface Copy {
        public int copy(ByteBuffer var1) throws IOException;
    }
}

