/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.base.Preconditions;
import com.spectralogic.ds3client.helpers.ExceptionClassifier;
import com.spectralogic.ds3client.helpers.JobPart;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferMethod;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferRetryDecorator;
import java.io.IOException;

public class ContinueForeverTransferRetryDecorator
implements TransferRetryDecorator {
    private TransferMethod transferMethodDelegate;

    @Override
    public void transferJobPart(JobPart jobPart) throws IOException {
        while (true) {
            try {
                this.transferMethodDelegate.transferJobPart(jobPart);
            }
            catch (Throwable t) {
                if (!ExceptionClassifier.isUnrecoverableException(t)) continue;
                throw t;
            }
            break;
        }
    }

    @Override
    public TransferMethod wrap(TransferMethod transferMethod) {
        Preconditions.checkNotNull((Object)transferMethod, (Object)"transferMethod may not be null.");
        this.transferMethodDelegate = transferMethod;
        return this;
    }
}

