/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;

public class ByteArraySeekableByteChannel
implements SeekableByteChannel {
    private static final int DEFAULT_BUFFER_SIZE = 8096;
    private byte[] backingArray;
    private int position = 0;
    private int limit = 0;
    private boolean isOpen = true;

    public ByteArraySeekableByteChannel() {
        this(8096);
    }

    public ByteArraySeekableByteChannel(int size) {
        this.backingArray = new byte[size];
    }

    public ByteArraySeekableByteChannel(byte[] bytes) {
        this.backingArray = Arrays.copyOfRange(bytes, 0, bytes.length);
        this.limit = bytes.length;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int numberOfBytes = Math.min(dst.remaining(), this.limit - this.position);
        dst.put(this.backingArray, this.position, numberOfBytes);
        this.position += numberOfBytes;
        return numberOfBytes;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int amountToWrite = src.remaining();
        this.expandArray(amountToWrite);
        src.get(this.backingArray, this.position, amountToWrite);
        this.position += amountToWrite;
        if (this.position >= this.limit) {
            this.limit = this.position;
        }
        return amountToWrite;
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.position = (int)newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.limit;
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        this.limit = Math.min((int)size, this.limit);
        this.position = Math.min((int)size, this.position);
        return this;
    }

    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.backingArray, 0, this.limit);
    }

    public String toString() {
        return this.toString(Charset.forName("UTF-8"));
    }

    public String toString(Charset charset) {
        return new String(this.backingArray, 0, this.limit, charset);
    }

    private void expandArray(int amountToWrite) {
        int newArraySize = this.backingArray.length;
        while (amountToWrite > newArraySize - this.position) {
            newArraySize *= 2;
        }
        if (newArraySize != this.backingArray.length) {
            byte[] oldArray = this.backingArray;
            this.backingArray = new byte[newArraySize];
            System.arraycopy(oldArray, 0, this.backingArray, 0, oldArray.length);
        }
    }
}

