/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.perf4j.StopWatch;
import org.perf4j.TimingStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupedTimingStatistics
implements Serializable,
Cloneable {
    private SortedMap<String, TimingStatistics> statisticsByTag = new TreeMap<String, TimingStatistics>();
    private long startTime;
    private long stopTime;
    private boolean createRollupStatistics;

    public GroupedTimingStatistics() {
    }

    public GroupedTimingStatistics(SortedMap<String, TimingStatistics> statisticsByTag, long startTime, long stopTime, boolean createRollupStatistics) {
        this.statisticsByTag = statisticsByTag;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.createRollupStatistics = createRollupStatistics;
    }

    public GroupedTimingStatistics addStopWatch(StopWatch stopWatch) {
        String tag = stopWatch.getTag();
        this.addStopWatchToStatsByTag(tag, stopWatch);
        if (this.createRollupStatistics) {
            int indexOfDot = -1;
            while ((indexOfDot = tag.indexOf(46, indexOfDot + 1)) >= 0) {
                this.addStopWatchToStatsByTag(tag.substring(0, indexOfDot), stopWatch);
            }
        }
        return this;
    }

    public GroupedTimingStatistics addStopWatches(Collection<StopWatch> stopWatches) {
        for (StopWatch stopWatch : stopWatches) {
            this.addStopWatch(stopWatch);
        }
        return this;
    }

    public SortedMap<String, TimingStatistics> getStatisticsByTag() {
        return this.statisticsByTag;
    }

    public void setStatisticsByTag(SortedMap<String, TimingStatistics> statisticsByTag) {
        this.statisticsByTag = statisticsByTag;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    public boolean isCreateRollupStatistics() {
        return this.createRollupStatistics;
    }

    public void setCreateRollupStatistics(boolean createRollupStatistics) {
        this.createRollupStatistics = createRollupStatistics;
    }

    private void addStopWatchToStatsByTag(String tag, StopWatch stopWatch) {
        TimingStatistics stats = (TimingStatistics)this.statisticsByTag.get(tag);
        if (stats == null) {
            stats = new TimingStatistics();
            this.statisticsByTag.put(tag, stats);
        }
        stats.addSampleTime(stopWatch.getElapsedTime());
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append(String.format("Performance Statistics   %tT - %tT%n", this.startTime, this.stopTime));
        retVal.append(String.format("%-48s%12s%12s%12s%12s%12s%n", "Tag", "Avg(ms)", "Min", "Max", "Std Dev", "Count"));
        for (Map.Entry<String, TimingStatistics> tagWithTimingStatistics : this.statisticsByTag.entrySet()) {
            String tag = tagWithTimingStatistics.getKey();
            TimingStatistics timingStatistics = tagWithTimingStatistics.getValue();
            retVal.append(String.format("%-48s%12.1f%12d%12d%12.1f%12d%n", tag, timingStatistics.getMean(), timingStatistics.getMin(), timingStatistics.getMax(), timingStatistics.getStandardDeviation(), timingStatistics.getCount()));
        }
        return retVal.toString();
    }

    public GroupedTimingStatistics clone() {
        try {
            GroupedTimingStatistics retVal = (GroupedTimingStatistics)super.clone();
            retVal.statisticsByTag = new TreeMap<String, TimingStatistics>(retVal.statisticsByTag);
            for (Map.Entry<String, TimingStatistics> tagAndStats : retVal.statisticsByTag.entrySet()) {
                tagAndStats.setValue(tagAndStats.getValue().clone());
            }
            return retVal;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Unexpected CloneNotSupportedException");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupedTimingStatistics)) {
            return false;
        }
        GroupedTimingStatistics that = (GroupedTimingStatistics)o;
        return this.startTime == that.startTime && this.stopTime == that.stopTime && this.statisticsByTag.equals(that.statisticsByTag);
    }

    public int hashCode() {
        int result = this.statisticsByTag.hashCode();
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (int)(this.stopTime ^ this.stopTime >>> 32);
        return result;
    }
}

