/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.shared.DefaultHomeFinderService;

public class SDSHomeFinderService
extends DefaultHomeFinderService {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSHomeFinderService(SDSSession session, SDSNodeIdProvider nodeid) {
        super(session.getHost());
        this.session = session;
        this.nodeid = nodeid;
    }

    public Path find() throws BackgroundException {
        Path directory = super.find();
        if (directory.isRoot()) {
            Acl acl = new Acl();
            if (this.session.userAccount().isUserInRole(SDSPermissionsFeature.ROOM_MANAGER_ROLE)) {
                acl.addAll((Acl.User)new Acl.CanonicalUser(), new Acl.Role[]{SDSPermissionsFeature.CREATE_ROLE});
            }
            directory.attributes().setAcl(acl);
        } else {
            SDSAttributesFinderFeature feature = new SDSAttributesFinderFeature(this.session, this.nodeid);
            try {
                Node node = new NodesApi((ApiClient)this.session.getClient()).requestNode(Long.parseLong(this.nodeid.getFileid(directory, (ListProgressListener)new DisabledListProgressListener())), "", null);
                directory.setAttributes(feature.toAttributes(node));
                directory.setType(feature.toType(node));
            }
            catch (ApiException e) {
                throw new SDSExceptionMappingService().map("Failure to read attributes of {0}", e, directory);
            }
        }
        return directory;
    }
}

