/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.S3FileUploadPart;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Request model for completing a S3 file upload")
public class CompleteS3FileUploadRequest {
    @JsonProperty(value="parts")
    private List<S3FileUploadPart> parts = new ArrayList<S3FileUploadPart>();
    @JsonProperty(value="resolutionStrategy")
    private ResolutionStrategyEnum resolutionStrategy = ResolutionStrategyEnum.AUTORENAME;
    @JsonProperty(value="keepShareLinks")
    private Boolean keepShareLinks = false;
    @JsonProperty(value="fileName")
    private String fileName = null;
    @JsonProperty(value="fileKey")
    private FileKey fileKey = null;

    public CompleteS3FileUploadRequest parts(List<S3FileUploadPart> parts) {
        this.parts = parts;
        return this;
    }

    public CompleteS3FileUploadRequest addPartsItem(S3FileUploadPart partsItem) {
        this.parts.add(partsItem);
        return this;
    }

    @Schema(required=true, description="List of S3 file upload parts")
    public List<S3FileUploadPart> getParts() {
        return this.parts;
    }

    public void setParts(List<S3FileUploadPart> parts) {
        this.parts = parts;
    }

    public CompleteS3FileUploadRequest resolutionStrategy(ResolutionStrategyEnum resolutionStrategy) {
        this.resolutionStrategy = resolutionStrategy;
        return this;
    }

    @Schema(description="Node conflict resolution strategy:  * `autorename`  * `overwrite`  * `fail`")
    public ResolutionStrategyEnum getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public void setResolutionStrategy(ResolutionStrategyEnum resolutionStrategy) {
        this.resolutionStrategy = resolutionStrategy;
    }

    public CompleteS3FileUploadRequest keepShareLinks(Boolean keepShareLinks) {
        this.keepShareLinks = keepShareLinks;
        return this;
    }

    @Schema(description="Preserve Download Share Links and point them to the new node.")
    public Boolean isKeepShareLinks() {
        return this.keepShareLinks;
    }

    public void setKeepShareLinks(Boolean keepShareLinks) {
        this.keepShareLinks = keepShareLinks;
    }

    public CompleteS3FileUploadRequest fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Schema(description="New file name to store with")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public CompleteS3FileUploadRequest fileKey(FileKey fileKey) {
        this.fileKey = fileKey;
        return this;
    }

    @Schema(description="")
    public FileKey getFileKey() {
        return this.fileKey;
    }

    public void setFileKey(FileKey fileKey) {
        this.fileKey = fileKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteS3FileUploadRequest completeS3FileUploadRequest = (CompleteS3FileUploadRequest)o;
        return Objects.equals(this.parts, completeS3FileUploadRequest.parts) && Objects.equals((Object)this.resolutionStrategy, (Object)completeS3FileUploadRequest.resolutionStrategy) && Objects.equals(this.keepShareLinks, completeS3FileUploadRequest.keepShareLinks) && Objects.equals(this.fileName, completeS3FileUploadRequest.fileName) && Objects.equals(this.fileKey, completeS3FileUploadRequest.fileKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parts, this.resolutionStrategy, this.keepShareLinks, this.fileName, this.fileKey});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompleteS3FileUploadRequest {\n");
        sb.append("    parts: ").append(this.toIndentedString(this.parts)).append("\n");
        sb.append("    resolutionStrategy: ").append(this.toIndentedString((Object)this.resolutionStrategy)).append("\n");
        sb.append("    keepShareLinks: ").append(this.toIndentedString(this.keepShareLinks)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    fileKey: ").append(this.toIndentedString(this.fileKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ResolutionStrategyEnum {
        AUTORENAME("autorename"),
        OVERWRITE("overwrite"),
        FAIL("fail");

        private String value;

        private ResolutionStrategyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResolutionStrategyEnum fromValue(String text) {
            for (ResolutionStrategyEnum b : ResolutionStrategyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

