/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.GeneralAdminInp;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.QuotaAO;
import org.irods.jargon.core.pub.SimpleQueryExecutorAO;
import org.irods.jargon.core.pub.domain.Quota;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSetInterface;
import org.irods.jargon.core.query.SimpleQuery;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaAOImpl
extends IRODSGenericAO
implements QuotaAO {
    public static final Logger log = LoggerFactory.getLogger(QuotaAOImpl.class);
    private SimpleQueryExecutorAO simpleQueryExcecutor = null;
    public static final String ALL_QUOTA_GLOBAL_QUERY = "select user_name, R_USER_MAIN.zone_name, quota_limit, quota_over, R_QUOTA_MAIN.modify_ts from R_QUOTA_MAIN, R_USER_MAIN where R_USER_MAIN.user_id = R_QUOTA_MAIN.user_id and R_QUOTA_MAIN.resc_id = 0";
    public static final String QUOTA_GLOBAL_FOR_USER_AND_ZONE_QUERY = "select user_name, R_USER_MAIN.zone_name, quota_limit, quota_over, R_QUOTA_MAIN.modify_ts from R_QUOTA_MAIN, R_USER_MAIN where R_USER_MAIN.user_id = R_QUOTA_MAIN.user_id and R_QUOTA_MAIN.resc_id = 0 and user_name=? and R_USER_MAIN.zone_name=?";
    public static final String ALL_QUOTA_QUERY = "select user_name, R_USER_MAIN.zone_name, resc_name, quota_limit, quota_over, R_QUOTA_MAIN.modify_ts from R_QUOTA_MAIN, R_USER_MAIN, R_RESC_MAIN where R_USER_MAIN.user_id = R_QUOTA_MAIN.user_id and R_RESC_MAIN.resc_id = R_QUOTA_MAIN.resc_id";
    public static final String QUOTA_FOR_USER_AND_ZONE_QUERY = "select user_name, R_USER_MAIN.zone_name, resc_name, quota_limit, quota_over, R_QUOTA_MAIN.modify_ts from R_QUOTA_MAIN, R_USER_MAIN, R_RESC_MAIN where R_USER_MAIN.user_id = R_QUOTA_MAIN.user_id and R_RESC_MAIN.resc_id = R_QUOTA_MAIN.resc_id and user_name=? and R_USER_MAIN.zone_name=?";

    protected QuotaAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public List<Quota> listAllQuota() throws JargonException {
        log.info("listAllQuota()");
        ArrayList<Quota> quota = new ArrayList<Quota>();
        SimpleQuery simpleQuery = SimpleQuery.instanceWithNoArguments(ALL_QUOTA_QUERY, 0);
        log.info("exec simple query to get quota values");
        IRODSQueryResultSetInterface resultSet = this.getSimpleQueryExecutorAO().executeSimpleQuery(simpleQuery);
        Object quotaValue = null;
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            quota.add(this.buildQuotaFromPerResourceResultRow(row));
            log.info("added quota value:{}", quotaValue);
        }
        return quota;
    }

    @Override
    public List<Quota> listAllGlobalQuota() throws JargonException {
        log.info("listAllGlobalQuota()");
        ArrayList<Quota> quota = new ArrayList<Quota>();
        SimpleQuery simpleQuery = SimpleQuery.instanceWithNoArguments(ALL_QUOTA_GLOBAL_QUERY, 0);
        log.info("exec simple query to get quota values");
        IRODSQueryResultSetInterface resultSet = this.getSimpleQueryExecutorAO().executeSimpleQuery(simpleQuery);
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            quota.add(this.buildQuotaFromGlobalResultRow(row));
        }
        return quota;
    }

    @Override
    public void setUserQuotaTotal(String userName, long quotaValue) throws JargonException {
        log.info("setUserQuotaTotal()");
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (quotaValue <= 0L) {
            throw new IllegalArgumentException("quotaValue is null or empty");
        }
        log.info("userName:{}", (Object)userName);
        log.info("quotaValue:{}", (Object)quotaValue);
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForSetUserQuotaTotal(userName, quotaValue);
        log.debug("executing admin PI");
        this.getIRODSProtocol().irodsFunction(adminPI);
        log.info("quota set");
    }

    @Override
    public void setUserGroupQuotaTotal(String userGroupName, long quotaValue) throws JargonException {
        log.info("setUserGroupQuotaTotal()");
        if (userGroupName == null || userGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userGroupName");
        }
        if (quotaValue <= 0L) {
            throw new IllegalArgumentException("quotaValue is null or empty");
        }
        log.info("userGroupName:{}", (Object)userGroupName);
        log.info("quotaValue:{}", (Object)quotaValue);
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForSetUserGroupQuotaTotal(userGroupName, quotaValue);
        log.debug("executing admin PI");
        this.getIRODSProtocol().irodsFunction(adminPI);
        log.info("quota set");
    }

    @Override
    public void setUserQuotaForResource(String userName, String resourceName, long quotaValue) throws JargonException {
        log.info("setUserQuotaForResource()");
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourceName");
        }
        if (quotaValue <= 0L) {
            throw new IllegalArgumentException("quotaValue is null or empty");
        }
        log.info("userName:{}", (Object)userName);
        log.info("resourceName:{}", (Object)resourceName);
        log.info("quotaValue:{}", (Object)quotaValue);
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForSetUserQuotaForResource(userName, resourceName, quotaValue);
        log.debug("executing admin PI");
        this.getIRODSProtocol().irodsFunction(adminPI);
        log.info("quota set");
    }

    @Override
    public void setUserGroupQuotaForResource(String userGroupName, String resourceName, long quotaValue) throws JargonException {
        log.info("setUserGroupQuotaForResource()");
        if (userGroupName == null || userGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userGroupName");
        }
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourceName");
        }
        if (quotaValue <= 0L) {
            throw new IllegalArgumentException("quotaValue is null or empty");
        }
        log.info("userGroupName:{}", (Object)userGroupName);
        log.info("resourceName:{}", (Object)resourceName);
        log.info("quotaValue:{}", (Object)quotaValue);
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForSetUserGroupQuotaForResource(userGroupName, resourceName, quotaValue);
        log.debug("executing admin PI");
        this.getIRODSProtocol().irodsFunction(adminPI);
        log.info("quota set");
    }

    @Override
    public List<Quota> listQuotaForAUser(String userName) throws JargonException {
        log.info("listQuotaForAUser()");
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("userName:{}", (Object)userName);
        ArrayList<Quota> quota = new ArrayList<Quota>();
        SimpleQuery simpleQuery = SimpleQuery.instanceWithTwoArguments(QUOTA_FOR_USER_AND_ZONE_QUERY, userName, this.getIRODSAccount().getZone(), 0);
        IRODSQueryResultSetInterface resultSet = this.getSimpleQueryExecutorAO().executeSimpleQuery(simpleQuery);
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            quota.add(this.buildQuotaFromPerResourceResultRow(row));
        }
        return quota;
    }

    @Override
    public Quota getGlobalQuotaForAUser(String userName) throws JargonException {
        log.info("getGlobalQuotaForAUser()");
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        log.info("userName:{}", (Object)userName);
        Quota quota = null;
        SimpleQuery simpleQuery = SimpleQuery.instanceWithTwoArguments(QUOTA_GLOBAL_FOR_USER_AND_ZONE_QUERY, userName, this.getIRODSAccount().getZone(), 0);
        IRODSQueryResultSetInterface resultSet = this.getSimpleQueryExecutorAO().executeSimpleQuery(simpleQuery);
        try {
            IRODSQueryResultRow row = resultSet.getFirstResult();
            quota = this.buildQuotaFromGlobalResultRow(row);
            log.info("found quota:{}", (Object)quota);
        }
        catch (DataNotFoundException dnf) {
            log.info("no quota found, will return null");
        }
        return quota;
    }

    @Override
    public void calculateQuotaUsage() throws JargonException {
        log.info("calculateQuotaUsage()");
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForCalculateQuotaUsage();
        log.debug("executing admin PI");
        this.getIRODSProtocol().irodsFunction(adminPI);
        log.info("quota usage calculated");
    }

    private SimpleQueryExecutorAO getSimpleQueryExecutorAO() throws JargonException {
        if (this.simpleQueryExcecutor == null) {
            this.simpleQueryExcecutor = this.getIRODSAccessObjectFactory().getSimpleQueryExecutorAO(this.getIRODSAccount());
        }
        return this.simpleQueryExcecutor;
    }

    private Quota buildQuotaFromPerResourceResultRow(IRODSQueryResultRow row) throws JargonException {
        Quota quotaValue = new Quota();
        quotaValue.setUserName(row.getColumn(0));
        quotaValue.setZoneName(row.getColumn(1));
        quotaValue.setResourceName(row.getColumn(2));
        quotaValue.setQuotaLimit(IRODSDataConversionUtil.getLongOrZeroFromIRODSValue(row.getColumn(3)));
        quotaValue.setQuotaOver(IRODSDataConversionUtil.getLongOrZeroFromIRODSValue(row.getColumn(4)));
        quotaValue.setUpdatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(5)));
        return quotaValue;
    }

    private Quota buildQuotaFromGlobalResultRow(IRODSQueryResultRow row) throws JargonException {
        Quota quotaValue = new Quota();
        quotaValue.setUserName(row.getColumn(0));
        quotaValue.setZoneName(row.getColumn(1));
        quotaValue.setResourceName("total");
        quotaValue.setQuotaLimit(IRODSDataConversionUtil.getLongOrZeroFromIRODSValue(row.getColumn(2)));
        quotaValue.setQuotaOver(IRODSDataConversionUtil.getLongOrZeroFromIRODSValue(row.getColumn(3)));
        quotaValue.setUpdatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(4)));
        return quotaValue;
    }
}

