/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.testutils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.DataObjectAO;
import org.irods.jargon.core.pub.DataObjectChecksumUtilitiesAO;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.query.AVUQueryElement;
import org.irods.jargon.core.query.AVUQueryOperatorEnum;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.MetaDataAndDomainData;
import org.irods.jargon.testutils.DirAlphaComparator;
import org.irods.jargon.testutils.IRODSTestAssertionException;
import org.irods.jargon.testutils.TestingPropertiesHelper;
import org.irods.jargon.testutils.TestingUtilsException;
import org.irods.jargon.testutils.filemanip.ScratchFileUtils;

public class AssertionHelper {
    private Properties testingProperties = new Properties();
    private final TestingPropertiesHelper testingPropertiesHelper = new TestingPropertiesHelper();
    private ScratchFileUtils scratchFileUtils = null;
    private static final String ASSERTION_ERROR_MESSAGE = "assertion failed -- ";
    private static final String FILE_DOES_NOT_EXIST_ERROR = "requested file does not exist!";

    public AssertionHelper() throws TestingUtilsException {
        this.testingProperties = this.testingPropertiesHelper.getTestProperties();
        this.scratchFileUtils = new ScratchFileUtils(this.testingProperties);
    }

    public void assertLocalFileNotExistsInScratch(String filePathRelativeToScratch) throws IRODSTestAssertionException {
        StringBuilder fullPathToLocalFile = this.computeFullPathToLocalFile(filePathRelativeToScratch);
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append(ASSERTION_ERROR_MESSAGE);
        errorMessage.append("local file exists and should not");
        errorMessage.append((CharSequence)fullPathToLocalFile);
        File localFile = new File(fullPathToLocalFile.toString());
        if (localFile.exists()) {
            throw new IRODSTestAssertionException(errorMessage.toString());
        }
    }

    public void assertLocalFileExistsInScratch(String filePathRelativeToScratch) throws IRODSTestAssertionException {
        StringBuilder fullPathToLocalFile = this.computeFullPathToLocalFile(filePathRelativeToScratch);
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append(ASSERTION_ERROR_MESSAGE);
        errorMessage.append("local file does not exist:");
        errorMessage.append((CharSequence)fullPathToLocalFile);
        File localFile = new File(fullPathToLocalFile.toString());
        if (!localFile.exists()) {
            throw new IRODSTestAssertionException(errorMessage.toString());
        }
    }

    public void assertLocalScratchFileLengthEquals(String filePathRelativeToScratch, long expectedLength) throws IRODSTestAssertionException {
        StringBuilder fullPathToLocalFile = this.computeFullPathToLocalFile(filePathRelativeToScratch);
        File localFile = new File(fullPathToLocalFile.toString());
        if (!localFile.exists()) {
            throw new IRODSTestAssertionException(FILE_DOES_NOT_EXIST_ERROR);
        }
        if (localFile.length() != expectedLength) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(ASSERTION_ERROR_MESSAGE);
            errorMessage.append("file length error, expected:");
            errorMessage.append(expectedLength);
            errorMessage.append(" actual:");
            errorMessage.append(localFile.length());
            errorMessage.append(" for file:");
            errorMessage.append((CharSequence)fullPathToLocalFile);
            throw new IRODSTestAssertionException(errorMessage.toString());
        }
    }

    public void assertLocalFileHasChecksum(String filePathRelativeToScratch, byte[] expectedChecksum) throws IRODSTestAssertionException {
        try {
            byte[] actualChecksum = this.scratchFileUtils.computeFileCheckSum(filePathRelativeToScratch);
            boolean areEqual = Arrays.equals(actualChecksum, expectedChecksum);
            if (!areEqual) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append(ASSERTION_ERROR_MESSAGE);
                errorMessage.append("checksum error, expected:");
                errorMessage.append(String.valueOf(expectedChecksum));
                errorMessage.append(" actual:");
                errorMessage.append(String.valueOf(actualChecksum));
                errorMessage.append(" for file:");
                errorMessage.append(filePathRelativeToScratch);
                throw new IRODSTestAssertionException(errorMessage.toString());
            }
        }
        catch (TestingUtilsException e) {
            StringBuilder message = new StringBuilder();
            message.append("error when computing checksum on file:");
            message.append(filePathRelativeToScratch);
            throw new IRODSTestAssertionException(message.toString(), e);
        }
    }

    protected StringBuilder computeFullPathToLocalFile(String filePathRelativeToScratch) {
        StringBuilder fullPathToLocalFile = new StringBuilder();
        fullPathToLocalFile.append(this.testingProperties.get(TestingPropertiesHelper.GENERATED_FILE_DIRECTORY_KEY));
        fullPathToLocalFile.append(filePathRelativeToScratch);
        return fullPathToLocalFile;
    }

    public void assertIrodsFileOrCollectionExists(String absoluteIrodsPathUnderScratch, IRODSAccessObjectFactory irodsAccessObjectFactory, IRODSAccount irodsAccount) throws IRODSTestAssertionException {
        try {
            IRODSFileFactory fileFactory = irodsAccessObjectFactory.getIRODSFileFactory(irodsAccount);
            IRODSFile file = fileFactory.instanceIRODSFile(absoluteIrodsPathUnderScratch);
            if (!file.exists()) {
                throw new IRODSTestAssertionException("file does not exist");
            }
        }
        catch (JargonException e) {
            throw new IRODSTestAssertionException(e.getMessage());
        }
    }

    public void assertIrodsFileOrCollectionDoesNotExist(String absoluteIrodsPathUnderScratch, IRODSAccessObjectFactory irodsAccessObjectFactory, IRODSAccount irodsAccount) throws IRODSTestAssertionException {
        try {
            IRODSFileFactory fileFactory = irodsAccessObjectFactory.getIRODSFileFactory(irodsAccount);
            IRODSFile file = fileFactory.instanceIRODSFile(absoluteIrodsPathUnderScratch);
            if (file.exists()) {
                throw new IRODSTestAssertionException("file exists");
            }
        }
        catch (JargonException e) {
            throw new IRODSTestAssertionException(e.getMessage());
        }
    }

    public void assertLocalDirectoriesHaveSameData(String dir1, String dir2) throws IRODSTestAssertionException {
        if (dir1 == null) {
            throw new IllegalArgumentException("null dir1");
        }
        if (dir2 == null) {
            throw new IllegalArgumentException("null dir2");
        }
        File file1 = new File(dir1);
        File file2 = new File(dir2);
        if (!file1.exists() || !file1.isDirectory()) {
            throw new IRODSTestAssertionException("the first specified directory does not exist, or is not a directory");
        }
        if (!file2.exists() || !file2.isDirectory()) {
            throw new IRODSTestAssertionException("the second specified directory does not exist, or is not a directory");
        }
        File[] file1Files = file1.listFiles();
        File[] file2Files = file2.listFiles();
        if (file1Files == null && file2Files == null) {
            return;
        }
        if (file1Files == null || file2Files == null) {
            throw new IRODSTestAssertionException("one set of child files is null, the other is not");
        }
        if (file1Files.length != file2Files.length) {
            throw new IRODSTestAssertionException("mismatch of number of files in a directory, file1 has:" + file1Files.length + " files, while file2 has:" + file2Files.length);
        }
        for (int i = 0; i < file1Files.length; ++i) {
            this.assertTwoFilesAreEqualByRecursiveTreeComparison(file1Files[i], file2Files[i]);
        }
    }

    public void assertTwoFilesAreEqualByRecursiveTreeComparison(File file1, File file2) throws IRODSTestAssertionException {
        if (file1.getName().equals(".DS_Store") || file2.getName().equals(".DS_Store")) {
            throw new IRODSTestAssertionException("test data corrupted by Mac .DS_Store files, please reinitialize the scratch directories");
        }
        if (!file1.exists() || !file2.exists()) {
            throw new IRODSTestAssertionException("compared files that do not exist in both trees - \nfile1:" + file1.getAbsolutePath() + " \nfile2:" + file2.getAbsolutePath());
        }
        if (file1.isDirectory() && file2.isDirectory()) {
            File[] file1Files = file1.listFiles();
            File[] file2Files = file2.listFiles();
            if (file1Files == null && file2Files == null) {
                return;
            }
            if (file1Files == null || file2Files == null) {
                throw new IRODSTestAssertionException("one set of child files is null, the other is not");
            }
            Arrays.sort(file1Files, new DirAlphaComparator());
            Arrays.sort(file2Files, new DirAlphaComparator());
            if (file1Files.length != file2Files.length) {
                throw new IRODSTestAssertionException("directories differ in the number of files contained, dir1 is: " + file1.getAbsolutePath() + "\n and has" + file1Files.length + " children \n while dir2 is:" + file2.getAbsolutePath() + " \n and has " + file2Files.length + " children");
            }
            for (int i = 0; i < file1Files.length; ++i) {
                this.assertTwoFilesAreEqualByRecursiveTreeComparison(file1Files[i], file2Files[i]);
            }
        } else if (file1.isFile() && file2.isFile()) {
            if (file1.length() != file2.length()) {
                throw new IRODSTestAssertionException("file lengths differ,, file1 is: " + file1.getAbsolutePath() + "\n and has length:" + file1.length() + "\n while file is:" + file2.getAbsolutePath() + " \n and has length:" + file2.length());
            }
            if (!file1.getName().equals(file2.getName())) {
                throw new IRODSTestAssertionException("file names are different, file1 abs path is:" + file1.getAbsolutePath() + " while file2 abs path is:" + file2.getAbsolutePath());
            }
        } else {
            throw new IRODSTestAssertionException("file mismatch, one is a file, the other is a directory - file1:" + file1.getAbsolutePath() + " file2:" + file2.getAbsolutePath());
        }
    }

    public void assertDataObjectFlaggedWithAVU(String irodsAbsolutePath, String avuAttribute, IRODSAccessObjectFactory irodsAccessObjectFactory, IRODSAccount irodsAccount) throws IRODSTestAssertionException, JargonException {
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (avuAttribute == null || avuAttribute.isEmpty()) {
            throw new IllegalArgumentException("null or empty avuAttribute");
        }
        if (irodsAccessObjectFactory == null) {
            throw new IllegalArgumentException("null irodsAccessObjectFactory");
        }
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        List<MetaDataAndDomainData> actual = null;
        try {
            ArrayList<AVUQueryElement> query = new ArrayList<AVUQueryElement>();
            query.add(AVUQueryElement.instanceForValueQuery(AVUQueryElement.AVUQueryPart.ATTRIBUTE, AVUQueryOperatorEnum.EQUAL, avuAttribute));
            DataObjectAO dataObjectAO = irodsAccessObjectFactory.getDataObjectAO(irodsAccount);
            actual = dataObjectAO.findMetadataValuesForDataObjectUsingAVUQuery(query, irodsAbsolutePath);
        }
        catch (JargonException | JargonQueryException e) {
            throw new JargonException("cannot execute assertion due to JargonException", e);
        }
        if (actual.isEmpty()) {
            throw new IRODSTestAssertionException("no avu found");
        }
    }

    public void assertIrodsFileMatchesLocalFileChecksum(String irodsAbsolutePath, String localAbsolutePath, IRODSAccessObjectFactory irodsAccessObjectFactory, IRODSAccount irodsAccount) throws JargonException {
        DataObjectChecksumUtilitiesAO dataObjectChecksumUtilities = irodsAccessObjectFactory.getDataObjectChecksumUtilitiesAO(irodsAccount);
        dataObjectChecksumUtilities.verifyLocalFileAgainstIrodsFileChecksum(localAbsolutePath, irodsAbsolutePath);
    }
}

