/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.transfer.TransferStatus;

public class CryptoMoveV6Feature
implements Move {
    private final Session<?> session;
    private final Move proxy;
    private final CryptoVault vault;

    public CryptoMoveV6Feature(Session<?> session, Move delegate, CryptoVault cryptomator) {
        this.session = session;
        this.proxy = delegate;
        this.vault = cryptomator;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        Path target = this.proxy.move(this.vault.encrypt(this.session, file, file.isDirectory()), this.vault.encrypt(this.session, renamed, file.isDirectory()), status, callback, connectionCallback);
        if (file.isDirectory()) {
            this.vault.getDirectoryProvider().delete(file);
        }
        return this.vault.decrypt(this.session, target);
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return this.proxy.isSupported(source, target) && this.vault.getFilenameProvider().isValid(target.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoMoveFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

