/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoInputStream;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.cryptomator.cryptolib.api.FileHeader;

public class CryptoReadFeature
implements Read {
    private final Session<?> session;
    private final Read proxy;
    private final CryptoVault vault;

    public CryptoReadFeature(Session<?> session, Read proxy, CryptoVault vault) {
        this.session = session;
        this.proxy = proxy;
        this.vault = vault;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        return this.readEncrypted(this.vault.encrypt(this.session, file), status, callback);
    }

    public InputStream readEncrypted(Path encrypted, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            TransferStatus headerStatus = new TransferStatus(status);
            headerStatus.setOffset(0L);
            InputStream in = this.proxy.read(encrypted, headerStatus.length(status.isAppend() ? (long)this.vault.getFileHeaderCryptor().headerSize() : this.vault.toCiphertextSize(status.getLength())), callback);
            ByteBuffer headerBuffer = ByteBuffer.allocate(this.vault.getFileHeaderCryptor().headerSize());
            int read = IOUtils.read((InputStream)in, (byte[])headerBuffer.array());
            FileHeader header = this.vault.getFileHeaderCryptor().decryptHeader(headerBuffer);
            if (status.isAppend()) {
                IOUtils.closeQuietly((InputStream)in);
                TransferStatus s = new TransferStatus(status).length(-1L);
                s.setOffset(this.align(status.getOffset()));
                CryptoInputStream crypto = new CryptoInputStream(this.proxy.read(encrypted, s, callback), this.vault.getFileContentCryptor(), header, this.chunk(status.getOffset()));
                crypto.skip(this.position(status.getOffset()));
                return crypto;
            }
            return new CryptoInputStream(in, this.vault.getFileContentCryptor(), header, this.vault.numberOfChunks(status.getOffset()));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    protected long chunk(long offset) {
        return offset / (long)this.vault.getFileContentCryptor().cleartextChunkSize();
    }

    protected long align(long offset) {
        return (long)this.vault.getFileHeaderCryptor().headerSize() + this.chunk(offset) * (long)this.vault.getFileContentCryptor().ciphertextChunkSize();
    }

    protected long position(long offset) {
        return offset % (long)this.vault.getFileContentCryptor().cleartextChunkSize();
    }

    public boolean offset(Path file) throws BackgroundException {
        return this.proxy.offset(file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoReadFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

