/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.net.URL;
import java.util.Iterator;
import org.nuxeo.onedrive.client.JsonObjectIterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.types.DirectoryObject;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.Site;

public final class Drives {
    public static Iterator<Drive.Metadata> getDrives(OneDriveAPI api) {
        return new DrivesIterator(api, new URLTemplate("/drives").build(api.getBaseURL()));
    }

    public static Iterator<Drive.Metadata> getDrives(DirectoryObject object) {
        URL objectDrivesURL = Drives.createDrivesUrl(object.getApi(), object.getPath());
        return new DrivesIterator(object.getApi(), objectDrivesURL);
    }

    public static Iterator<Drive.Metadata> getDrives(Site site) {
        return new DrivesIterator(site.getApi(), new URLTemplate(site.getAction("/drives")).build(site.getApi().getBaseURL()));
    }

    private static URL createDrivesUrl(OneDriveAPI api, String basePath) {
        return new URLTemplate(Drives.createDrivesPath(basePath)).build(api.getBaseURL());
    }

    private static String createDrivesPath(String basePath) {
        return basePath + "/drives";
    }

    private static class DrivesIterator
    implements Iterator<Drive.Metadata> {
        private final OneDriveAPI api;
        private final JsonObjectIterator iterator;

        public DrivesIterator(OneDriveAPI api, URL url) {
            this.api = api;
            this.iterator = new JsonObjectIterator(api, url);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Drive.Metadata next() {
            JsonObject nextObject = this.iterator.next();
            String id = nextObject.get("id").asString();
            return (Drive.Metadata)new Drive(this.api, id).new Drive.Metadata().fromJson(nextObject);
        }
    }
}

