/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.filter;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.filter.DownloadDuplicateFilter;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DownloadRegexFilter
extends DownloadDuplicateFilter {
    private static final Logger log = Logger.getLogger(DownloadRegexFilter.class);
    private final Pattern pattern;

    public DownloadRegexFilter() {
        this(Pattern.compile(PreferencesFactory.get().getProperty("queue.download.skip.regex")));
    }

    public DownloadRegexFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean accept(Path file) {
        if (!super.accept(file)) {
            return false;
        }
        if (this.pattern.matcher(file.getName()).matches()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Skip %s excluded with regex", file.getAbsolute()));
            }
            return false;
        }
        return true;
    }

    @Override
    public Pattern toPattern() {
        return this.pattern;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DownloadRegexFilter{");
        sb.append("pattern=").append(this.pattern);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadRegexFilter)) {
            return false;
        }
        DownloadRegexFilter that = (DownloadRegexFilter)o;
        return Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }
}

