/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConflictException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LockedException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.ProxyLoginFailureException;
import ch.cyberduck.core.exception.QuotaException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import org.apache.http.client.HttpResponseException;

public abstract class HttpResponseExceptionMappingService<E extends HttpResponseException>
extends AbstractExceptionMappingService<E> {
    @Override
    public BackgroundException map(E failure) {
        StringBuilder buffer = new StringBuilder();
        this.append(buffer, failure.getReasonPhrase());
        int statusCode = failure.getStatusCode();
        return this.map((Throwable)failure, buffer, statusCode);
    }

    public BackgroundException map(Throwable failure, StringBuilder buffer, int statusCode) {
        switch (statusCode) {
            case 401: {
                return new LoginFailureException(buffer.toString(), failure);
            }
            case 407: {
                return new ProxyLoginFailureException(buffer.toString(), failure);
            }
            case 403: 
            case 406: {
                return new AccessDeniedException(buffer.toString(), failure);
            }
            case 409: {
                return new ConflictException(buffer.toString(), failure);
            }
            case 404: 
            case 410: 
            case 416: {
                return new NotfoundException(buffer.toString(), failure);
            }
            case 402: 
            case 419: 
            case 507: {
                return new QuotaException(buffer.toString(), failure);
            }
            case 400: 
            case 405: 
            case 414: 
            case 422: 
            case 501: {
                return new InteroperabilityException(buffer.toString(), failure);
            }
            case 408: 
            case 504: {
                return new ConnectionTimeoutException(buffer.toString(), failure);
            }
            case 423: {
                return new LockedException(buffer.toString(), failure);
            }
            case 429: 
            case 500: 
            case 502: 
            case 503: 
            case 509: {
                return new RetriableAccessDeniedException(buffer.toString(), failure);
            }
        }
        return new InteroperabilityException(buffer.toString(), failure);
    }
}

