/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.io.Buffer;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.log4j.Logger;

public class BufferOutputStream
extends ProxyOutputStream {
    private static final Logger log = Logger.getLogger((String)BufferOutputStream.class.getName());
    private final Buffer buffer;
    private Long offset;

    public BufferOutputStream(Buffer buffer) {
        this((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, buffer, 0L);
    }

    public BufferOutputStream(Buffer buffer, Long offset) {
        this((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, buffer, offset);
    }

    public BufferOutputStream(OutputStream proxy, Buffer buffer, Long offset) {
        super(proxy);
        this.buffer = buffer;
        this.offset = offset;
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Buffer %d bytes at offset %d", len, this.offset));
        }
        byte[] chunk = new byte[len];
        System.arraycopy(bytes, off, chunk, 0, len);
        if (this.buffer.write(chunk, this.offset) != len) {
            log.warn((Object)String.format("Failure buffering chunk of size %d", len));
        }
        super.write(bytes, off, len);
    }

    protected void afterWrite(int n) {
        this.offset = this.offset + (long)n;
    }
}

