/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.features.Vault;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class VaultFactory
extends Factory<Vault> {
    private static final Logger log = Logger.getLogger(VaultFactory.class);

    protected VaultFactory() {
        super("factory.vault.class");
    }

    public static Vault get(Path directory, String masterkey, byte[] pepper) {
        return new VaultFactory().create(directory, masterkey, pepper);
    }

    private Vault create(Path directory, String masterkey, byte[] pepper) {
        try {
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{directory.getClass(), masterkey.getClass(), pepper.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", directory.getClass()));
                return (Vault)this.clazz.newInstance();
            }
            return (Vault)constructor.newInstance(directory, masterkey, pepper);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
            return Vault.DISABLED;
        }
    }
}

