searchData={"items":[{"type":"module","title":"alarm_handler","doc":"An Alarm Handling Process\n\nThe alarm handler process is a `m:gen_event` event manager process that receives\nalarms in the system. This process is not intended to be a complete alarm\nhandler. It defines a place to which alarms can be sent. One simple event\nhandler is installed in the alarm handler at startup, but users are encouraged\nto write and install their own handlers.\n\nThe simple event handler sends all alarms as info reports to the error logger,\nand saves all in a list. This list can be passed to a user-defined event\nhandler, which can be installed later. The list can grow large if many alarms\nare generated. This is a good reason to install a better user-defined handler.\n\nFunctions are provided to set and clear alarms. The alarm format is defined by\nthe user. For example, an event handler for SNMP can be defined, together with\nan alarm Management Information Base (MIB).\n\nThe alarm handler is part of the SASL application.\n\nWhen writing new event handlers for the alarm handler, the following events must\nbe handled:\n\n- **`{set_alarm, {AlarmId, AlarmDescr}}`** - This event is generated by\n  [`alarm_handler:set_alarm({AlarmId, AlarmDecsr})`](`alarm_handler:set_alarm/1`).\n\n- **`{clear_alarm, AlarmId}`** - This event is generated by\n  [`alarm_handler:clear_alarm(AlarmId)`](`alarm_handler:clear_alarm/1`).\n\nThe default simple handler is called `alarm_handler` and it can be exchanged by\ncalling `gen_event:swap_handler/3` as\n[`gen_event:swap_handler(alarm_handler, {alarm_handler, swap}, {NewHandler, Args})`](`gen_event:swap_handler/3`).\n`NewHandler:init({Args, {alarm_handler, Alarms}})` is called. For more details,\nsee `m:gen_event` in STDLIB.","ref":"alarm_handler.html"},{"type":"module","title":"See Also - alarm_handler","doc":"`m:error_logger`, `m:gen_event`","ref":"alarm_handler.html#module-see-also"},{"type":"type","title":"alarm_handler.alarm/0","doc":"","ref":"alarm_handler.html#t:alarm/0"},{"type":"type","title":"alarm_handler.alarm_id/0","doc":"","ref":"alarm_handler.html#t:alarm_id/0"},{"type":"function","title":"alarm_handler.clear_alarm/1","doc":"Sends event `clear_alarm` to all event handlers.\n\nWhen receiving this event, the default simple handler clears the latest received\nalarm with id `AlarmId`.","ref":"alarm_handler.html#clear_alarm/1"},{"type":"function","title":"alarm_handler.get_alarms/0","doc":"Returns a list of all active alarms. This function can only be used when the\nsimple handler is installed.","ref":"alarm_handler.html#get_alarms/0"},{"type":"function","title":"alarm_handler.set_alarm/1","doc":"Sends event `set_alarm` to all event handlers.\n\nWhen receiving this event, the default simple handler stores the alarm.\n`AlarmId` identifies the alarm and is used when the alarm is cleared.","ref":"alarm_handler.html#set_alarm/1"},{"type":"module","title":"rb","doc":"The Report Browser Tool\n\nThe Report Browser (RB) tool is used to browse and format error reports written\nby the error logger handler `m:log_mf_h` in STDLIB.","ref":"rb.html"},{"type":"type","title":"rb.filter/0","doc":"","ref":"rb.html#t:filter/0"},{"type":"function","title":"rb.filter/1","doc":"Equivalent to  filter/2 .","ref":"rb.html#filter/1"},{"type":"function","title":"rb.filter/2","doc":"Displays the reports that match the provided filters.\n\nWhen a filter includes the `no` atom, it excludes the reports that match that\nfilter.\n\nThe reports are matched using the `m:proplists` module in STDLIB. The report\nmust be a proplist to be matched against any of the filters.\n\nIf the filter has the form `{Key, RegExp, re}`, the report must contain an\nelement with key equal to `Key` and the value must match the regular expression\n`RegExp`.\n\nIf parameter `Dates` is specified, the reports are filtered according to the\ndate when they occurred. If `Dates` has the form `{DateFrom, from}`, reports\nthat occurred after `DateFrom` are displayed.\n\nIf `Dates` has the form `{DateTo, to}`, reports that occurred before `DateTo`\nare displayed.\n\nIf two `Dates` are specified, reports that occurred between those dates are\nreturned.\n\nTo filter only by dates, specify the empty list as the `Filters` parameter.\n\nFor details about parameter `RegExp`, see `rb:grep/1`.\n\nFor details about data type `mp()`, see `t:re:mp/0`.\n\nFor details about data type `datetime()`, see `t:calendar:datetime/0`.","ref":"rb.html#filter/2"},{"type":"function","title":"rb.grep/1","doc":"All reports matching the regular expression `RegExp` are displayed. `RegExp` can\nbe any of the following:\n\n- A string containing the regular expression\n- A tuple with the string and the options for compilation\n- A compiled regular expression\n- A compiled regular expression and the options for running it\n\nFor a definition of valid regular expressions and options, see the `m:re` module\nin STDLIB and in particular function `re:run/3`.\n\nFor details about data type `mp()`, see `t:re:mp/0`.","ref":"rb.html#grep/1"},{"type":"function","title":"rb.h/0","doc":"Equivalent to  help() .","ref":"rb.html#h/0"},{"type":"function","title":"rb.help/0","doc":"Displays online help information.","ref":"rb.html#help/0"},{"type":"function","title":"rb.list/0","doc":"Equivalent to  list(all) .","ref":"rb.html#list/0"},{"type":"function","title":"rb.list/1","doc":"Lists all reports loaded in `rb_server`. Each report is given a unique number\nthat can be used as a reference to the report in function `show/1`.\n\nIf no `Type` is specified, all reports are listed.","ref":"rb.html#list/1"},{"type":"function","title":"rb.log_list/0","doc":"Equivalent to  log_list(all) .","ref":"rb.html#log_list/0"},{"type":"function","title":"rb.log_list/1","doc":"Same as functions `list/0` or `list/1`, but the result is printed to a log file,\nif set; otherwise to `standard_io`.\n\nIf no `Type` is specified, all reports are listed.","ref":"rb.html#log_list/1"},{"type":"type","title":"rb.option/0","doc":"","ref":"rb.html#t:option/0"},{"type":"type","title":"rb.regexp/0","doc":"","ref":"rb.html#t:regexp/0"},{"type":"function","title":"rb.rescan/0","doc":"Equivalent to  rescan([]) .","ref":"rb.html#rescan/0"},{"type":"function","title":"rb.rescan/1","doc":"Rescans the report directory. `Options` is the same as for function `start/1`.","ref":"rb.html#rescan/1"},{"type":"function","title":"rb.show/0","doc":"All reports are displayed.","ref":"rb.html#show/0"},{"type":"function","title":"rb.show/1","doc":"If argument `Report` is specified as one of the values of\n[`type()`](`t:type/0`), all loaded reports of that type are\ndisplayed. If `Report` is specified as an integer, the report with\nthis reference number is displayed.","ref":"rb.html#show/1"},{"type":"function","title":"rb.start/0","doc":"Equivalent to  start([]) .","ref":"rb.html#start/0"},{"type":"function","title":"rb.start/1","doc":"Function [`start/1`](`start/1`) starts `rb_server` with the specified options,\nwhereas function `start/0` starts with default options.\n\n`rb_server` must be started before reports can be browsed. When\n`rb_server` is started, the files in the specified directory are\nscanned. The other functions assume that the server has started.\n\n_Options:_\n\n- **`{start_log, FileName}`** - Starts logging to file, registered name, or\n  `io_device`. All reports are printed to the specified destination. Default is\n  `standard_io`. Option `{start_log, standard_error}` is not allowed and will be\n  replaced by default `standard_io`.\n\n- **`{max, MaxNoOfReports}`** - Controls how many reports `rb_server` is to read\n  at startup. This option is useful, as the directory can contain a large amount\n  of reports. If this option is specified, the `MaxNoOfReports` latest reports\n  are read. Default is `all`.\n\n- **`{report_dir, DirString}`** - Defines the directory where the error log\n  files are located. Default is the directory specified by application\n  environment variable `error_logger_mf_dir`, see [sasl(6)](sasl_app.md).\n\n- **`{type, ReportType}`** - Controls what kind of reports `rb_server` is to\n  read at startup. `ReportType` is a supported type, `all`, or a list of\n  supported types. Default is `all`.\n\n- **`{abort_on_error, Bool}`** - Specifies if logging is to be ended if `rb`\n  encounters an unprintable report. (You can get a report with an incorrect form\n  if function `error_logger`, `error_msg`, or `info_msg` has been called with an\n  invalid format string)\n\n  - If `Bool` is `true`, `rb` stops logging (and prints an error message to\n    `stdout`) if it encounters a badly formatted report. If logging to file is\n    enabled, an error message is appended to the log file as well.\n  - If `Bool` is `false` (the default value), `rb` prints an error message to\n    `stdout` for every bad report it encounters, but the logging process is\n    never ended. All printable reports are written. If logging to file is\n    enabled, `rb` prints `* UNPRINTABLE REPORT *` in the log file at the\n    location of an unprintable report.","ref":"rb.html#start/1"},{"type":"function","title":"rb.start_log/1","doc":"Redirects all report output from the RB tool to the specified file, registered\nname, or `io_device`.","ref":"rb.html#start_log/1"},{"type":"function","title":"rb.stop/0","doc":"Stops `rb_server`.","ref":"rb.html#stop/0"},{"type":"function","title":"rb.stop_log/0","doc":"Closes the log file. The output from the RB tool is directed to `standard_io`.","ref":"rb.html#stop_log/0"},{"type":"type","title":"rb.type/0","doc":"","ref":"rb.html#t:type/0"},{"type":"module","title":"release_handler","doc":"Unpacking and Installation of Release Packages\n\nThe _release handler_ process belongs to the SASL application, which is\nresponsible for _release handling_, that is, unpacking, installation, and\nremoval of release packages.\n\nAn introduction to release handling and an example is provided by\n[Release Handling section in OTP Design Principles](`e:system:release_handling.md`).\n\nA _release package_ is a compressed tar file containing code for a certain\nversion of a release, created by calling\n[`systools:make_tar/1,2`](`systools:make_tar/1`). The release package is to be\nlocated in the `$ROOT/releases` directory of the previous version of the\nrelease, where `$ROOT` is the installation root directory,\n[`code:root_dir()`](`code:root_dir/0`). Another `releases` directory can be\nspecified using the SASL configuration parameter `releases_dir` or the OS\nenvironment variable `RELDIR`. The release handler must have write access to\nthis directory to install the new release. The persistent state of the release\nhandler is stored there in a file called `RELEASES`.\n\nA release package is always to contain:\n\n- A release resource file, `Name.rel`\n- A boot script, `Name.boot`\n\nThe `.rel` file contains information about the release: its name, version, and\nwhich ERTS and application versions it uses.\n\nA release package can also contain:\n\n- A release upgrade file, `relup`\n- A system configuration file, `sys.config`\n- A system configuration source file, `sys.config.src`\n\nThe `relup` file contains instructions for how to upgrade to, or downgrade from,\nthis version of the release.\n\nThe release package can be _unpacked_, which extracts the files. An unpacked\nrelease can be _installed_. The currently used version of the release is then\nupgraded or downgraded to the specified version by evaluating the instructions\nin the `relup` file. An installed release can be made _permanent_. Only one\npermanent release can exist in the system, and this release is used if the\nsystem is restarted. An installed release, except the permanent one, can be\n_removed_. When a release is removed, all files belonging to that release only\nare deleted.\n\nEach release version has a status, which can be `unpacked`, `current`,\n`permanent`, or `old`. There is always one latest release, which either has\nstatus `permanent` (normal case) or `current` (installed, but not yet made\npermanent). The meaning of the status values are illustrated in the following\ntable:\n\n```text\n        Status     Action                NextStatus\n        -------------------------------------------\n        -          unpack                unpacked\n        unpacked   install               current\n                   remove                -\n        current    make_permanent        permanent\n                   install other         old\n                   remove                -\n        permanent  make other permanent  old\n                   install               permanent\n        old        reboot_old            permanent\n                   install               current\n                   remove                -\n```\n\nThe release handler process is a locally registered process on each node. When a\nrelease is installed in a distributed system, the release handler on each node\nmust be called. The release installation can be synchronized between nodes. From\nan operator view, it can be unsatisfactory to specify each node. The aim is to\ninstall one release package in the system, no matter how many nodes there are.\nIt is recommended that software management functions are written that take care\nof this problem. Such a function can have knowledge of the system architecture,\nso it can contact each individual release handler to install the package.\n\nFor release handling to work properly, the runtime system must know which\nrelease it is running. It must also be able to change (in runtime) which boot\nscript and system configuration file are to be used if the system is restarted.\nThis is taken care of automatically if Erlang is started as an embedded system.\nRead about this in [Embedded System](`e:system:index.html`) in _System\nDocumentation_. In this case, the system configuration file `sys.config` is\nmandatory.\n\nThe installation of a new release can restart the system. Which program to use\nis specified by the SASL configuration parameter `start_prg`, which defaults to\n`$ROOT/bin/start`.\n\nThe emulator restart on Windows NT expects that the system is started using the\n`erlsrv` program (as a service). Furthermore, the release handler expects that\nthe service is named `NodeName`\\_`Release`, where `NodeName` is the first part\nof the Erlang node name (up to, but not including the \"@\") and `Release` is the\ncurrent release version. The release handler furthermore expects that a program\nlike `start_erl.exe` is specified as \"machine\" to `erlsrv`. During upgrading\nwith restart, a new service is registered and started. The new service is set to\nautomatic and the old service is removed when the new release is made permanent.\n\nThe release handler at a node running on a diskless machine, or with a read-only\nfile system, must be configured accordingly using the following SASL\nconfiguration parameters (for details, see [sasl(6)](sasl_app.md)):\n\n- **`masters`** - This node uses some master nodes to store and fetch release\n  information. All master nodes must be operational whenever release information\n  is written by this node.\n\n- **`client_directory`** - The `client_directory` in the directory structure of\n  the master nodes must be specified.\n\n- **`static_emulator`** - This parameter specifies if the Erlang emulator is\n  statically installed at the client node. A node with a static emulator cannot\n  dynamically switch to a new emulator, as the executable files are statically\n  written into memory.\n\nThe release handler can also be used to unpack and install release packages when\nnot running Erlang as an embedded system. However, in this case the user must\nsomehow ensure that correct boot scripts and configuration files are used if the\nsystem must be restarted.\n\nFunctions are provided for using another file structure than the structure\ndefined in OTP. These functions can be used to test a release upgrade locally.","ref":"release_handler.html"},{"type":"module","title":"Typical Error Reasons - release_handler","doc":"- **`{bad_masters, Masters}`** - The master nodes `Masters` are not alive.\n\n- **`{bad_rel_file, File}`** - Specified `.rel` file `File` cannot be read or\n  does not contain a single term.\n\n- **`{bad_rel_data, Data}`** - Specified `.rel` file does not contain a\n  recognized release specification, but another term `Data`.\n\n- **`{bad_relup_file, File}`** - Specified `relup` file `Relup` contains bad\n  data.\n\n- **`{cannot_extract_file, Name, Reason}`** - Problems when extracting from a\n  tar file, `erl_tar:extract/2` returned `{error, {Name, Reason}}`.\n\n- **`{existing_release, Vsn}`** - Specified release version `Vsn` is already in\n  use.\n\n- **`{Master, Reason, When}`** - Some operation, indicated by the term `When`,\n  failed on the master node `Master` with the specified error reason `Reason`.\n\n- **`{no_matching_relup, Vsn, CurrentVsn}`** - Cannot find a script for\n  upgrading/downgrading between `CurrentVsn` and `Vsn`.\n\n- **`{no_such_directory, Path}`** - The directory `Path`does not exist.\n\n- **`{no_such_file, Path}`** - The path `Path` (file or directory) does not\n  exist.\n\n- **`{no_such_file, {Master, Path}}`** - The path `Path` (file or directory)\n  does not exist at the master node `Master`.\n\n- **`{no_such_release, Vsn}`** - The specified release version `Vsn` does not\n  exist.\n\n- **`{not_a_directory, Path}`** - `Path` exists but is not a directory.\n\n- **`{Posix, File}`** - Some file operation failed for `File`. `Posix` is an\n  atom named from the Posix error codes, such as `enoent`, `eacces`, or\n  `eisdir`. See `m:file` in Kernel.\n\n- **`Posix`** - Some file operation failed, as for the previous item in the\n  list.","ref":"release_handler.html#module-typical-error-reasons"},{"type":"module","title":"Application Upgrade/Downgrade - release_handler","doc":"The functions in the [Application Upgrade/Downgrade](#application-upgrade-downgrade)\nsection can be used to test upgrade and downgrade of single applications\n(instead of upgrading/downgrading an entire release). A script corresponding to\nthe instructions in the relup file is created on-the-fly, based on the .appup\nfile for the application, and evaluated exactly in the same way as\nrelease_handler does.\n\n> #### Warning {: .warning }\n>\n> These functions are primarily intended for simplified testing of .appup files.\n> They are not run within the context of the release_handler process.\n> They must therefore not be used together with calls to install_release/1,2,\n> as this causes the release_handler to end up in an inconsistent state.\n>\n> No persistent information is updated, so these functions can be used on ay\n> Erlang node, embedded or not. Also, using these functions does not affect which\n> code is loaded if there is a reboot.\n>\n> If the upgrade or downgrade fails, the application can end up in an\n> inconsistent state.","ref":"release_handler.html#module-application-upgrade-downgrade"},{"type":"module","title":"See Also - release_handler","doc":"[OTP Design Principles](`e:system:index.html`),\n[`config`](`e:kernel:config.md`), [`rel`](rel.md), [`relup`](relup.md),\n[`script`](script.md), `m:sys`, `m:systools`","ref":"release_handler.html#module-see-also"},{"type":"function","title":"release_handler.check_install_release/1","doc":"Equivalent to  check_install_release(Vsn, []) .","ref":"release_handler.html#check_install_release/1"},{"type":"function","title":"release_handler.check_install_release/2","doc":"Checks if the specified version `Vsn` of the release can be installed.\n\nThe release must not have status `current`. Issues warnings if `relup` file or\n`sys.config` is not present. If `relup` file is present, its contents are\nchecked and `{error,Reason}` is returned if an error is found. Also checks that\nall required applications are present and that all new code can be loaded;\n`{error,Reason}` is returned if an error is found.\n\nEvaluates all instructions that occur before the `point_of_no_return`\ninstruction in the release upgrade script.\n\nReturns the same as `install_release/1`. `Descr` defaults to \"\" if no `relup`\nfile is found.\n\nIf option `purge` is specified, all old code that can be soft-purged is purged\nafter all other checks are successfully completed. This can be useful to reduce\nthe time needed by `install_release/1`.","ref":"release_handler.html#check_install_release/2"},{"type":"function","title":"release_handler.create_RELEASES/3","doc":"Equivalent to  create_RELEASES(\"\", RelDir, RelFile, Appdirs) .","ref":"release_handler.html#create_RELEASES/3"},{"type":"function","title":"release_handler.create_RELEASES/4","doc":"Creates an initial `RELEASES` file to be used by the release handler.\n\nThis file must exist to install new releases.\n\n`Root` is the root of the installation (`$ROOT`) as described earlier. `RelDir`\nis the directory where the `RELEASES` file is to be created (normally\n`$ROOT/releases`). `RelFile` is the name of the `.rel` file that describes the\ninitial release, including the extension `.rel`. If `Root` is not given, the\n`RELEASES` file will be location independent (i.e, it will not contain absolute\npaths unless there are absolute paths in `AppDirs`). A `RELEASES` file should be\nmade location independent if the installation's `$ROOT` is unknown. The\n`release_handler` module will interpret relative paths in a running system's\n`RELEASES` file as being relative to `$ROOT`.\n\n`AppDirs` can be used to specify from where the modules for the specified\napplications are to be loaded. `App` is the name of an application, `Vsn` is the\nversion, and `Dir` is the name of the directory where `App-Vsn` is located. The\ncorresponding modules are to be located under `Dir/App-Vsn/ebin`. The\ndirectories for applications not specified in `AppDirs` are assumed to be\nlocated in `$ROOT/lib`.","ref":"release_handler.html#create_RELEASES/4"},{"type":"function","title":"release_handler.downgrade_app/2","doc":"Equivalent to  downgrade_app/3 .","ref":"release_handler.html#downgrade_app/2"},{"type":"function","title":"release_handler.downgrade_app/3","doc":"Downgrades an application `App` from the current version to a previous version\n`OldVsn` located in `Dir` according to the `.appup` file.\n\n`App` is the name of the application, which must be started. `OldVsn` is the\nprevious application version and can be omitted if `Dir` is of the format\n`\"App-OldVsn\"`. `Dir` is the library directory of the previous version of `App`.\nThe corresponding modules and the old `.app` file are to be located under\n`Dir/ebin`. The `.appup` file is to be located in the `ebin` directory of the\n_current_ library directory of the application\n([`code:lib_dir(App)`](`code:lib_dir/1`)).\n\nThe function looks in the `.appup` file and tries to find a downgrade script to\nthe previous version of the application using `downgrade_script/3`. This script\nis evaluated using `eval_appup_script/4`, exactly in the same way as\n[`install_release/1,2`](`install_release/1`) does.\n\nReturns one of the following:\n\n- `{ok, Unpurged}` if evaluating the script is successful, where `Unpurged` is a\n  list of unpurged modules\n- `restart_emulator` if this instruction is encountered in the script\n- `{error, Reason}` if an error occurred when finding or evaluating the script","ref":"release_handler.html#downgrade_app/3"},{"type":"function","title":"release_handler.downgrade_script/3","doc":"Tries to find an application downgrade script for `App` from the current version\nto a previous version `OldVsn` located in `Dir`.\n\nThe downgrade script can then be evaluated using `eval_appup_script/4`. It is\nrecommended to use [`downgrade_app/2,3`](`downgrade_app/3`) instead, but this\nfunction (`downgrade_script`) is useful to inspect the contents of the script.\n\n`App` is the name of the application, which must be started. `Dir` is the\nprevious library directory of `App`. The corresponding modules and the old\n`.app` file are to be located under `Dir/ebin`. The `.appup` file is to be\nlocated in the `ebin` directory of the _current_ library directory of the\napplication ([`code:lib_dir(App)`)](`code:lib_dir/1`).\n\nThe function looks in the `.appup` file and tries to find a downgrade script\nfrom the current application version. High-level instructions are translated to\nlow-level instructions. The instructions are sorted in the same manner as when\ngenerating a `relup` file.\n\nReturns `{ok, Script}` if successful. For details about `Script`, see\n[`appup(4)`](appup.md).\n\nFailure: If a script cannot be found, the function fails with an appropriate\nerror reason.","ref":"release_handler.html#downgrade_script/3"},{"type":"function","title":"release_handler.eval_appup_script/4","doc":"Evaluates an application upgrade or downgrade script `Script`, the result from\ncalling `upgrade_script/2` or `downgrade_script/3`, exactly in the same way as\n[`install_release/1,2`](`install_release/1`) does.\n\n`App` is the name of the application, which must be started. `ToVsn` is the\nversion to be upgraded/downgraded to, and `ToDir` is the library directory of\nthis version. The corresponding modules as well as the `.app` and `.appup` files\nare to be located under `Dir/ebin`.\n\nReturns one of the following:\n\n- `{ok, Unpurged}` if evaluating the script is successful, where `Unpurged` is a\n  list of unpurged modules\n- `restart_emulator` if this instruction is encountered in the script\n- `{error, Reason}` if an error occurred when finding or evaluating the script\n\nIf the `restart_new_emulator` instruction is found in the script,\n`eval_appup_script/4` returns `{error,restart_new_emulator}`. This because\n`restart_new_emulator` requires a new version of the emulator to be started\nbefore the rest of the upgrade instructions can be executed, and this can only\nbe done by [`install_release/1,2`](`install_release/1`).","ref":"release_handler.html#eval_appup_script/4"},{"type":"function","title":"release_handler.install_file/2","doc":"Installs a release-dependent file in the release structure.\n\nThe release-dependent file must be in the release structure when a new release\nis installed: `start.boot`, `relup`, and `sys.config`.\n\nThe function can be called, for example, when these files are generated at the\ntarget. The function is to be called after `set_unpacked/2` has been called.","ref":"release_handler.html#install_file/2"},{"type":"function","title":"release_handler.install_release/1","doc":"Equivalent to  install_release(Vsn, []) .","ref":"release_handler.html#install_release/1"},{"type":"function","title":"release_handler.install_release/2","doc":"Installs the specified version `Vsn` of the release.\n\nLooks first for a `relup` file for `Vsn` and a script\n`{UpFromVsn,Descr1,Instructions1}` in this file for upgrading from the\ncurrent version. If not found, the function looks for a `relup` file\nfor the current version and a script `{Vsn,Descr2,Instructions2}` in\nthis file for downgrading to `Vsn`.\n\nIf a script is found, the first thing that happens is that the application\nspecifications are updated according to the `.app` files and `sys.config`\nbelonging to the release version `Vsn`.\n\nAfter the application specifications have been updated, the instructions in the\nscript are evaluated and the function returns `{ok,OtherVsn,Descr}` if\nsuccessful. `OtherVsn` and `Descr` are the version (`UpFromVsn` or `Vsn`) and\ndescription (`Descr1` or `Descr2`) as specified in the script.\n\nIf `{continue_after_restart,OtherVsn,Descr}` is returned, the emulator is\nrestarted before the upgrade instructions are executed. This occurs if the\nemulator or any of the applications Kernel, STDLIB, or SASL are updated. The new\nemulator version and these core applications execute after the restart. For all\nother applications the old versions are started and the upgrade is performed as\nnormal by executing the upgrade instructions.\n\nIf a recoverable error occurs, the function returns `{error,Reason}` and the\noriginal application specifications are restored. If a non-recoverable error\noccurs, the system is restarted.\n\n_Options_:\n\n- **`error_action`** - Defines if the node is to be restarted\n  ([`init:restart()`](`init:restart/0`)) or rebooted\n  ([`init:reboot()`](`init:reboot/0`)) if there is an error during the\n  installation. Default is `restart`.\n\n- **`code_change_timeout`** - Defines the time-out for all calls to\n  [`sys:change_code`](`sys:change_code/4`). If no value is specified or\n  `default` is specified, the default value defined in `sys` is used.\n\n- **`suspend_timeout`** - Defines the time-out for all calls to\n  [`sys:suspend`](`sys:suspend/1`). If no value is specified, the values defined\n  by the `Timeout` parameter of the `upgrade` or `suspend` instructions are\n  used. If `default` is specified, the default value defined in `sys` is used.\n\n- **`{update_paths,Bool}`** - Indicates if all application code paths are to be\n  updated (`Bool==true`) or if only code paths for modified applications are to\n  be updated (`Bool==false`, default). This option has only effect for other\n  application directories than the default `$ROOT/lib/App-Vsn`, that is,\n  application directories specified in argument `AppDirs` in a call to\n  `create_RELEASES/4` or `set_unpacked/2`.\n\n  _Example:_\n\n  In the current version `CurVsn` of a release, the application directory of\n  `myapp` is `$ROOT/lib/myapp-1.0`. A new version `NewVsn` is unpacked outside\n  the release handler and the release handler is informed about this with a call\n  as follows:\n\n  ```erlang\n  release_handler:set_unpacked(RelFile, [{myapp,\"1.0\",\"/home/user\"},...]).\n  => {ok,NewVsn}\n  ```\n\n  If `NewVsn` is installed with option `{update_paths,true}`, then\n  [`code:lib_dir(myapp)`](`code:lib_dir/1`) returns `/home/user/myapp-1.0`.\n\n> #### Note {: .info }\n>\n> Installing a new release can be time consuming if there are many processes in\n> the system. The reason is that each process must be checked for references to\n> old code before a module can be purged. This check can lead to garbage\n> collections and copying of data.\n>\n> To speed up the execution of [`install_release`](`install_release/1`), first\n> call [`check_install_release`](`check_install_release/1`), using option\n> `purge`. This does the same check for old code. Then purges all modules that\n> can be soft-purged. The purged modules do then no longer have any old code,\n> and [`install_release`](`install_release/1`) does not need to do the checks.\n>\n> This does not reduce the overall time for the upgrade, but it allows checks\n> and purge to be executed in the background before the real upgrade is started.\n\n> #### Note {: .info }\n>\n> When upgrading the emulator from a version older than OTP R15, an attempt is\n> made to load new application beam code into the old emulator. Sometimes the\n> new beam format cannot be read by the old emulator, so the code loading fails\n> and the complete upgrade is terminated. To overcome this problem, the new\n> application code is to be compiled with the old emulator. For more information\n> about emulator upgrade from pre OTP R15 versions, see\n> [Design Principles](`e:system:appup_cookbook.md`) in _System Documentation_.","ref":"release_handler.html#install_release/2"},{"type":"function","title":"release_handler.make_permanent/1","doc":"Makes the specified release version `Vsn` permanent.","ref":"release_handler.html#make_permanent/1"},{"type":"function","title":"release_handler.reboot_old_release/1","doc":"Reboots the system by making the old release permanent, and calls\n[`init:reboot()`](`init:reboot/0`) directly.\n\nThe release must have status `old`.","ref":"release_handler.html#reboot_old_release/1"},{"type":"function","title":"release_handler.remove_release/1","doc":"Removes a release and its files from the system.\n\nThe release must not be the permanent release. Removes only the files\nand directories not in use by another release.","ref":"release_handler.html#remove_release/1"},{"type":"function","title":"release_handler.set_removed/1","doc":"Makes it possible to handle removal of releases outside the release handler.\n\nTells the release handler that the release is removed from the system. This\nfunction does not delete any files.","ref":"release_handler.html#set_removed/1"},{"type":"function","title":"release_handler.set_unpacked/2","doc":"Makes it possible to handle unpacking of releases outside the release handler.\n\nTells the release handler that the release is unpacked. `Vsn` is extracted from\nthe release resource file `RelFile`.\n\n`AppDirs` can be used to specify from where the modules for the specified\napplications are to be loaded. `App` is the name of an application, `Vsn` is the\nversion, and `Dir` is the name of the directory where `App-Vsn` is located. The\ncorresponding modules are to be located under `Dir/App-Vsn/ebin`. The\ndirectories for applications not specified in `AppDirs` are assumed to be\nlocated in `$ROOT/lib`.","ref":"release_handler.html#set_unpacked/2"},{"type":"function","title":"release_handler.unpack_release/1","doc":"Unpacks a release package `Name.tar.gz` located in the `releases` directory.\n\nPerforms some checks on the package, for example, checks that all mandatory\nfiles are present, and extracts its contents.","ref":"release_handler.html#unpack_release/1"},{"type":"function","title":"release_handler.upgrade_app/2","doc":"Upgrades an application `App` from the current version to a new version located\nin `Dir` according to the `.appup` file.\n\n`App` is the name of the application, which must be started. `Dir` is the new\nlibrary directory of `App`. The corresponding modules as well as the `.app` and\n`.appup` files are to be located under `Dir/ebin`.\n\nThe function looks in the `.appup` file and tries to find an upgrade script from\nthe current version of the application using `upgrade_script/2`. This script is\nevaluated using `eval_appup_script/4`, exactly in the same way as\n[`install_release/1,2`](`install_release/1`) does.\n\nReturns one of the following:\n\n- `{ok, Unpurged}` if evaluating the script is successful, where `Unpurged` is a\n  list of unpurged modules\n- `restart_emulator` if this instruction is encountered in the script\n- `{error, Reason}` if an error occurred when finding or evaluating the script\n\nIf the `restart_new_emulator` instruction is found in the script,\n`upgrade_app/2` returns `{error,restart_new_emulator}`. This because\n`restart_new_emulator` requires a new version of the emulator to be started\nbefore the rest of the upgrade instructions can be executed, and this can only\nbe done by [`install_release/1,2`](`install_release/1`).","ref":"release_handler.html#upgrade_app/2"},{"type":"function","title":"release_handler.upgrade_script/2","doc":"Tries to find an application upgrade script for `App` from the current version\nto a new version located in `Dir`.\n\nThe upgrade script can then be evaluated using `eval_appup_script/4`. It is\nrecommended to use `upgrade_app/2` instead, but this function (`upgrade_script`)\nis useful to inspect the contents of the script.\n\n`App` is the name of the application, which must be started. `Dir` is the new\nlibrary directory of `App`. The corresponding modules as well as the `.app` and\n`.appup` files are to be located under `Dir/ebin`.\n\nThe function looks in the `.appup` file and tries to find an upgrade script from\nthe current application version. High-level instructions are translated to\nlow-level instructions. The instructions are sorted in the same manner as when\ngenerating a `relup` file.\n\nReturns `{ok, NewVsn, Script}` if successful, where `NewVsn` is the new\napplication version. For details about `Script`, see [`appup(4)`](appup.md).\n\nFailure: If a script cannot be found, the function fails with an appropriate\nerror reason.","ref":"release_handler.html#upgrade_script/2"},{"type":"function","title":"release_handler.which_releases/0","doc":"Returns all releases known to the release handler.","ref":"release_handler.html#which_releases/0"},{"type":"function","title":"release_handler.which_releases/1","doc":"Returns all releases, known to the release handler, of a specific status.","ref":"release_handler.html#which_releases/1"},{"type":"module","title":"systools","doc":"A Set of Release Handling Tools\n\nThis module contains functions to generate boot scripts (`.boot`, `.script`), a\nrelease upgrade file (`relup`), and release packages.","ref":"systools.html"},{"type":"module","title":"See Also - systools","doc":"[`app(4)`](`e:kernel:app.md`), [`appup(4)`](appup.md),\n[`erl(1)`](`e:erts:erl_cmd.md`), [`rel(4)`](rel.md), `m:release_handler`,\n[`relup(4)`](relup.md), [`script(4)`](script.md)","ref":"systools.html#module-see-also"},{"type":"function","title":"systools.make_relup/3","doc":"Equivalent to  make_relup(Name, UpFrom, DownTo, []) .","ref":"systools.html#make_relup/3"},{"type":"function","title":"systools.make_relup/4","doc":"Generates a release upgrade file `relup` containing instructions for upgrading\nfrom or downgrading to one or more previous releases.\n\nThe instructions are used by `m:release_handler` when installing a new\nversion of a release in runtime.\n\nBy default, the `relup` file is located in the current working directory. If option\n`{outdir,Dir}` is specified, the `relup` file is located in directory `Dir` instead.\n\nThe release resource file `Name.rel` is compared with all release resource files\n`Name2.rel`, specified in `UpFrom` and `DownTo`. For each such pair, the\nfollowing is deducted:\n\n- Which applications to be deleted, that is, applications listed in `Name.rel`\n  but not in `Name2.rel`\n- Which applications to be added, that is, applications listed in `Name2.rel`\n  but not in `Name.rel`\n- Which applications to be upgraded/downgraded, that is, applications listed in\n  both `Name.rel` and `Name2.rel` but with different versions\n- If the emulator needs to be restarted after upgrading or downgrading, that is,\n  if the ERTS version differs between `Name.rel` and `Name2.rel`\n\nInstructions for this are added to the `relup` file in the above order.\nInstructions for upgrading or downgrading between application versions are\nfetched from the relevant application upgrade files `App.appup`, sorted in the\nsame order as when generating a boot script, see\n[`make_script/1,2`](`make_script/2`). High-level instructions are translated\ninto low-level instructions and the result is printed to the `relup` file.\n\nThe optional `Descr` parameter is included \"as is\" in the `relup` file, see\n[`relup(4)`](relup.md). Defaults to the empty list.\n\nAll the files are searched for in the code path. It is assumed that the `.app`\nand `.appup` files for an application are located in the same directory.\n\nIf option `{path,[Dir]}` is specified, this path is appended to the current\npath. Wildcard `*` is expanded to all matching directories, for example,\n`lib/*/ebin`.\n\nIf option `restart_emulator` is specified, a low-level instruction to restart\nthe emulator is appended to the `relup` file. This ensures that a complete\nreboot of the system is done when the system is upgraded or downgraded.\n\nIf an upgrade includes a change from an emulator earlier than OTP R15 to OTP R15\nor later, the warning `pre_R15_emulator_upgrade` is issued. For more information\nabout this, see [Design Principles](`e:system:appup_cookbook.md`) in _System\nDocumentation_.\n\nBy default, errors and warnings are printed to tty and the function returns `ok`\nor `error`. If option `silent` is specified, the function instead either returns\n`{ok,Relup,Module,Warnings}`, where `Relup` is the release upgrade file, or\n`{error,Module,Error}`. Warnings and errors can be converted to strings by\ncalling `Module:format_warning(Warnings)` or `Module:format_error(Error)`.\n\nIf option `noexec` is specified, the function returns the same values as for\n`silent` but no `relup` file is created.\n\nIf option `warnings_as_errors` is specified, warnings are treated as errors.","ref":"systools.html#make_relup/4"},{"type":"function","title":"systools.make_script/1","doc":"Equivalent to  make_script/2 .","ref":"systools.html#make_script/1"},{"type":"function","title":"systools.make_script/2","doc":"Generates a boot script `Name.script` and its binary version, the boot file\n`Name.boot`, unless the `{script_name, ScriptName}` option is given, in which\ncase the names are `ScriptName.script` and `ScriptName.boot`.\n\nThe boot file specifies which code to be loaded and which\napplications to be started when the Erlang runtime system is\nstarted. See [`script(4)`](script.md).\n\nThe release resource file `Name.rel` is read to determine which applications are\nincluded in the release. Then the relevant application resource files `App.app`\nare read to determine which modules to be loaded, and if and how the\napplications are to be started. (Keys `modules` and `mod`, see\n[`app(4)`](`e:kernel:app.md`).\n\nBy default, the boot script and boot file are located in the same directory as\n`Name.rel`. That is, in the current working directory unless `Name` contains a\npath. If option `{outdir,Dir}` is specified, they are located in `Dir` instead.\n\nThe correctness of each application is checked as follows:\n\n- The version of an application specified in the `.rel` file is to be the same\n  as the version specified in the `.app` file.\n- There are to be no undefined applications, that is, dependencies to\n  applications that are not included in the release. (Key `applications` in the\n  `.app` file).\n- There are to be no circular dependencies among the applications.\n- There are to be no duplicated modules, that is, modules with the same name but\n  belonging to different applications.\n- If option `src_tests` is specified, a warning is issued if the source code for\n  a module is missing or is newer than the object code.\n\nThe applications are sorted according to the dependencies between the\napplications. Where there are no dependencies, the order in the `.rel` file is\nkept.\n\nThe function fails if the mandatory applications Kernel and STDLIB are not\nincluded in the `.rel` file and have start type `permanent` (which is default).\n\nIf SASL is not included as an application in the `.rel` file, a warning is\nissued because such a release cannot be used in an upgrade. To turn off this\nwarning, add option `no_warn_sasl`.\n\nAll files are searched for in the current path. It is assumed that the `.app`\nand `.beam` files for an application are located in the same directory. The\n`.erl` files are also assumed to be located in this directory, unless it is an\n`ebin` directory in which case they can be located in the corresponding `src`\ndirectory.\n\nIf option `{path,[Dir]}` is specified, this path is appended to the current\npath. A directory in the path can be specified with a wildcard `*`, this is\nexpanded to all matching directories. Example: `\"lib/*/ebin\"`.\n\nIn the generated boot script all application directories are structured as\n`App-Vsn/ebin`. They are assumed to be located in `$ROOT/lib`, where `$ROOT` is\nthe root directory of the installed release. If option `local` is specified, the\nactual directories where the applications were found are used instead. This is a\nuseful way to test a generated boot script locally.\n\nOption `variables` can be used to specify an installation directory other than\n`$ROOT/lib` for some of the applications. If a variable `{VarName,Prefix}` is\nspecified and an application is found in a directory\n`Prefix/Rest/App[-Vsn]/ebin`, this application gets the path\n`VarName/Rest/App-Vsn/ebin` in the boot script. If an application is found in a\ndirectory `Prefix/Rest`, the path is `VarName/Rest/App-Vsn/ebin`. When starting\nErlang, all variables `VarName` are given values using command-line flag\n`boot_var`.\n\n_Example:_ If option `{variables,[{\"TEST\",\"lib\"}]}` is specified and `myapp.app`\nis found in `lib/myapp/ebin`, the path to this application in the boot script is\n`\"$TEST/myapp-1/ebin\"`. If `myapp.app` is found in `lib/test`, the path is\n`$TEST/test/myapp-1/ebin`.\n\nThe checks performed before the boot script is generated can be extended with\nsome cross reference checks by specifying option `exref`. These checks are\nperformed with the Xref tool. All applications, or the applications specified\nwith `{exref,[App]}`, are checked by Xref and warnings are issued for calls to\nundefined functions.\n\nBy default, errors and warnings are printed to tty and the function returns `ok`\nor `error`. If option `silent` is specified, the function instead returns\n`{ok,Module,Warnings}` or `{error,Module,Error}`. Warnings and errors can be\nconverted to strings by calling `Module:format_warning(Warnings)` or\n`Module:format_error(Error)`.\n\nIf option `warnings_as_errors` is specified, warnings are treated as errors.\n\nIf option `no_dot_erlang` is specified, the instruction to load the `.erlang`\nfile during boot is _not_ included.","ref":"systools.html#make_script/2"},{"type":"function","title":"systools.make_tar/1","doc":"Equivalent to  make_tar(Name, []) .","ref":"systools.html#make_tar/1"},{"type":"function","title":"systools.make_tar/2","doc":"Creates a release package file `Name.tar.gz`.\n\nThis file must be uncompressed and unpacked on the target system using\n`m:release_handler` before the new release can be installed.\n\nThe release resource file `Name.rel` is read to determine which applications are\nincluded in the release. Then the relevant application resource files `App.app`\nare read to determine the version and modules of each application (keys `vsn`\nand `modules`, see [`app(4)`](`e:kernel:app.md`)).\n\nBy default, the release package file is located in the same directory as\n`Name.rel`. That is, in the current working directory unless `Name` contains a\npath. If option `{outdir,Dir}` is specified, it is located in `Dir` instead.\n\nIf SASL is not included as an application in the `.rel` file, a warning is\nissued because such a release cannot be used in an upgrade. To turn off this\nwarning, add option `no_warn_sasl`.\n\nBy default, the release package contains the directories `lib/App-Vsn/ebin` and\n`lib/App-Vsn/priv` for each included application. If more directories are to be\nincluded, option `dirs` is specified, for example, `{dirs,[src,examples]}`.\n\nAll these files are searched for in the current path. If option `{path,[Dir]}`\nis specified, this path is appended to the current path. Wildcard `*` is\nexpanded to all matching directories. Example: `\"lib/*/ebin\"`.\n\nIf the `{extra_files, ExtraFiles}` option is given then the `ExtraFiles` are\nadded to the tarball after everything else to be included has been added.\n\nOption `variables` can be used to specify an installation directory other than\n`lib` for some of the applications. If variable `{VarName,Prefix}` is specified\nand an application is found in directory `Prefix/Rest/App[-Vsn]/ebin`, this\napplication is packed into a separate `VarName.tar.gz` file as\n`Rest/App-Vsn/ebin`.\n\n_Example:_ If option `{variables,[{\"TEST\",\"lib\"}]}` is specified and `myapp.app`\nis located in `lib/myapp-1/ebin`, application `myapp` is included in\n`TEST.tar.gz`:\n\n```text\n% tar tf TEST.tar\nmyapp-1/ebin/myapp.app\n...\n```\n\nOption `{var_tar,VarTar}` can be used to specify if and where a separate package\nis to be stored. In this option `VarTar` is one of the following:\n\n- **`include`** - Each separate (variable) package is included in the main\n  `ReleaseName.tar.gz` file. This is the default.\n\n- **`ownfile`** - Each separate (variable) package is generated as a separate\n  file in the same directory as the `ReleaseName.tar.gz` file.\n\n- **`omit`** - No separate (variable) packages are generated. Applications that\n  are found underneath a variable directory are ignored.\n\nA directory `releases` is also included in the release package, containing\n`Name.rel` and a subdirectory `RelVsn`. `RelVsn` is the release version as\nspecified in `Name.rel`.\n\n`releases/RelVsn` contains the boot script `Name.boot` renamed to `start.boot`\nand, if found, the files `relup` and `sys.config` or `sys.config.src`. These\nfiles are searched for in the same directory as `Name.rel`, in the current\nworking directory, and in any directories specified using option `path`. In the\ncase of `sys.config` it is not included if `sys.config.src` is found.\n\nIf the release package is to contain a new Erlang runtime system, the\n`erts-ErtsVsn/bin` directory of the specified runtime system `{erts,Dir}` is\ncopied to `erts-ErtsVsn/bin`. Some erts executables are not copied by default,\nif you want to include all executables you can give the `erts_all` option.\n\nAll checks with function [`make_script`](`make_script/1`) are performed before\nthe release package is created. Options `src_tests` and `exref` are also valid\nhere.\n\nThe return value and the handling of errors and warnings are the same as\ndescribed for [`make_script`](`make_script/1`).","ref":"systools.html#make_tar/2"},{"type":"function","title":"systools.script2boot/1","doc":"This function transforms the `File.script` boot script to a binary\nterm, which is stored in the `File.boot` file.\n\nThe Erlang runtime system requires that the contents of the script\nused to boot the system is a binary Erlang term.\n\nA boot script generated using [`make_script`](`make_script/1`) is already\ntransformed to the binary form.","ref":"systools.html#script2boot/1"},{"type":"extras","title":"SASL Application","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# SASL Application","ref":"sasl_app.html"},{"type":"extras","title":"Description - SASL Application","doc":"The SASL application provides the following services:\n\n- `alarm_handler`\n- `release_handler`\n- `systools`\n\n> #### Note {: .info }\n>\n> The SASL application in OTP has nothing to do with \"Simple Authentication and\n> Security Layer\" (RFC 4422).","ref":"sasl_app.html#description"},{"type":"extras","title":"Configuration - SASL Application","doc":"The following configuration parameters are defined for the SASL application. For\nmore information about configuration parameters, see\n[`app(4)`](`e:kernel:app.md`) in Kernel.\n\nAll configuration parameters are optional.\n\n- **`start_prg = string()`** - Specifies the program to be used when restarting\n  the system during release installation. Default is `$OTPROOT/bin/start`.\n\n- **`masters = [atom()]`** - Specifies the nodes used by this node to read/write\n  release information. This parameter is ignored if parameter `client_directory`\n  is not set.\n\n- **`client_directory = string()`** - This parameter specifies the client\n  directory at the master nodes. For details, see\n  [Release Handling](`e:system:release_handling.md`) in _OTP Design Principles_.\n  This parameter is ignored if parameter `masters` is not set.\n\n- **`static_emulator = true | false`** - Indicates if the Erlang emulator is\n  statically installed. A node with a static emulator cannot switch dynamically\n  to a new emulator, as the executable files are written into memory statically.\n  This parameter is ignored if parameters `masters` and `client_directory` are\n  not set.\n\n- **`releases_dir = string()`** - Indicates where the `releases` directory is\n  located. The release handler writes all its files to this directory. If this\n  parameter is not set, the OS environment parameter `RELDIR` is used. By\n  default, this is `$OTPROOT/releases`.\n\n[](){: #deprecated_error_logger_config }","ref":"sasl_app.html#configuration"},{"type":"extras","title":"Deprecated Error Logger Event Handlers and Configuration - SASL Application","doc":"In Erlang/OTP 21.0, a new API for logging was added. The old `error_logger`\nevent manager, and event handlers running on this manager, still work, but they\nare not used by default.\n\nThe error logger event handlers `sasl_report_tty_h` and `sasl_report_file_h`,\nwere earlier used for printing the so called SASL reports, that is, _supervisor\nreports_, _crash reports_, and _progress reports_. These reports are now also\nprinted by the default logger handler started by the Kernel application.\nProgress reports are by default stopped by the primary log level, but can be\nenabled by setting this level to `info`, for example by using the Kernel\nconfiguration parameter [`logger_level`](`e:kernel:kernel_app.md#logger_level`).\n\nIf the old error logger event handlers are still desired, they must be added by\ncalling `error_logger:add_report_handler/1,2`.\n\n- **`sasl_report_tty_h`** - Formats and writes _supervisor reports_, _crash\n  reports_, and _progress reports_ to `stdio`. This error logger event handler\n  uses\n  [`error_logger_format_depth`](`e:kernel:kernel_app.md#deprecated-configuration-parameters`)\n  in the Kernel application to limit how much detail is printed in crash and\n  supervisor reports.\n\n- **`sasl_report_file_h`** - Formats and writes _supervisor reports_, _crash\n  report_, and _progress report_ to a single file. This error logger event\n  handler uses\n  [`error_logger_format_depth`](`e:kernel:kernel_app.md#deprecated-configuration-parameters`)\n  in the Kernel application to limit the details printed in crash and supervisor\n  reports.\n\nA similar behaviour, but still using the new logger API, can be obtained by\nsetting the Kernel application environment variable\n[`logger_sasl_compatible`](`e:kernel:kernel_app.md#logger_sasl_compatible`) to\n`true`. This adds a second instance of the standard Logger handler, named\n`sasl`, which only prints the SASL reports. No SASL reports are then printed by\nthe Kernel logger handler.\n\nThe `sasl` handler is configured according to the values of the following SASL\napplication environment variables.\n\n- **`sasl_error_logger = Value`** - `Value` is one of the following:\n\n  - **`tty`** - Installs `sasl_report_tty_h` in the error logger. This is the\n    default option.\n\n  - **`{file,FileName}`** - Installs `sasl_report_file_h` in the error logger.\n    All reports go to file `FileName`, which is a string. The file is opened in\n    `write` mode with encoding `utf8`.\n\n  - **`{file,FileName,Modes}`** - Same as `{file,FileName}`, except that `Modes`\n    allows you to specify the modes used for opening the `FileName` given to the\n    `file:open/2` call. By default, the file is opened in `write` mode with\n    encoding `utf8`. Use `[append]` to have the `FileName` open in append mode.\n    A different encoding can also be specified. `FileName` is a string.\n\n  - **`false`** - No SASL error logger handler is installed.\n\n- **`errlog_type = error | progress | all`** - Restricts the error logging\n  performed by the specified `sasl_error_logger` to error reports or progress\n  reports, or both. Default is `all`.\n\n- **`utc_log = true | false`{: #utc_log }** - If set to `true`, all dates in\n  textual log outputs are displayed in Universal Coordinated Time with the\n  string `UTC` appended.\n\nThe error logger event handler `log_mf_h` can also still be used. This event\nhandler writes _all_ events sent to the error logger to disk. Multiple files and\nlog rotation are used. For efficiency reasons, each event is written as a\nbinary. For more information about this handler, see\n[the STDLIB Reference Manual](`m:log_mf_h`).\n\nTo activate this event handler, three SASL configuration parameters must be set:\n\n- **`error_logger_mf_dir = string() | false`** - Specifies in which directory\n  `log_mf_h` is to store its files. If this parameter is undefined or `false`,\n  the `log_mf_h` handler is not installed.\n\n- **`error_logger_mf_maxbytes = integer()`** - Specifies the maximum size of\n  each individual file written by `log_mf_h`. If this parameter is undefined,\n  the `log_mf_h` handler is not installed.\n\n- **`error_logger_mf_maxfiles = 0<integer()<256`** - Specifies the number of\n  files used by `log_mf_h`. If this parameter is undefined, the `log_mf_h`\n  handler is not installed.\n\nThe new `m:logger_disk_log_h` might be an alternative to `log_mf_h` if log\nrotation is desired. This does, however, write the log events in clear text and\nnot as binaries.","ref":"sasl_app.html#deprecated-error-logger-event-handlers-and-configuration"},{"type":"extras","title":"See Also - SASL Application","doc":"`m:alarm_handler`, `m:error_logger`, `m:logger`, `m:log_mf_h`, `m:rb`,\n`m:release_handler`, `m:systools`","ref":"sasl_app.html#see-also"},{"type":"extras","title":"SASL Release Notes","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# SASL Release Notes\n\nThis document describes the changes made to the SASL application.","ref":"notes.html"},{"type":"extras","title":"SASL 4.3 - SASL Release Notes","doc":"","ref":"notes.html#sasl-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Fixed the documentation for the ExtraFiles option to `systools:make_tar/2`.\n\n  Own Id: OTP-19279 Aux Id: [GH-8842], [PR-8894]\n\n[GH-8842]: https://github.com/erlang/otp/issues/8842\n[PR-8894]: https://github.com/erlang/otp/pull/8894","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- [`.appup`](appup.md) files are now included in releases in order to make it possible to create upgrade packages from an installed release.\n\n  Own Id: OTP-19398 Aux Id: [PR-8973]\n\n- The license and copyright header has changed format to include an `SPDX-License-Identifier`. At the same time, most files have been updated to follow a uniform standard for license headers.\n\n  Own Id: OTP-19575 Aux Id: [PR-9670]\n\n[PR-8973]: https://github.com/erlang/otp/pull/8973\n[PR-9670]: https://github.com/erlang/otp/pull/9670","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"SASL 4.2.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-4-2-2"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features-1"},{"type":"extras","title":"SASL 4.2.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-4-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Improved error message from `systools:make_script`, when .app parameters\n  contain duplicates. The parameters that will be checked are modules,\n  applications and registered.\n\n  Own Id: OTP-18300 Aux Id: PR-6389","ref":"notes.html#fixed-bugs-and-malfunctions-1"},{"type":"extras","title":"SASL 4.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Fix systools:make\\* to recursively search for source code when doing a\n  `src_tests`.\n\n  Own Id: OTP-17752 Aux Id: PR-5302","ref":"notes.html#fixed-bugs-and-malfunctions-2"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- An Erlang installation directory is now relocatable on the file system given\n  that the paths in the installation's `RELEASES` file are paths that are\n  relative to the installations root directory. The\n  `` `release_handler:create_RELEASES/4 `` function can generate a `RELEASES`\n  file with relative paths if its `RootDir` parameter is set to the empty\n  string.\n\n  Own Id: OTP-17304","ref":"notes.html#improvements-and-new-features-2"},{"type":"extras","title":"SASL 4.1.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-4-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Fix bug in systools:make_script/1 documentation.\n\n  Own Id: OTP-17854 Aux Id: PR-5596","ref":"notes.html#fixed-bugs-and-malfunctions-3"},{"type":"extras","title":"SASL 4.1.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-4-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Make `release_handler` even more resilient against exiting processes during\n  upgrade. Same kind of bug fix as OTP-16744 released in sasl-4.0.1 (OTP 23.1).\n\n  Own Id: OTP-17748 Aux Id: GH-5387, PR-5389","ref":"notes.html#fixed-bugs-and-malfunctions-4"},{"type":"extras","title":"SASL 4.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-4-1"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- The experimental HiPE application has been removed, together with all related\n  functionality in other applications.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16963\n\n- Recognize new key 'optional_applications' in application resource files.\n\n  Own Id: OTP-17189 Aux Id: PR-2675\n\n- Removed timestamps from files generated by `sasl` and `reltool` to enable\n  deterministic builds.\n\n  Own Id: OTP-17292 Aux Id: PR-4685, PR-4684","ref":"notes.html#improvements-and-new-features-3"},{"type":"extras","title":"SASL 4.0.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-4-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Fix dependent application to be stopped after the primary application when\n  upgrading a release and the primary and dependent application is removed.\n\n  Example: In a release where app1 depends on app2 and we should remove app1 and\n  app2 using a release upgrade. When the release upgrade is done app1 should be\n  stopped and purged before app2 as otherwise app1 could start crashing when its\n  dependency is removed.\n\n  This bugfix changes the order of removal to be correct.\n\n  Own Id: OTP-17113 Aux Id: ERL-1410 PR-2882","ref":"notes.html#fixed-bugs-and-malfunctions-5"},{"type":"extras","title":"SASL 4.0.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-4-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Make `release_handler` more resilient against exiting processes during\n  upgrade.\n\n  Own Id: OTP-16744 Aux Id: ERL-1247, PR-2666","ref":"notes.html#fixed-bugs-and-malfunctions-6"},{"type":"extras","title":"SASL 4.0 - SASL Release Notes","doc":"","ref":"notes.html#sasl-4-0"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Remove usage and documentation of old requests of the I/O-protocol.\n\n  Own Id: OTP-15695\n\n- `systools:make_script/2` now accepts the name of the boot file to create, it\n  is not restricted to only `RelName.boot` or `start.boot`.\n\n  `systools:make_tar/2` now accepts the option `extra_files` to add any extra\n  non release related files to the tar file.\n\n  Own Id: OTP-16561 Aux Id: PR-2420\n\n- [`systools:make_tar/1,2`](`systools:make_tar/1`) now filters out any tools\n  from erts if included in the release tar ball. See the documentation for more\n  details.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16603","ref":"notes.html#improvements-and-new-features-4"},{"type":"extras","title":"SASL 3.4.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-4-2"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- A socket \"registry\" has been added making it possible to list current open\n  sockets.\n\n  Own Id: OTP-16309","ref":"notes.html#improvements-and-new-features-5"},{"type":"extras","title":"SASL 3.4.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-4-1"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- The net module has been split into 'net' (kernel) and prim_net (preloaded).\n\n  Own Id: OTP-15765","ref":"notes.html#improvements-and-new-features-6"},{"type":"extras","title":"SASL 3.4 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-4"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Change the first module called by erts to be named erl_init instead of\n  otp_ring0. systools in sasl have been updated to reflect this change.\n\n  Own Id: OTP-15336 Aux Id: PR-1825","ref":"notes.html#improvements-and-new-features-7"},{"type":"extras","title":"SASL 3.3 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-3"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- New `counters` and `atomics` modules supplies access to highly efficient\n  operations on mutable fixed word sized variables.\n\n  Own Id: OTP-13468","ref":"notes.html#improvements-and-new-features-8"},{"type":"extras","title":"SASL 3.2.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions-7"},{"type":"extras","title":"SASL 3.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-2"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- A new logging API is added to Erlang/OTP, see the `m:logger` manual page, and\n  section [Logging](`e:kernel:logger_chapter.md`) in the Kernel User's Guide.\n\n  Calls to `error_logger` are automatically redirected to the new API, and\n  legacy error logger event handlers can still be used. It is, however,\n  recommended to use the Logger API directly when writing new code.\n\n  Notice the following potential incompatibilities:\n\n  - Kernel configuration parameters `error_logger` still works, but is overruled\n    if the default handler's output destination is configured with Kernel\n    configuration parameter `logger`.\n\n    In general, parameters for configuring error logger are overwritten by new\n    parameters for configuring Logger.\n\n  - The concept of SASL error logging is deprecated, meaning that by default the\n    SASL application does not affect which log events are logged.\n\n    By default, supervisor reports and crash reports are logged by the default\n    Logger handler started by Kernel, and end up at the same destination\n    (terminal or file) as other standard log event from Erlang/OTP.\n\n    Progress reports are not logged by default, but can be enabled by setting\n    the primary log level to info, for example with the Kernel configuration\n    parameter `logger_level`.\n\n    To obtain backwards compatibility with the SASL error logging functionality\n    from earlier releases, set Kernel configuration parameter\n    `logger_sasl_compatible` to `true`. This prevents the default Logger handler\n    from logging any supervisor-, crash-, or progress reports. Instead, SASL\n    adds a separate Logger handler during application start, which takes care of\n    these log events. The SASL configuration parameters `sasl_error_logger` and\n    `sasl_errlog_type` specify the destination (terminal or file) and severity\n    level to log for these events.\n\n  Since Logger is new in Erlang/OTP 21.0, we do reserve the right to introduce\n  changes to the Logger API and functionality in patches following this release.\n  These changes might or might not be backwards compatible with the initial\n  version.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13295\n\n- The old and outdated \"Status Inspection\" tool (modules `si` and `si_sasl_sup`)\n  is removed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14469\n\n- When creating the release tar file, systools now includes sys.config.src if it\n  exists in the $ROOT/releases/ / directory. This is to allow adjustments,\n  e.g. resolving environment variables, after unpacking the release, but before\n  installing it. This functionality requires a custom tool which uses\n  sys.config.src as input and creates a correct sys.config file.\n\n  Own Id: OTP-14950 Aux Id: PR-1560","ref":"notes.html#improvements-and-new-features-9"},{"type":"extras","title":"SASL 3.1.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- When upgrading with instruction 'restart_new_emulator', the generated\n  temporary boot file used 'kernelProcess' statements from the old release\n  instead of the new release. This is now corrected.\n\n  This correction is needed for upgrade to OTP-21.\n\n  Own Id: OTP-15017","ref":"notes.html#fixed-bugs-and-malfunctions-8"},{"type":"extras","title":"SASL 3.1.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- The Report Browser, rb, could earlier not handle reports that were not lists,\n  for example generated by `error_logger:info_report({some, tuple})`. This term\n  is allowed as input to error_logger, but rb would state that \"A report on bad\n  form was encountered\". This is now corrected.\n\n  Own Id: OTP-13906 Aux Id: ERL-261","ref":"notes.html#fixed-bugs-and-malfunctions-9"},{"type":"extras","title":"SASL 3.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-1"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- General Unicode improvements.\n\n  Own Id: OTP-14462\n\n- Files generated by `release_handler` and `reltool`, which might contain\n  Unicode characters, are now encoded as UTF-8 and written with format \"~tp\" or\n  \"~ts\". If the file is to be read by `file:consult/1`, an encoding comment is\n  added.\n\n  Own Id: OTP-14463\n\n- The SASL error logger event handler, `sasl_report_file_h`, will now by default\n  open its log file with encoding UTF-8. This can be overridden when configuring\n  SASL, see configuration parameter `sasl_error_logger` in the SASL reference\n  manual.\n\n  Own Id: OTP-14618","ref":"notes.html#improvements-and-new-features-10"},{"type":"extras","title":"SASL 3.0.4 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Documented default values for the 'mod' and 'start_phases' fields in .app\n  files were not allowed as actual values in a .app file. This is now corrected.\n\n  Own Id: OTP-14029","ref":"notes.html#fixed-bugs-and-malfunctions-10"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Miscellaneous updates due to atoms containing arbitrary Unicode characters.\n\n  Own Id: OTP-14285","ref":"notes.html#improvements-and-new-features-11"},{"type":"extras","title":"SASL 3.0.3 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- When both options 'warnings_as_errors' and 'silent' were given to\n  systools:make_script or systools:make_relup, no error reason would be returned\n  if warnings occurred. Instead only the atom 'error' was returned. This is now\n  corrected.\n\n  Options 'warnings_as_errors' and 'no_warn_sasl' are now also allowed for\n  systools:make_tar.\n\n  Own Id: OTP-14170","ref":"notes.html#fixed-bugs-and-malfunctions-11"},{"type":"extras","title":"SASL 3.0.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- `code:add_pathsa/1` and command line option `-pa` both revert the given list\n  of directories when adding it at the beginning of the code path. This is now\n  documented.\n\n  Own Id: OTP-13920 Aux Id: ERL-267","ref":"notes.html#fixed-bugs-and-malfunctions-12"},{"type":"extras","title":"SASL 3.0.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-0-1"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Improved dirty scheduler support. A purge of a module can now be performed\n  without having to wait for completion of all ongoing dirty NIF calls.\n\n  Note that when enabling support for dirty schedulers, a new purge strategy\n  will as of ERTS version 8.1 be enabled. This new strategy is not fully\n  backwards compatible with the strategy used by default. For more information\n  see the documentation of `erlang:check_process_code/3`.\n\n  Own Id: OTP-13808 Aux Id: OTP-13833\n\n- A new purge strategy has been introduced. The new strategy will by default be\n  disabled during the OTP 19 release, but will be the only strategy available as\n  of the OTP 20 release.\n\n  The new strategy is slightly incompatible with the strategy being used by\n  default in OTP 19. Using the default strategy, processes holding `fun`s that\n  refer to the module being purged either fail a soft purge, or will be killed\n  during a hard purge. The new strategy completely ignores `fun`s. If `fun`s\n  referring to the code being purged exist, and are used after a purge, an\n  exception will be raised upon usage. That is, the behavior will be exactly the\n  same as the case when a `fun` is received by a process after the purge.\n\n  The new strategy can optionally be enabled when building OTP during OTP 19,\n  and will automatically be enabled if the runtime system is built with support\n  for dirty schedulers.\n\n  For more information see the documentation of `erlang:check_process_code/3`.\n\n  Own Id: OTP-13833","ref":"notes.html#improvements-and-new-features-12"},{"type":"extras","title":"SASL 3.0 - SASL Release Notes","doc":"","ref":"notes.html#sasl-3-0"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- The module 'overload' is removed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13184","ref":"notes.html#improvements-and-new-features-13"},{"type":"extras","title":"SASL 2.7 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- During upgrade, the release_handler collects a list of supervisor pids in\n  order to list all processes in the supervisor tree. If one of the supervisors\n  (legitimately) exits before release_handler can examine it, then\n  `sys:get_status/1` would earlier be called with a dead pid, causing a\n  `'noproc'` error. This has been corrected.\n\n  Own Id: OTP-13291","ref":"notes.html#fixed-bugs-and-malfunctions-13"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- The module `overload` is deprecated and will be removed in OTP 19.\n\n  Own Id: OTP-13057\n\n- Improve implementation of supervisor child count, making it faster and more\n  accurate for dynamic processes of a `simple_one_for_one` supervisor.\n\n  Own Id: OTP-13290","ref":"notes.html#improvements-and-new-features-14"},{"type":"extras","title":"SASL 2.6.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-6-1"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Documentation improvements\n\n  Own Id: OTP-13000","ref":"notes.html#improvements-and-new-features-15"},{"type":"extras","title":"SASL 2.6 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-6"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- A mechanism for limiting the amount of text that the built-in error logger\n  events will produce has been introduced. It is useful for limiting both the\n  size of log files and the CPU time used to produce them.\n\n  This mechanism is experimental in the sense that it may be changed if it turns\n  out that it does not solve the problem it is supposed to solve. In that case,\n  there may be backward incompatible improvements to this mechanism.\n\n  See the documentation for the config parameter `error_logger_format_depth` in\n  the Kernel application for information about how to turn on this feature.\n\n  Own Id: OTP-12864","ref":"notes.html#improvements-and-new-features-16"},{"type":"extras","title":"SASL 2.5 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- The undocumented upgrade instruction\n  `{remove_module,PrePurge,PostPurge,DepMods}` is removed. This instruction was\n  added for symmetry reasons in OTP R7B, but was never documented or tested.\n\n  The existing instruction `{add_module,Mod,DepMods}` is now documented, and the\n  complementing instruction `{delete_module,Mod,DepMods}` is added.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-11540","ref":"notes.html#fixed-bugs-and-malfunctions-14"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- The `sasl_error_logger` configuration parameter now supports the value\n  `{file,FileName,Modes}` which allows the log file to be opened in other mode\n  than write (for example, append mode).\n\n  Own Id: OTP-12778","ref":"notes.html#improvements-and-new-features-17"},{"type":"extras","title":"SASL 2.4.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- The documentation erroneously specified that `alarm_handler:clear_alarm/1`\n  would clear _all_ alarms with id `AlarmId`. This is now corrected according to\n  the implementation - only the latest received alarm with the given `AlarmId`\n  is cleared by the simple default handler.\n\n  Own Id: OTP-12025","ref":"notes.html#fixed-bugs-and-malfunctions-15"},{"type":"extras","title":"SASL 2.4 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- The upgrade instruction 'restart_application' would earlier ignore the restart\n  type configured in the .rel file and always restart the application as\n  permanent. This is now changed, and the restart type from the .rel file is\n  used. If restart type is 'load', the application will only be loaded and not\n  started. If the restart type is 'none', the application will not be loaded nor\n  started, but all modules in the application will be loaded. (Thanks to Tobias\n  Schlager for reporting this problem)\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-11716\n\n- If `systools:make_script/2` failed with reason `duplicate_modules`, and the\n  `silent` flag was not used, a crash with reason `function_clause` would occur\n  when `systools` tried to format the error message. This has been corrected.\n  (Thanks to Jean-Sébastien Pédron)\n\n  Own Id: OTP-11819","ref":"notes.html#fixed-bugs-and-malfunctions-16"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Calls to erlang:open_port/2 with 'spawn' are updated to handle space in the\n  command path.\n\n  Own Id: OTP-10842\n\n- Some more documentation is added to explain the behavior when an upgrade\n  includes new versions of ERTS, Kernel, STDLIB or SASL.\n\n  Own Id: OTP-11717","ref":"notes.html#improvements-and-new-features-18"},{"type":"extras","title":"SASL 2.3.4 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-3-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Don't try to add the log_mf_h handler in sasl unless configured to do so.\n  Thanks to Richard Carlsson.\n\n  Own Id: OTP-11464\n\n- Fix confusing documentation about error handlers in SASL.(Thanks to Richard\n  Carlsson)\n\n  Own Id: OTP-11507\n\n- A bug in the mechanism for upgrading core parts of Erlang/OTP (emulator,\n  kernel, stdlib, sasl) caused a switch of paths between stdlib and sasl in the\n  intermediate .script/.boot file. The bug was introduces along with this\n  upgrade mechanism in R15B. It has now been corrected. (Thanks to Tobias\n  Schlager)\n\n  Own Id: OTP-11529","ref":"notes.html#fixed-bugs-and-malfunctions-17"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Added a boot file which skips loading the \"$HOME/.erlang\" file on startup.\n  Enable by starting erlang with \"erl -boot no_dot_erlang\".\n\n  \\*** INCOMPATIBILITY with false \\***\n\n  Own Id: OTP-8479 Aux Id: seq11510","ref":"notes.html#improvements-and-new-features-19"},{"type":"extras","title":"SASL 2.3.3 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-3-3"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Add Fd usage in rb logging. Thanks to Eric Pailleau.\n\n  Own Id: OTP-11252","ref":"notes.html#improvements-and-new-features-20"},{"type":"extras","title":"SASL 2.3.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Fix receive support in erl_eval with a BEAM module. Thanks to Anthony Ramine.\n\n  Own Id: OTP-11137","ref":"notes.html#fixed-bugs-and-malfunctions-18"},{"type":"extras","title":"SASL 2.3.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-3-1"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Some updates are made to systools and release_handler for handling of unicode.\n\n  Own Id: OTP-10782","ref":"notes.html#improvements-and-new-features-21"},{"type":"extras","title":"SASL 2.3 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- release_handler_SUITE:otp_9864 deleted parts of the release_handler_SUITE_data\n  directory so the test suite could not be executed twice without\n  re-installation. This has been corrected.\n\n  Own Id: OTP-10394 Aux Id: kunagi-187 \\[98]\n\n- It is no longer possible to have `{Mod,Vsn}` in the 'modules' list in a .app\n  file.\n\n  This was earlier possible, although never documented in the .app file\n  reference manual. It was however visible in the documentation of\n  `application:load/[1,2]`, where the same term as in a .app file can be used as\n  the first argument.\n\n  The possibility has been removed since the `Vsn` part was never used.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-10417\n\n- release_handler:upgrade_script and release_handler:downgrade_script could not\n  read appup files with regexps. This has been corrected. (Thanks to Ulf Wiger)\n\n  Own Id: OTP-10463","ref":"notes.html#fixed-bugs-and-malfunctions-19"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630","ref":"notes.html#improvements-and-new-features-22"},{"type":"extras","title":"SASL 2.2.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- If sys.config existed, but was not readable or parseable, this would not be\n  detected until after the upgrade and at the next node restart. The possibility\n  for this to happen is now reduced by adding a check to systools:make_tar which\n  fails the creation of the tar file if sys.config or relup does not have\n  reasonable contents. Note that there are no detailed checks, only parsing and\n  erlang term format check.\n\n  Own Id: OTP-9539\n\n- systools:make_script would allow \\{kernel,Vsn,load\\} in the .rel file, causing\n  a .boot file which only loaded kernel and did not start it. This has been\n  corrected. Only start type 'permanent', which is the default, is now allowed\n  for kernel and stdlib.\n\n  Own Id: OTP-9652\n\n- release_handler:remove_release/1 now handles symlinked files properly\n\n  Own Id: OTP-9864\n\n- If stdlib was stated with a start type different from `permanent` in a .rel\n  file, systools would incorrectly say that sasl had faulty start type. This has\n  been corrected.\n\n  Own Id: OTP-9888\n\n- Sasl documentation earlier said that the InclApps parameters in a .rel file\n  defaults to the empty list. This is not correct. It defaults to the same value\n  as specified in the .app file. This has been corrected.\n\n  Own Id: OTP-9980\n\n- Applications that are listed in `{applications,Apps}` in the .app file were\n  not sorted correctly by `systools:make_script/1,2`. They got the reverse order\n  of how they were listed in the .app file. This is corrected so they are now\n  sorted (internally between each other) in the same order as they are listed in\n  the .rel file (i.e. the order they are listed in the .app file does no longer\n  matter).\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9984\n\n- Documentation of .appup files now also states that `UpFromVsn` and `DownToVsn`\n  can be specified as regular expressions in order to avoid duplicated upgrade\n  instructions.\n\n  Own Id: OTP-10001\n\n- Reltool would sometimes generate a .app file containing\n  `{start_phases,undefined}`, which would cause an exception in systools at\n  parse time. This has been corrected so reltool now omits the `start_phases`\n  entry if the value is `undefined`. (Thanks to Juan Jose Comellas)\n\n  In order to align with reltool, sasl will also omit `start_phases` entries\n  with value `undefined` in .script files.\n\n  Own Id: OTP-10003","ref":"notes.html#fixed-bugs-and-malfunctions-20"},{"type":"extras","title":"SASL 2.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Fix the mechanism for upgrading emulator.\n\n  The appup files for kernel, stdlib and sasl do now recognize two major\n  releases back and include a 'restart_new_emulator' instruction.\n\n  Appup files can include regular expressions for matching earlier releases.\n\n  The mechanism for upgrading the emulator is changed so 'restart_new_emulator'\n  will be the first instruction executed. The rest of the upgrade instruction\n  will be executed after the emulator restart.\n\n  A new upgrade instruction 'restart_emulator' is added for the case where the\n  emulator shall be restarted after all other upgrade instructions.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9438\n\n- Add release_handler:which_releases/1\n\n  This is an extension to which_releases that allows a user to specify the\n  status of the releases they wish to be returned. For instance it allows for\n  quickly determining which release is 'permanent' without the need of parsing\n  the entire release list. (Thanks to Joe Williams)\n\n  Own Id: OTP-9717\n\n- Add copy of rel file in releases/Vsn in release tar file\n\n  systool:make_tar stores the rel file in the releases directory. When unpacking\n  with release_handler:unpack_release, the file is automatically moved to\n  releases/Vsn/. If, however, the tar file is unpacked manually, the rel file\n  might not be moved, and the next release unpacked might overwrite the rel\n  file. To overcome this, systools:make_tar now stores a copy of the rel file in\n  releases/Vsn/ directly and it is not longer necessary to move the file after\n  unpacking.\n\n  The reason for keeping the file in the releases directory also is that is\n  needs to be extracted separately before the release version (Vsn) is known.\n\n  Own Id: OTP-9746","ref":"notes.html#fixed-bugs-and-malfunctions-21"},{"type":"extras","title":"SASL 2.1.10 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- The release_handler functionality on windows services was broken. This has\n  been corrected.\n\n  Own Id: OTP-9306\n\n- If a new version of an application did not include any erlang module changes,\n  the code path of the application was not updated by the release_handler unless\n  a 'load_object_code' instruction was added for the application. This would be\n  a problem if e.g. only some files in the priv dir were changed since calls to\n  code:lib_dir or code:priv_dir would then point to the old location of the\n  application. This has been corrected - now code:replace_path/2 will be called\n  for all applications that are changed (i.e. when the application's vsn is\n  changed in the .rel file).\n\n  Own Id: OTP-9402\n\n- The appup instruction 'delete_module' would cause a crash during upgrade if\n  the module to be deleted was not loaded. This has been corrected.\n\n  Own Id: OTP-9417\n\n- If a path was given as ONLY 'ebin' and not for example './ebin', then\n  systools:make_tar would fail with a `function_clause` exception in\n  filename:join/1. This has been corrected. (Thanks to Nikola Skoric for\n  reporting).\n\n  Own Id: OTP-9507\n\n- Implement or fix -Werror option\n\n  If -Werror is enabled and there are warnings no output file is written. Also\n  make sure that error/warning reporting is consistent. (Thanks to Tuncer Ayaz)\n\n  Own Id: OTP-9536\n\n- Improved error information for timeouts during\n  release_handler:install_release.\n\n  This patch addresses two cases where a timeout will occur during upgrade. 1)\n  if a supervisor is suspended (call to get children from supervisor will\n  hang) 2) if the child spec for a supervisor incorrectly states that it is a\n  worker with a dynamic set of modules (call to get modules from gen_event will\n  hang)\n\n  An error report will now be printed, and the return value of\n  release_handler:install_release will indicate what happened. (Thanks to joe\n  williams)\n\n  Own Id: OTP-9546","ref":"notes.html#fixed-bugs-and-malfunctions-22"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- `release_handler:install_release` could be very slow when there are many\n  processes in the system. Some optimization work has been done both in erts and\n  in the release handler in order to improve this.\n\n  A new option, `purge`, is added to `release_handler:check_install_release`\n  which can be called first in order to speed up the execution of\n  `release_handler:install_release`.\n\n  Own Id: OTP-9395","ref":"notes.html#improvements-and-new-features-23"},{"type":"extras","title":"SASL 2.1.9.4 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-9-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Remove traces of release_handler reading from filesystem when it has Masters\n  list\n\n  There are a couple of places in release_handler and release_handler_1 that\n  assumed it has a disk to read from, which in the case of an erl_prim_loader\n  Loader other than efile is not necessarily true\n\n  Add check_paths/2 to do the equivalent of check_path/1 for when there is a\n  Masters list\n\n  Change get_vsn to no longer get sent File paths but instead use the Bin since\n  beam_lib:version being sent a file path causes it to read the local file\n  system\n\n  Add get_current_vsn/1 as an equivalent to beam_lib:version(code:which(Mod)),\n  but using erl_prim_loader:get_file instead of reading from local file system\n\n  (Thanks to Steven Gravell)\n\n  Own Id: OTP-9142\n\n- rb:stop did sometimes return \\{error,running\\}. This came from\n  supervisor:delete_child and happened when the rb_server has not yet terminated\n  when this function was called. Instead of having a separate gen_server call to\n  rb_server for stopping the process, supervisor:terminate_child is now called.\n  This is a synchronous function - i.e. it waits for the process to actually\n  terminate before it returns.\n\n  A file descriptor leak in rb:scan_files is corrected. The index file was never\n  closed after reading.\n\n  A mismatch in the behavior of rb:filter, when filter included 'no', is\n  corrected. Such filters will now return _all_ non-matching reports, not only\n  the 'proplist' reports.\n\n  Own Id: OTP-9149\n\n- Start and end date for rb:filter/2 was specified as \\{\\{Y-M-D\\},...\\} in the\n  help text instead of \\{\\{Y,M,D\\},...\\}. This has been corrected.\n\n  Own Id: OTP-9166\n\n- If some, but not all, of the sasl environment variables related to the\n  log_mf_h error handler were missing sasl would successfully start but silently\n  skip starting log_mf_h. This is corrected so sasl startup will now fail if one\n  or two of the three variables are given. If none of the variables are given,\n  sasl will start as before without starting log_mf_h.\n\n  Own Id: OTP-9185","ref":"notes.html#fixed-bugs-and-malfunctions-23"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Change default behaviour to not check src code when creating release\n\n  Add new option `src_tests` to systools:make_script and systools:make_tar. The\n  old option `no_module_tests` is now ignored as this is the default behaviour.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9146 Aux Id: seq11803","ref":"notes.html#improvements-and-new-features-24"},{"type":"extras","title":"SASL 2.1.9.3 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-9-3"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Honor start type in .rel files when building relup files\n\n  Previously, relup file always included an application:start(Application,\n  permanent) apply instruction for every application that appear in the\n  UpTo/DowFrom release file, whatever their start type in the release file.\n\n  The new implementation fixes this bug by honoring the start type according to\n  the rel(5) format. If the start type is none, no apply line is included in the\n  relup. If the start type is load, the relup includes instruction to only load\n  the application. Otherwise, the relup includes an instruction to start the\n  application to the according type.\n\n  The fix is implemented by adding a new parameter to the add_application high\n  level appup instruction. This new parameter is documented in appup(5).\n\n  Own Id: OTP-9097","ref":"notes.html#improvements-and-new-features-25"},{"type":"extras","title":"SASL 2.1.9.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-9-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- In R13B04 sys:get_status was modified to invoke format_status/2 in the\n  callback module if the module exports that function. This resulted in a change\n  to the term returned from calling sys:get_status on the supervisor module,\n  since supervisor is a gen_server and gen_server exports format_status. The\n  sasl release_handler_1 module had a dependency on the pre-R13B04 term returned\n  by sys:get_status when invoked on a supervisor, so the R13B04 change broke\n  that dependency.\n\n  This problem has been fixed by change release_handler_1 to handle both the\n  pre-R13B04 and R13B04 terms that sys:get_status can return from a supervisor.\n\n  Own Id: OTP-8619 Aux Id: seq11570","ref":"notes.html#fixed-bugs-and-malfunctions-24"},{"type":"extras","title":"SASL 2.1.9.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-9-1"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Use an infinity timeout in all calls to `gen_server:call()` in the SASL\n  application.\n\n  Own Id: OTP-8506 Aux Id: seq11509","ref":"notes.html#improvements-and-new-features-26"},{"type":"extras","title":"SASL 2.1.9 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-9"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- The `re:grep/1` function now uses the '`re`' module instead of the deprecated\n  '`regexp`' module. There are new functions `rb:filter/1` and `rb:filter/2` for\n  easier filtering of reports. (Thanks to Alvaro Videla.)\n\n  Own Id: OTP-8443\n\n- There is new function `sasl_report:format_report/3` that works like the\n  existing `sasl_report:write_report/3` function except that it returns a\n  formatted string. Note that there is currently no documentation for the\n  `sasl_report` module. (Thanks to Jay Nelson.)\n\n  Own Id: OTP-8445\n\n- Cleanups suggested by tidier and modernization of types and specs.\n\n  Own Id: OTP-8455","ref":"notes.html#improvements-and-new-features-27"},{"type":"extras","title":"SASL 2.1.8 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-8"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8201","ref":"notes.html#improvements-and-new-features-28"},{"type":"extras","title":"SASL 2.1.7 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-7"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- The Windows utility Erlsrv, run in interactive mode now accepts options for\n  registering internal service name and description field of Windows registry\n  database.\n\n  Own Id: OTP-8132","ref":"notes.html#improvements-and-new-features-29"},{"type":"extras","title":"SASL 2.1.6 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- When using the SASL application configuration parameter `masters` the error\n  tuple `{error,{no_such_file,{Master,FileName}}}` was sometimes returned even\n  though the file `FileName` existed.\n\n  Own Id: OTP-7667","ref":"notes.html#fixed-bugs-and-malfunctions-25"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Missing preloaded modules added\n\n  Own Id: OTP-7820","ref":"notes.html#improvements-and-new-features-30"},{"type":"extras","title":"SASL 2.1.5.4 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-5-4"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- A Dialyzer warning was eliminated\n\n  Own Id: OTP-7635","ref":"notes.html#improvements-and-new-features-31"},{"type":"extras","title":"SASL 2.1.5.3 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-5-3"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Minor changes.\n\n  Own Id: OTP-7388","ref":"notes.html#improvements-and-new-features-32"},{"type":"extras","title":"SASL 2.1.5.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-5-2"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Minor updates.\n\n  Own Id: OTP-6998","ref":"notes.html#improvements-and-new-features-33"},{"type":"extras","title":"SASL 2.1.5.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-5-1"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Minor Makefile changes.\n\n  Own Id: OTP-6689\n\n- Obsolete guard tests (such as list()) have been replaced with the modern guard\n  tests (such as is_list()).\n\n  Own Id: OTP-6725","ref":"notes.html#improvements-and-new-features-34"},{"type":"extras","title":"SASL 2.1.5 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Removed some dead code from `erlsrv:get_service/2`,\n  `release_handler:do_write_file/2`, `systools_relup:foreach_baserel_up/7` and\n  `systools_relup:foreach_baserel_dn/7`.\n\n  Own Id: OTP-6499","ref":"notes.html#fixed-bugs-and-malfunctions-26"},{"type":"extras","title":"SASL 2.1.4 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-4"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Added an option `{outdir,Dir}` to the functions in `systools`, making it\n  possible to specify in which directory a boot script, relup file or release\n  package file should be placed.\n\n  Also, when using `systools:make_tar/2` to create a release package file, the\n  boot script, relup file and `sys.config` are now searched for also in the\n  current working directory and any directory specified by the `path` option,\n  not only in the directory of the `.rel` file.\n\n  As part of the work some minor bugs have been corrected:\n\n  - `systools:make_script/1,2` now returns `error` if the `.script` and/or\n    `.boot` file could not be opened for writing, not `ok`.\n  - `systools:make_tar/1,2` can now handle a `RelName` argument which includes a\n    path. Previously this would cause the `.rel` file to end up in the wrong\n    directory in the resulting tar file.\n  - A documentation error for `systools:make_tar/1,2`: The `.rel` file is placed\n    in the `releases` directory in the tar file, not `releases/RelVsn`.\n\n  Own Id: OTP-6226","ref":"notes.html#improvements-and-new-features-35"},{"type":"extras","title":"SASL 2.1.3 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- `release_handler:upgrade_app/2` and `release_handler:downgrade_app/2,3` \\--\n  used for testing application upgrade and downgrade according to the `.appup`\n  file -- now update application configuration parameters correctly. (Thanks to\n  Serge Aleynikov)\n\n  Own Id: OTP-6162","ref":"notes.html#fixed-bugs-and-malfunctions-27"},{"type":"extras","title":"SASL 2.1.2 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SASL Release Notes","doc":"- Fixed some minor bugs in `release_handler` found by Dialyzer.\n\n  Own Id: OTP-6039","ref":"notes.html#fixed-bugs-and-malfunctions-28"},{"type":"extras","title":"SASL 2.1.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1-1"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- Added a number of functions to `release_handler` which makes it possible to\n  test upgrade and downgrade of applications according to an `.appup` file \"on\n  the fly\":  \n  \\- `upgrade_app/2`  \n  \\- `upgrade_script/2`  \n  \\- `downgrade_app/2,3`  \n  \\- `downgrade_script/3`  \n  \\- `eval_appup_script/4`\n\n  Own Id: OTP-5858","ref":"notes.html#improvements-and-new-features-36"},{"type":"extras","title":"SASL 2.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-1"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- A new option `{update_paths,Bool}` has been added for\n  `release_handler:install_release/2`. It indicates if all application code\n  paths should be updated (`Bool==true`), or if only code paths for modified\n  applications should be updated (`Bool==false`, default).\n\n  `release_handler:set_unpacked/2` now returns an error tuple if a specified\n  application directory does not exist.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-5761","ref":"notes.html#improvements-and-new-features-37"},{"type":"extras","title":"SASL 2.0.1 - SASL Release Notes","doc":"","ref":"notes.html#sasl-2-0-1"},{"type":"extras","title":"Improvements and New Features - SASL Release Notes","doc":"- A bug that made it impossible to call `rb:show(N)` (`N` being an integer)\n  twice without getting an error has been fixed.\n\n  Own Id: OTP-5287","ref":"notes.html#improvements-and-new-features-38"},{"type":"extras","title":"Introduction","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Introduction","ref":"sasl_intro.html"},{"type":"extras","title":"Scope - Introduction","doc":"The SASL application provides support for:\n\n- Error logging\n- Alarm handling\n- Release handling\n- Report browsing\n\nSection [SASL Error Logging](error_logging.md) describes the error handler that\nproduces the supervisor, progress, and crash reports, which can be written to\nscreen or to a specified file. It also describes the Report Browser (RB).\n\nThe sections about release structure and release handling have been moved to\nsection [OTP Design Principles](`e:system:index.html`) in _System\nDocumentation_.","ref":"sasl_intro.html#scope"},{"type":"extras","title":"Prerequisites - Introduction","doc":"It is assumed that the reader is familiar with the Erlang programming language.","ref":"sasl_intro.html#prerequisites"},{"type":"extras","title":"SASL Error Logging","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# SASL Error Logging\n\n> #### Note {: .info }\n>\n> The SASL error logging concept described in this section is deprecated since\n> Erlang/OTP 21.0, when the new [logging API](`e:kernel:logger_chapter.md`) was\n> introduced.\n>\n> The new default behaviour is that the SASL application no longer affects which\n> log events that are logged.\n> [Supervisor reports](error_logging.md#supervisor_report) and\n> [crash reports](error_logging.md#crash_report) are logged via the default\n> logger handler which is setup by Kernel.\n> [Progress reports](error_logging.md#progress_report) are by default not\n> logged, but can be enabled by setting the primary log level to `info`, for\n> example by using the Kernel configuration parameter\n> [`logger_level`](`e:kernel:kernel_app.md#logger_level`).\n>\n> The old SASL error logging behaviour can be re-enabled by setting the Kernel\n> configuration parameter\n> [`logger_sasl_compatible`](`e:kernel:kernel_app.md#logger_sasl_compatible`) to\n> `true`.\n>\n> The mechanism for\n> [multi-file error report logging](error_logging.md#multi_file_logging) as\n> described in this section is also kept for backwards compatibility. However,\n> the new logging API also introduces `m:logger_disk_log_h`, which is a logger\n> handler that can print to multiple files using `m:disk_log`.","ref":"error_logging.html"},{"type":"extras","title":"SASL reports - SASL Error Logging","doc":"The SASL application introduces three types of reports:\n\n- Supervisor report\n- Progress report\n- Crash report\n\nWhen the SASL application is started, it adds a Logger handler that formats and\nwrites these reports, as specified in the\n[configuration parameters for SASL](sasl_app.md#deprecated_error_logger_config).\n\n[](){: #supervisor_report }","ref":"error_logging.html#sasl-reports"},{"type":"extras","title":"Supervisor Report - SASL Error Logging","doc":"A supervisor report is issued when a supervised child terminates unexpectedly. A\nsupervisor report contains the following items:\n\n- **`Supervisor`** - Name of the reporting supervisor.\n\n- **`Context`** - Indicates in which phase the child terminated from the\n  supervisor's point of view. This can be `start_error`, `child_terminated`, or\n  `shutdown_error`.\n\n- **`Reason`** - Termination reason.\n\n- **`Offender`** - Start specification for the child.\n\n[](){: #progress_report }","ref":"error_logging.html#supervisor-report"},{"type":"extras","title":"Progress Report - SASL Error Logging","doc":"A progress report is issued when a supervisor starts or restarts a child. A\nprogress report contains the following items:\n\n- **`Supervisor`** - Name of the reporting supervisor.\n\n- **`Started`** - Start specification for the successfully started child.\n\n[](){: #CRASH }\n\n[](){: #crash_report }","ref":"error_logging.html#progress-report"},{"type":"extras","title":"Crash Report - SASL Error Logging","doc":"Processes started with functions [`proc_lib:spawn`](`proc_lib:spawn/1`) or\n[`proc_lib:spawn_link`](`proc_lib:spawn_link/1`) are wrapped within a `catch`. A\ncrash report is issued when such a process terminates with an unexpected reason,\nwhich is any reason other than `normal`, `shutdown`, or `{shutdown,Term}`.\nProcesses using behaviors `m:gen_server`, `m:gen_fsm` or `m:gen_statem` are\nexamples of such processes. A crash report contains the following items:\n\n- **`Crasher`** - Information about the crashing process, such as initial\n  function call, exit reason, and message queue.\n\n- **`Neighbours`** - Information about processes that are linked to the crashing\n  process and do not trap exits. These processes are the neighbours that\n  terminate because of this process crash. The information gathered is the same\n  as the information for Crasher, described in the previous item.","ref":"error_logging.html#crash-report"},{"type":"extras","title":"Example - SASL Error Logging","doc":"The following example shows the reports generated when a process crashes. The\nexample process is a `permanent` process supervised by the `test_sup`\nsupervisor. A division by zero is executed and the error is first reported by\nthe faulty process. A crash report is generated, as the process was started\nusing function `proc_lib:spawn/3`. The supervisor generates a supervisor report\nshowing the crashed process. A progress report is generated when the process is\nfinally restarted.\n\n```text\n        =ERROR REPORT==== 27-May-1996::13:38:56 ===\n        <0.63.0>: Divide by zero !\n\n        =CRASH REPORT==== 27-May-1996::13:38:56 ===\n        crasher:\n        pid: <0.63.0>\n        registered_name: []\n        error_info: {badarith,{test,s,[]}}\n        initial_call: {test,s,[]}\n        ancestors: [test_sup,<0.46.0>]\n        messages: []\n        links: [<0.47.0>]\n        dictionary: []\n        trap_exit: false\n        status: running\n        heap_size: 128\n        stack_size: 128\n        reductions: 348\n        neighbours:\n\n        =SUPERVISOR REPORT==== 27-May-1996::13:38:56 ===\n        Supervisor: {local,test_sup}\n        Context:    child_terminated\n        Reason:     {badarith,{test,s,[]}}\n        Offender:   [{pid,<0.63.0>},\n        {name,test},\n        {mfa,{test,t,[]}},\n        {restart_type,permanent},\n        {shutdown,200},\n        {child_type,worker}]\n\n        =PROGRESS REPORT==== 27-May-1996::13:38:56 ===\n        Supervisor: {local,test_sup}\n        Started:  [{pid,<0.64.0>},\n        {name,test},\n        {mfa,{test,t,[]}},\n        {restart_type,permanent},\n        {shutdown,200},\n        {child_type,worker}]\n```\n\n[](){: #multi_file_logging }","ref":"error_logging.html#example"},{"type":"extras","title":"Multi-File Error Report Logging - SASL Error Logging","doc":"Multi-file error report logging is used to store error messages received by\n`error_logger`. The error messages are stored in several files and each file is\nsmaller than a specified number of kilobytes. No more than a specified number of\nfiles exist at the same time. The logging is very fast, as each error message is\nwritten as a binary term.\n\nFor more details, see the\n[`sasl(6)`](sasl_app.md#deprecated_error_logger_config) application in the\nReference Manual.","ref":"error_logging.html#multi-file-error-report-logging"},{"type":"extras","title":"Report Browser - SASL Error Logging","doc":"The report browser is used to browse and format error reports written by the\nerror logger handler `m:log_mf_h` defined in STDLIB.\n\nThe `log_mf_h` handler writes all reports to a report logging directory, which\nis specified when configuring the SASL application.\n\nIf the report browser is used offline, the reports can be copied to another\ndirectory specified when starting the browser. If no such directory is\nspecified, the browser reads reports from the SASL `error_logger_mf_dir`.","ref":"error_logging.html#report-browser"},{"type":"extras","title":"Starting Report Browser - SASL Error Logging","doc":"Start the `rb_server` with function [`rb:start([Options])`](`rb:start/1`) as\nshown in the following example:\n\n```text\n        5> rb:start([{max, 20}]).\n        rb: reading report...done.\n        rb: reading report...done.\n        rb: reading report...done.\n        rb: reading report...done.\n        {ok,<0.199.0>}\n```","ref":"error_logging.html#starting-report-browser"},{"type":"extras","title":"Online Help - SASL Error Logging","doc":"Enter command [`rb:help()`](`rb:help/0`) to access the report browser online\nhelp system.","ref":"error_logging.html#online-help"},{"type":"extras","title":"List Reports in Server - SASL Error Logging","doc":"Use function [`rb:list()`](`rb:list/0`) to list all loaded reports:\n\n```text\n        4> rb:list().\n        No                Type          Process       Date     Time\n        ==                ====          =======       ====     ====\n        20            progress         <0.17.0> 1996-10-16 16:14:54\n        19            progress         <0.14.0> 1996-10-16 16:14:55\n        18               error         <0.15.0> 1996-10-16 16:15:02\n        17            progress         <0.14.0> 1996-10-16 16:15:06\n        16            progress         <0.38.0> 1996-10-16 16:15:12\n        15            progress         <0.17.0> 1996-10-16 16:16:14\n        14            progress         <0.17.0> 1996-10-16 16:16:14\n        13            progress         <0.17.0> 1996-10-16 16:16:14\n        12            progress         <0.14.0> 1996-10-16 16:16:14\n        11               error         <0.17.0> 1996-10-16 16:16:21\n        10               error         <0.17.0> 1996-10-16 16:16:21\n        9        crash_report  release_handler 1996-10-16 16:16:21\n        8   supervisor_report         <0.17.0> 1996-10-16 16:16:21\n        7            progress         <0.17.0> 1996-10-16 16:16:21\n        6            progress         <0.17.0> 1996-10-16 16:16:36\n        5            progress         <0.17.0> 1996-10-16 16:16:36\n        4            progress         <0.17.0> 1996-10-16 16:16:36\n        3            progress         <0.14.0> 1996-10-16 16:16:36\n        2               error         <0.15.0> 1996-10-16 16:17:04\n        1            progress         <0.14.0> 1996-10-16 16:17:09\n        ok\n```","ref":"error_logging.html#list-reports-in-server"},{"type":"extras","title":"Show Reports - SASL Error Logging","doc":"Use function [`rb:show(Number)`](`rb:show/1`) to show details of a specific\nreport:\n\n```erlang\n7> rb:show(4).\n\nPROGRESS REPORT  <0.20.0>                                   1996-10-16 16:16:36\n===============================================================================\nsupervisor                                                     {local,sasl_sup}\nstarted\n[{pid,<0.24.0>},\n{name,release_handler},\n{mfa,{release_handler,start_link,[]}},\n{restart_type,permanent},\n{shutdown,2000},\n{child_type,worker}]\n\nok\n8> rb:show(9).\n\nCRASH REPORT  <0.24.0>                                      1996-10-16 16:16:21\n===============================================================================\nCrashing process\npid                                                                 <0.24.0>\nregistered_name                                              release_handler\nerror_info                             {undef,{release_handler,mbj_func,[]}}\ninitial_call\n{gen,init_it,\n[gen_server,\n<0.20.0>,\n<0.20.0>,\n{erlang,register},\nrelease_handler,\nrelease_handler,\n[],\n[]]}\nancestors                                                [sasl_sup,<0.18.0>]\nmessages                                                                  []\nlinks                                                    [<0.23.0>,<0.20.0>]\ndictionary                                                                []\ntrap_exit                                                              false\nstatus                                                               running\nheap_size                                                                610\nstack_size                                                               142\nreductions                                                                54\n\nok\n```","ref":"error_logging.html#show-reports"},{"type":"extras","title":"Search Reports - SASL Error Logging","doc":"All reports containing a common pattern can be shown. Suppose a process crashes\nbecause it tries to call a non-existing function `release_handler:mbj_func/1`.\nThe reports can then be shown as follows:\n\n```text\n12> rb:grep(\"mbj_func\").\nFound match in report number 11\n\nERROR REPORT  <0.24.0>                                      1996-10-16 16:16:21\n===============================================================================\n\n** undefined function: release_handler:mbj_func[] **\nFound match in report number 10\n\nERROR REPORT  <0.24.0>                                      1996-10-16 16:16:21\n===============================================================================\n\n** Generic server release_handler terminating\n** Last message in was {unpack_release,hej}\n** When Server state == {state,[],\n\"/home/dup/otp2/otp_beam_sunos5_p1g_7\",\n[{release,\n\"OTP  APN 181 01\",\n\"P1G\",\nundefined,\n[],\npermanent}],\nundefined}\n** Reason for termination ==\n** {undef,{release_handler,mbj_func,[]}}\nFound match in report number 9\n\nCRASH REPORT  <0.24.0>                                      1996-10-16 16:16:21\n===============================================================================\nCrashing process\npid                                                                 <0.24.0>\nregistered_name                                              release_handler\nerror_info                             {undef,{release_handler,mbj_func,[]}}\ninitial_call\n{gen,init_it,\n[gen_server,\n<0.20.0>,\n<0.20.0>,\n{erlang,register},\nrelease_handler,\nrelease_handler,\n[],\n[]]}\nancestors                                                [sasl_sup,<0.18.0>]\nmessages                                                                  []\nlinks                                                    [<0.23.0>,<0.20.0>]\ndictionary                                                                []\ntrap_exit                                                              false\nstatus                                                               running\nheap_size                                                                610\nstack_size                                                               142\nreductions                                                                54\n\nFound match in report number 8\n\nSUPERVISOR REPORT  <0.20.0>                                 1996-10-16 16:16:21\n===============================================================================\nReporting supervisor                                           {local,sasl_sup}\n\nChild process\nerrorContext                                                child_terminated\nreason                                 {undef,{release_handler,mbj_func,[]}}\npid                                                                 <0.24.0>\nname                                                         release_handler\nstart_function                               {release_handler,start_link,[]}\nrestart_type                                                       permanent\nshutdown                                                                2000\nchild_type                                                            worker\n\nok\n```","ref":"error_logging.html#search-reports"},{"type":"extras","title":"Stop Server - SASL Error Logging","doc":"Use function [`rb:stop()`](`rb:stop/0`) to stop the `rb_server`:\n\n```text\n13> rb:stop().\nok\n```","ref":"error_logging.html#stop-server"},{"type":"extras","title":"appup","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# appup\n\nApplication upgrade file","ref":"appup.html"},{"type":"extras","title":"Description - appup","doc":"The _application upgrade file_ defines how an application is upgraded or\ndowngraded in a running system.\n\nThis file is used by the functions in `m:systools` when generating a release\nupgrade file `relup`.","ref":"appup.html#description"},{"type":"extras","title":"File Syntax - appup","doc":"The application upgrade file is to be called `Application.appup`, where\n`Application` is the application name. The file is to be located in the `ebin`\ndirectory for the application.\n\nThe `.appup` file contains one single Erlang term, which defines the\ninstructions used to upgrade or downgrade the application. The file has the\nfollowing syntax:\n\n```c\n{Vsn,\n  [{UpFromVsn, Instructions}, ...],\n  [{DownToVsn, Instructions}, ...]}.\n```\n\n- **`Vsn = string()`** - Current application version.\n\n- **`UpFromVsn = string() | binary()`** - An earlier application version to\n  upgrade from. If it is a string, it is interpreted as a specific version\n  number. If it is a binary, it is interpreted as a regular expression that can\n  match multiple version numbers.\n\n- **`DownToVsn = string() | binary()`** - An earlier application version to\n  downgrade to. If it is a string, it is interpreted as a specific version\n  number. If it is a binary, it is interpreted as a regular expression that can\n  match multiple version numbers.\n\n- **`Instructions`** - A list of _release upgrade instructions_, see\n  [Release Upgrade Instructions](appup.md#release-upgrade-instructions). It\n  is recommended to use high-level instructions only. These are automatically\n  translated to low-level instructions by `systools` when creating the `relup`\n  file.\n\nTo avoid duplication of upgrade instructions, it is allowed to use regular\nexpressions to specify `UpFromVsn` and `DownToVsn`. To be considered a regular\nexpression, the version identifier must be specified as a binary. For example,\nthe following match all versions `2.1.x`, where `x` is any number:\n\n```text\n<<\"2\\\\.1\\\\.[0-9]+\">>\n```\n\nNotice that the regular expression must match the complete version string, so\nthis example works for, for example, `2.1.1`, but not for `2.1.1.1`.","ref":"appup.html#file-syntax"},{"type":"extras","title":"Release Upgrade Instructions - appup","doc":"Release upgrade instructions are interpreted by the release handler when an\nupgrade or downgrade is made. For more information, see\n[_Release Handling_ in _OTP Design Principles_](`e:system:release_handling.md`).\n\nA process is said to _use_ a module `Mod` if `Mod` is listed in the `Modules`\npart of the child specification used to start the process, see `m:supervisor`.\nIn the case of `m:gen_event`, an event manager process is said to use `Mod` if\n`Mod` is an installed event handler.","ref":"appup.html#release-upgrade-instructions"},{"type":"extras","title":"High-Level Instructions - appup","doc":"```text\n{update, Mod}\n{update, Mod, supervisor}\n{update, Mod, Change}\n{update, Mod, DepMods}\n{update, Mod, Change, DepMods}\n{update, Mod, Change, PrePurge, PostPurge, DepMods}\n{update, Mod, Timeout, Change, PrePurge, PostPurge, DepMods}\n{update, Mod, ModType, Timeout, Change, PrePurge, PostPurge, DepMods}\n  Mod = atom()\n  ModType = static | dynamic\n  Timeout = int()>0 | default | infinity\n  Change = soft | {advanced,Extra}\n    Extra = term()\n  PrePurge = PostPurge = soft_purge | brutal_purge\n  DepMods = [Mod]\n```\n\nSynchronized code replacement of processes using module `Mod`.\n\nAll those processes are suspended using [`sys:suspend`](`sys:suspend/1`), the\nnew module version is loaded, and then the processes are resumed using\n[`sys:resume`](`sys:resume/1`).\n\n- **`Change`** - Defaults to `soft` and defines the type of code change. If it\n  is set to `{advanced,Extra}`, implemented processes using `m:gen_server`,\n  `m:gen_fsm`, `m:gen_statem`, or `m:gen_event` transform their internal state\n  by calling the callback function `code_change`. Special processes call the\n  callback function `system_code_change/4`. In both cases, the term `Extra` is\n  passed as an argument to the callback function.\n\n- **`PrePurge`** - Defaults to `brutal_purge`. It controls what action to take\n  with processes executing old code before loading the new module version. If\n  the value is `brutal_purge`, the processes are killed. If the value is\n  `soft_purge`, `release_handler:install_release/1` returns\n  `{error,{old_processes,Mod}}`.\n\n- **`PostPurge`** - Defaults to `brutal_purge`. It controls what action to take\n  with processes that are executing old code when the new module version has\n  been loaded. If the value is `brutal_purge`, the code is purged when the\n  release is made permanent and the processes are killed. If the value is\n  `soft_purge`, the release handler purges the old code when no remaining\n  processes execute the code.\n\n- **`DepMods`** - Defaults to `[]` and defines other modules that `Mod` is\n  dependent on. In the `relup` file, instructions for suspending processes using\n  `Mod` come before instructions for suspending processes using modules in\n  `DepMods` when upgrading, and conversely when downgrading. In case of circular\n  dependencies, the order of the instructions in the `appup` file is kept.\n\n- **`Timeout`** - Defines the time-out when suspending processes. If no value or\n  `default` is specified, the default value for [`sys:suspend`](`sys:suspend/1`)\n  is used.\n\n- **`ModType`** - Defaults to `dynamic`. It specifies if the code is \"dynamic\",\n  that is, if a process using the module spontaneously switches to new code, or\n  if it is \"static\". When doing an advanced update and upgrade, the new version\n  of a dynamic module is loaded before the process is asked to change code. When\n  downgrading, the process is asked to change code before loading the new\n  version. For static modules, the new version is loaded before the process is\n  asked to change code, both in the case of upgrading and downgrading. Callback\n  modules are dynamic.\n\n`update` with argument `supervisor` is used when changing the start\nspecification of a supervisor.\n\n```erlang\n{load_module, Mod}\n{load_module, Mod, DepMods}\n{load_module, Mod, PrePurge, PostPurge, DepMods}\n  Mod = atom()\n  PrePurge = PostPurge = soft_purge | brutal_purge\n  DepMods = [Mod]\n```\n\nSimple code replacement of the module `Mod`.\n\nFor a description of `PrePurge` and `PostPurge`, see `update` above.\n\n`DepMods` defaults to `[]` and defines which other modules `Mod` is dependent\non. In the `relup` file, instructions for loading these modules come before the\ninstruction for loading `Mod` when upgrading, and conversely when downgrading.\n\n```erlang\n{add_module, Mod}\n{add_module, Mod, DepMods}\n  Mod = atom()\n  DepMods = [Mod]\n```\n\nLoads a new module `Mod`.\n\n`DepMods` defaults to `[]` and defines which other modules `Mod` is dependent\non. In the `relup` file, instructions related to these modules come before the\ninstruction for loading `Mod` when upgrading, and conversely when downgrading.\n\n```erlang\n{delete_module, Mod}\n{delete_module, Mod, DepMods}\n  Mod = atom()\n```\n\nDeletes a module `Mod` using the low-level instructions `remove` and `purge`.\n\n`DepMods` defaults to `[]` and defines which other modules `Mod` is dependent\non. In the `relup` file, instructions related to these modules come before the\ninstruction for removing `Mod` when upgrading, and conversely when downgrading.\n\n```text\n{add_application, Application}\n{add_application, Application, Type}\n  Application = atom()\n  Type = permanent | transient | temporary | load | none\n```\n\nAdding an application means that the modules defined by the `modules` key in the\n`.app` file are loaded using `add_module`.\n\n`Type` defaults to `permanent` and specifies the start type of the application.\nIf `Type = permanent | transient | temporary`, the application is loaded and\nstarted in the corresponding way, see `m:application`. If `Type = load`, the\napplication is only loaded. If `Type = none`, the application is not loaded and\nnot started, although the code for its modules is loaded.\n\n```text\n{remove_application, Application}\n  Application = atom()\n```\n\nRemoving an application means that the application is stopped, the modules are\nunloaded using `delete_module`, and then the application specification is\nunloaded from the application controller.\n\n```text\n{restart_application, Application}\n  Application = atom()\n```\n\nRestarting an application means that the application is stopped and then started\nagain, similar to using the instructions `remove_application` and\n`add_application` in sequence. Note that, even if the application has been\nstarted before the release upgrade is performed, `restart_application` may only\n`load` it rather than `start` it, depending on the application's `start type`:\nIf `Type = load`, the application is only loaded. If `Type = none`, the\napplication is not loaded and not started, although the code for its modules is\nloaded.","ref":"appup.html#high-level-instructions"},{"type":"extras","title":"Low-Level Instructions - appup","doc":"```erlang\n{load_object_code, {App, Vsn, [Mod]}}\n  App = Mod = atom()\n  Vsn = string()\n```\n\nReads each `Mod` from directory `App-Vsn/ebin` as a binary. It does not load the\nmodules. The instruction is to be placed first in the script to read all new\ncode from the file to make the suspend-load-resume cycle less time-consuming.\n\n```text\npoint_of_no_return\n```\n\nIf a crash occurs after this instruction, the system cannot recover and is\nrestarted from the old release version. The instruction must only occur once in\na script. It is to be placed after all `load_object_code` instructions.\n\n```text\n{load, {Mod, PrePurge, PostPurge}}\n  Mod = atom()\n  PrePurge = PostPurge = soft_purge | brutal_purge\n```\n\nBefore this instruction occurs, `Mod` must have been loaded using\n`load_object_code`. This instruction loads the module. `PrePurge` is ignored.\nFor a description of `PostPurge`, see the high-level instruction `update`\nearlier.\n\n```text\n{remove, {Mod, PrePurge, PostPurge}}\n  Mod = atom()\n  PrePurge = PostPurge = soft_purge | brutal_purge\n```\n\nMakes the current version of `Mod` old. `PrePurge` is ignored. For a description\nof `PostPurge`, see the high-level instruction `update` earlier.\n\n```text\n{purge, [Mod]}\n  Mod = atom()\n```\n\nPurges each module `Mod`, that is, removes the old code. Notice that any process\nexecuting purged code is killed.\n\n```erlang\n{suspend, [Mod | {Mod, Timeout}]}\n  Mod = atom()\n  Timeout = int()>0 | default | infinity\n```\n\nTries to suspend all processes using a module `Mod`. If a process does not\nrespond, it is ignored. This can cause the process to die, either because it\ncrashes when it spontaneously switches to new code, or as a result of a purge\noperation. If no `Timeout` is specified or `default` is specified, the default\nvalue for [`sys:suspend`](`sys:suspend/1`) is used.\n\n```text\n{resume, [Mod]}\n  Mod = atom()\n```\n\nResumes all suspended processes using a module `Mod`.\n\n```erlang\n{code_change, [{Mod, Extra}]}\n{code_change, Mode, [{Mod, Extra}]}\n  Mod = atom()\n  Mode = up | down\n  Extra = term()\n```\n\n`Mode` defaults to `up` and specifies if it is an upgrade or downgrade. This\ninstruction sends a `code_change` system message to all processes using a module\n`Mod` by calling function [`sys:change_code`](`sys:change_code/4`), passing term\n`Extra` as argument.\n\n```text\n{stop, [Mod]}\n  Mod = atom()\n```\n\nStops all processes using a module `Mod` by calling\n`supervisor:terminate_child/2`. This instruction is useful when the simplest way\nto change code is to stop and restart the processes that run the code.\n\n```erlang\n{start, [Mod]}\n  Mod = atom()\n```\n\nStarts all stopped processes using a module `Mod` by calling\n`supervisor:restart_child/2`.\n\n```erlang\n{sync_nodes, Id, [Node]}\n{sync_nodes, Id, {M, F, A}}\n  Id = term()\n  Node = node()\n  M = F = atom()\n  A = [term()]\n```\n\n[`apply(M, F, A)`](`apply/3`) must return a list of nodes.\n\nThis instruction synchronizes the release installation with other nodes. Each\n`Node` must evaluate this command with the same `Id`. The local node waits for\nall other nodes to evaluate the instruction before execution continues. If a\nnode goes down, it is considered to be an unrecoverable error, and the local\nnode is restarted from the old release. There is no time-out for this\ninstruction, which means that it can hang forever.\n\n```erlang\n{apply, {M, F, A}}\n  M = F = atom()\n  A = [term()]\n```\n\nEvaluates [`apply(M, F, A)`](`apply/3`).\n\nIf the instruction appears before instruction `point_of_no_return`, a failure is\ncaught. `release_handler:install_release/1` then returns\n`{error,{'EXIT',Reason}}`, unless `{error,Error}` is thrown or returned. Then it\nreturns `{error,Error}`.\n\nIf the instruction appears after instruction `point_of_no_return` and the\nfunction call fails, the system is restarted.\n\n```text\nrestart_new_emulator\n```\n\nThis instruction is used when the application ERTS, Kernel, STDLIB, or SASL is\nupgraded. It shuts down the current emulator and starts a new one. All processes\nare terminated gracefully, and the new version of ERTS, Kernel, STDLIB, and SASL\nare used when the emulator restarts. Only one `restart_new_emulator` instruction\nis allowed in the `relup` file, and it must be placed first.\n[`systools:make_relup/3,4`](`systools:make_relup/3`) ensures this when the\n`relup` file is generated. The rest of the instructions in the `relup` file is\nexecuted after the restart as a part of the boot script.\n\nAn info report is written when the upgrade is completed. To programmatically\ndetermine if the upgrade is complete, call\n[`release_handler:which_releases/0,1`](`release_handler:which_releases/0`) and\ncheck if the expected release has status `current`.\n\nThe new release must still be made permanent after the upgrade is completed,\notherwise the old emulator is started if there is an emulator restart.\n\n> #### Warning {: .warning }\n>\n> As stated earlier, instruction `restart_new_emulator` causes the emulator to\n> be restarted with new versions of ERTS, Kernel, STDLIB, and SASL. However, all\n> other applications do at startup run their old versions in this new emulator.\n> This is usually no problem, but every now and then incompatible changes occur\n> to the core applications, which can cause trouble in this setting. Such\n> incompatible changes (when functions are removed) are normally preceded by a\n> deprecation over two major releases. To ensure that your application is not\n> crashed by an incompatible change, always remove any call to deprecated\n> functions as soon as possible.\n\n```text\nrestart_emulator\n```\n\nThis instruction is similar to `restart_new_emulator`, except it must be placed\nat the end of the `relup` file. It is not related to an upgrade of the emulator\nor the core applications, but can be used by any application when a complete\nreboot of the system is required.\n\nWhen generating the `relup` file,\n[`systools:make_relup/3,4`](`systools:make_relup/3`) ensures that there is only\none `restart_emulator` instruction and that it is the last instruction in the\n`relup` file.","ref":"appup.html#low-level-instructions"},{"type":"extras","title":"See Also - appup","doc":"`m:release_handler`, [`relup(4)`](relup.md), `m:supervisor`, `m:systools`","ref":"appup.html#see-also"},{"type":"extras","title":"rel","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# rel\n\nRelease resource file","ref":"rel.html"},{"type":"extras","title":"Description - rel","doc":"The _release resource file_ specifies which applications are included in a\nrelease (system) based on Erlang/OTP.\n\nThis file is used by the functions in `m:systools` when generating start scripts\n(`.script`, `.boot`) and release upgrade files (`relup`).","ref":"rel.html#description"},{"type":"extras","title":"File Syntax - rel","doc":"The release resource file is to be called `Name.rel`.\n\nThe `.rel` file contains one single Erlang term, which is called a _release\nspecification_. The file has the following syntax:\n\n```erlang\n{release, {RelName,Vsn}, {erts, EVsn},\n  [{Application, AppVsn} |\n   {Application, AppVsn, Type} |\n   {Application, AppVsn, IncApps} |\n   {Application, AppVsn, Type, IncApps}]}.\n```\n\n- **`RelName = string()`** - Release name.\n\n- **`Vsn = string()`** - Release version.\n\n- **`EVsn = string()`** - ERTS version the release is intended for.\n\n- **`Application = atom()`** - Name of an application included in the release.\n\n- **`AppVsn = string()`** - Version of an application included in the release.\n\n- **`Type = permanent | transient | temporary | load | none`** - Start type of\n  an application included in the release.\n\n  If `Type = permanent | transient | temporary`, the application is loaded and\n  started in the corresponding way, see `m:application`.\n\n  If `Type = load`, the application is only loaded.\n\n  If `Type = none`, the application is not loaded and not started, although the\n  code for its modules is loaded.\n\n  Defaults to `permanent`\n\n- **`IncApps = [atom()]`** - A list of applications that are included by an\n  application included in the release. The list must be a subset of the included\n  applications specified in the application resource file (`Application.app`)\n  and overrides this value. Defaults to the same value as in the application\n  resource file.\n\n> #### Note {: .info }\n>\n> The list of applications must contain the Kernel and STDLIB applications.","ref":"rel.html#file-syntax"},{"type":"extras","title":"See Also - rel","doc":"`m:application`, [`relup(4)`](relup.md), `m:systools`","ref":"rel.html#see-also"},{"type":"extras","title":"relup","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# relup\n\nRelease upgrade file","ref":"relup.html"},{"type":"extras","title":"Description - relup","doc":"The _release upgrade file_ describes how a release is upgraded in a running\nsystem.\n\nThis file is automatically generated by\n[`systools:make_relup/3,4`](`systools:make_relup/3`), using a release resource\nfile (`.rel`), application resource files (`.app`), and application upgrade\nfiles (`.appup`) as input.","ref":"relup.html#description"},{"type":"extras","title":"File Syntax - relup","doc":"In a target system, the release upgrade file is to be located in directory\n`$ROOT/releases/Vsn`.\n\nThe `relup` file contains one single Erlang term, which defines the instructions\nused to upgrade the release. The file has the following syntax:\n\n```c\n{Vsn,\n  [{UpFromVsn, Descr, Instructions}, ...],\n  [{DownToVsn, Descr, Instructions}, ...]}.\n```\n\n- **`Vsn = string()`** - Current release version.\n\n- **`UpFromVsn = string()`** - Earlier version of the release to upgrade from.\n\n- **`Descr = term()`** - A user-defined parameter passed from the function\n  [`systools:make_relup/3,4`](`systools:make_relup/3`). It is used in the return\n  value of\n  [`release_handler:install_release/1,2`](`release_handler:install_release/1`).\n\n- **`Instructions`** - A list of low-level release upgrade instructions, see\n  [`appup(4)`](appup.md). It consists of the release upgrade instructions from\n  the respective application upgrade files (high-level instructions are\n  translated to low-level instructions), in the same order as in the start\n  script.\n\n- **`DownToVsn = string()`** - Earlier version of the release to downgrade to.","ref":"relup.html#file-syntax"},{"type":"extras","title":"See Also - relup","doc":"[`app(4)`](`e:kernel:app.md`), [`appup(4)`](appup.md), [`rel(4)`](rel.md),\n`m:release_handler`, `m:systools`","ref":"relup.html#see-also"},{"type":"extras","title":"script","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# script\n\nBoot script","ref":"script.html"},{"type":"extras","title":"Description - script","doc":"The _boot script_ describes how the Erlang runtime system is started. It\ncontains instructions for which code to load, and which processes and applications\nto start.\n\nCommand `erl -boot Name` starts the system with a boot file called `Name.boot`,\nwhich is generated from the `Name.script` file, using `systools:script2boot/1`.\n\nThe `.script` file is generated by `systools` from a `.rel` file and from `.app`\nfiles.","ref":"script.html#description"},{"type":"extras","title":"File Syntax - script","doc":"The boot script is stored in a file with extension `.script`. The file has the\nfollowing syntax:\n\n```erlang\n{script, {Name, Vsn},\n [\n  {progress, loading},\n  {preLoaded, [Mod1, Mod2, ...]},\n  {path, [Dir1,\"$ROOT/Dir\",...]}.\n  {primLoad, [Mod1, Mod2, ...]},\n  ...\n  {kernel_load_completed},\n  {progress, loaded},\n  {kernelProcess, Name, {Mod, Func, Args}},\n  ...\n  {apply, {Mod, Func, Args}},\n  ...\n  {progress, started}]}.\n```\n\n- **`Name = string()`** - Defines the system name.\n\n- **`Vsn = string()`** - Defines the system version.\n\n- **`{progress, Term}`** - Sets the \"progress\" of the initialization program.\n  The `init:get_status/0` function returns the current value of the progress,\n  which is `{InternalStatus,Term}`.\n\n- **`{path, [Dir]}`** - `Dir` is a string. This argument sets the load path of\n  the system to `[Dir]`. The load path used to load modules is obtained from the\n  initial load path, which is given in the script file, together with any path\n  flags that were supplied in the command-line arguments. The command-line\n  arguments modify the path as follows:\n\n  - `-pa Dir1 Dir2 ... DirN` adds the directories\n    `DirN, DirN-1, ..., Dir2, Dir1` to the front of the initial load path.\n  - `-pz Dir1 Dir2 ... DirN` adds the directories `Dir1, Dir2, ..., DirN` to the\n    end of the initial load path.\n  - `-path Dir1 Dir2 ... DirN` defines a set of directories\n    `Dir1, Dir2, ..., DirN`, which replace the search path given in the script\n    file. Directory names in the path are interpreted as follows:\n\n    - Directory names starting with `/` are assumed to be absolute path names.\n    - Directory names not starting with `/` are assumed to be relative the\n      current working directory.\n    - The special `$ROOT` variable can only be used in the script, not as a\n      command-line argument. The given directory is relative the Erlang\n      installation directory.\n\n- **`{primLoad, [Mod]}`** - Loads the modules `[Mod]` from the directories\n  specified in `Path`. The script interpreter fetches the appropriate module by\n  calling [`erl_prim_loader:get_file(Mod)`](`erl_prim_loader:get_file/1`). A\n  fatal error that terminates the system occurs if the module cannot be located.\n\n- **`{kernel_load_completed}`** - Indicates that all modules that _must_ be\n  loaded _before_ any processes are started are loaded. In interactive mode, all\n  `{primLoad,[Mod]}` commands interpreted after this command are ignored, and\n  these modules are loaded on demand. In embedded mode, `kernel_load_completed`\n  is ignored, and all modules are loaded during system start.\n\n- **`{kernelProcess, Name, {Mod, Func, Args}}`** - Starts the \"kernel process\"\n  `Name` by evaluating [`apply(Mod, Func, Args)`](`apply/3`). The start function\n  is to return `{ok, Pid}` or `ignore`. The `init` process monitors the behavior\n  of `Pid` and terminates the system if `Pid` dies. Kernel processes are key\n  components of the runtime system. Users do not normally add new kernel\n  processes.\n\n- **`{apply, {Mod, Func, Args}}`.** - The init process evaluates\n  [`apply(Mod, Func, Args)`](`apply/3`). The system terminates if this results\n  in an error. The boot procedure hangs if this function never returns.\n\n> #### Note {: .info }\n>\n> In an interactive system, the code loader provides demand-driven code loading,\n> but in an embedded system the code loader loads all code immediately. The same\n> version of `m:code` is used in both cases. The code server calls\n> [`init:get_argument(mode)`](`init:get_argument/1`) to determine if it is to\n> run in demand mode or non-demand driven mode.","ref":"script.html#file-syntax"},{"type":"extras","title":"See Also - script","doc":"`m:systools`","ref":"script.html#see-also"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.38.1"}}