/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Interface Declarations                                                     *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace fir {
/// Interface for operations that create Fortran like variables in order to
///     query about all their Fortran properties.
class FortranVariableOpInterface;
namespace detail {
struct FortranVariableOpInterfaceInterfaceTraits {
  struct Concept {
    /// The methods defined by the interface.
    mlir::Value (*getBase)(const Concept *impl, ::mlir::Operation *);
    std::optional<fir::FortranVariableFlagsEnum> (*getFortranAttrs)(const Concept *impl, ::mlir::Operation *);
    mlir::Value (*getShape)(const Concept *impl, ::mlir::Operation *);
    mlir::OperandRange (*getExplicitTypeParams)(const Concept *impl, ::mlir::Operation *);
    void (*setFortranAttrs)(const Concept *impl, ::mlir::Operation *, fir::FortranVariableFlagsEnum);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    using Interface = fir::FortranVariableOpInterface;
    Model() : Concept{getBase, getFortranAttrs, getShape, getExplicitTypeParams, setFortranAttrs} {}

    static inline mlir::Value getBase(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::optional<fir::FortranVariableFlagsEnum> getFortranAttrs(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline mlir::Value getShape(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline mlir::OperandRange getExplicitTypeParams(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setFortranAttrs(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, fir::FortranVariableFlagsEnum flags);
  };
  template<typename ConcreteOp>
  class FallbackModel : public Concept {
  public:
    using Interface = fir::FortranVariableOpInterface;
    FallbackModel() : Concept{getBase, getFortranAttrs, getShape, getExplicitTypeParams, setFortranAttrs} {}

    static inline mlir::Value getBase(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::optional<fir::FortranVariableFlagsEnum> getFortranAttrs(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline mlir::Value getShape(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline mlir::OperandRange getExplicitTypeParams(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setFortranAttrs(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, fir::FortranVariableFlagsEnum flags);
  };
  template<typename ConcreteModel, typename ConcreteOp>
  class ExternalModel : public FallbackModel<ConcreteModel> {
  public:
    using ConcreteEntity = ConcreteOp;
    mlir::Value getBase(::mlir::Operation *tablegen_opaque_val) const;
    std::optional<fir::FortranVariableFlagsEnum> getFortranAttrs(::mlir::Operation *tablegen_opaque_val) const;
    mlir::Value getShape(::mlir::Operation *tablegen_opaque_val) const;
    mlir::OperandRange getExplicitTypeParams(::mlir::Operation *tablegen_opaque_val) const;
    void setFortranAttrs(::mlir::Operation *tablegen_opaque_val, fir::FortranVariableFlagsEnum flags) const;
  };
};
template <typename ConcreteOp>
struct FortranVariableOpInterfaceTrait;

} // namespace detail
class FortranVariableOpInterface : public ::mlir::OpInterface<FortranVariableOpInterface, detail::FortranVariableOpInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<FortranVariableOpInterface, detail::FortranVariableOpInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct Trait : public detail::FortranVariableOpInterfaceTrait<ConcreteOp> {};

  /// Get the address produced by the definition
  mlir::Value getBase();

  /// Get Fortran attributes
  std::optional<fir::FortranVariableFlagsEnum> getFortranAttrs();

  /// Get the shape of the variable. May be a null value.
  mlir::Value getShape();

  /// Get explicit type parameters of the variable
  mlir::OperandRange getExplicitTypeParams();

  /// Set Fortran attributes
  void setFortranAttrs(fir::FortranVariableFlagsEnum flags);


    /// Get the sequence type or scalar value type corresponding to this
    /// variable.
    mlir::Type getElementOrSequenceType() {
      mlir::Type type = fir::unwrapPassByRefType(fir::unwrapRefType(getBase().getType()));
      if (auto boxCharType = mlir::dyn_cast<fir::BoxCharType>(type))
        return boxCharType.getEleTy();
      return type;
    }

    /// Get the scalar value type corresponding to this variable.
    mlir::Type getElementType() {
      return fir::unwrapSequenceType(getElementOrSequenceType());
    }

    /// Is the variable an array?
    bool isArray() {
      return mlir::isa<fir::SequenceType>(getElementOrSequenceType());
    }

    /// Return the rank of the entity if it is known at compile time.
    std::optional<unsigned> getRank() {
      if (auto sequenceType =
            mlir::dyn_cast<fir::SequenceType>(getElementOrSequenceType())) {
        if (sequenceType.hasUnknownShape())
          return {};
        return sequenceType.getDimension();
      }
      return 0;
    }

    /// Is this variable a Fortran pointer?
    bool isPointer() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::pointer);
    }

    /// Is this variable a Fortran allocatable?
    bool isAllocatable() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::allocatable);
    }

    /// Is this variable a Fortran optional?
    bool isOptional() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::optional);
    }

    /// Does this variable have the Fortran CONTIGUOUS attribute?
    /// Note that not having this attribute does not imply the
    /// variable is not contiguous.
    bool hasContiguousAttr() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::contiguous);
    }

    /// Is this a Fortran character variable?
    bool isCharacter() {
      return mlir::isa<fir::CharacterType>(getElementType());
    }

    /// Is this a Fortran character variable with an explicit length?
    bool hasExplicitCharLen() {
      return isCharacter() && !getExplicitTypeParams().empty();
    }

    /// Return the length of explicit length character variable.
    mlir::Value getExplicitCharLen() {
      assert(hasExplicitCharLen() && "must be an explicit length character");
      return getExplicitTypeParams()[0];
    }

    /// Is this variable represented as a fir.box or fir.class value?
    bool isBoxValue() {
      return mlir::isa<fir::BaseBoxType>(getBase().getType());
    }

    /// Is this variable represented as a fir.box or fir.class address?
    bool isBoxAddress() {
      return fir::isBoxAddress(getBase().getType());
    }

    /// Is this variable represented as the value or address of a fir.box or
    /// fir.class?
    bool isBox() {
      return fir::isBoxAddressOrValue(getBase().getType());
    }

    /// Is this variable a Fortran parameter?
    bool isParameter() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::parameter);
    }

    /// Is this a host associated variable?
    bool isHostAssoc() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::host_assoc);
    }

    /// Is this variable a Fortran target?
    bool isTarget() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::target);
    }

    /// Is this variable captured in an internal procedure via Fortran host association?
    bool isCapturedInInternalProcedure() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::internal_assoc);
    }

    /// Is this variable a Fortran intent(in)?
    bool isIntentIn() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::intent_in);
    }

    /// Interface verifier imlementation for declare operations.
    llvm::LogicalResult verifyDeclareLikeOpImpl(mlir::Value memRef);
};
namespace detail {
  template <typename ConcreteOp>
  struct FortranVariableOpInterfaceTrait : public ::mlir::OpInterface<FortranVariableOpInterface, detail::FortranVariableOpInterfaceInterfaceTraits>::Trait<ConcreteOp> {

    /// Get the address produced by the definition
    mlir::Value getBase() {
      ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getResult();
    }

    /// Get Fortran attributes
    std::optional<fir::FortranVariableFlagsEnum> getFortranAttrs() {
      ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getFortran_attrs();
    }

    /// Get the shape of the variable. May be a null value.
    mlir::Value getShape() {
      ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getShape();
    }

    /// Get explicit type parameters of the variable
    mlir::OperandRange getExplicitTypeParams() {
      ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getTypeparams();
    }

    /// Set Fortran attributes
    void setFortranAttrs(fir::FortranVariableFlagsEnum flags) {
      ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        op.setFortran_attrs(fir::FortranVariableFlagsAttr::get(op->getContext(), flags));
    }
  };
}// namespace detail
} // namespace fir
namespace fir {
/// An extension of FortranVariableOpInterface for operations that provide
///     information about the physical storage layout of the variable.
///     The operations provide the raw address of the physical storage
///     and the byte offset where the variable begins within the physical
///     storage.
///     The storage is a reference to an array of known size consisting
///     of i8 elements. This is how Flang represents COMMON and EQUIVALENCE
///     storage blocks with the member variables located within the storage
///     at different offsets. The storage offset for a variable must not
///     exceed the storage size. Note that the zero-sized variables
///     may start at the offset that is after the final byte of the storage.
///     When getStorage() returns nullptr, getStorageOffset() must return 0.
///     This means that nothing is known about the physical storage
///     of the variable (beyond the information maybe provided
///     by the concrete operation itself, e.g. fir.declare defines
///     the physical storage of a variable via memref operand,
///     where the variable starts).
class FortranVariableStorageOpInterface;
namespace detail {
struct FortranVariableStorageOpInterfaceInterfaceTraits {
  struct Concept {
    /// The methods defined by the interface.
    mlir::Value (*getStorage)(const Concept *impl, ::mlir::Operation *);
    std::uint64_t (*getStorageOffset)(const Concept *impl, ::mlir::Operation *);
    /// The base classes of this interface.
    const fir::FortranVariableOpInterface::Concept *implFortranVariableOpInterface = nullptr;

    void initializeInterfaceConcept(::mlir::detail::InterfaceMap &interfaceMap) {
      implFortranVariableOpInterface = interfaceMap.lookup<fir::FortranVariableOpInterface>();
      assert(implFortranVariableOpInterface && "`fir::FortranVariableStorageOpInterface` expected its base interface `fir::FortranVariableOpInterface` to be registered");
    }
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    using Interface = fir::FortranVariableStorageOpInterface;
    Model() : Concept{getStorage, getStorageOffset} {}

    static inline mlir::Value getStorage(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::uint64_t getStorageOffset(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteOp>
  class FallbackModel : public Concept {
  public:
    using Interface = fir::FortranVariableStorageOpInterface;
    FallbackModel() : Concept{getStorage, getStorageOffset} {}

    static inline mlir::Value getStorage(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::uint64_t getStorageOffset(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteModel, typename ConcreteOp>
  class ExternalModel : public FallbackModel<ConcreteModel> {
  public:
    using ConcreteEntity = ConcreteOp;
    mlir::Value getStorage(::mlir::Operation *tablegen_opaque_val) const;
    std::uint64_t getStorageOffset(::mlir::Operation *tablegen_opaque_val) const;
  };
};
template <typename ConcreteOp>
struct FortranVariableStorageOpInterfaceTrait;

} // namespace detail
class FortranVariableStorageOpInterface : public ::mlir::OpInterface<FortranVariableStorageOpInterface, detail::FortranVariableStorageOpInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<FortranVariableStorageOpInterface, detail::FortranVariableStorageOpInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct Trait : public detail::FortranVariableStorageOpInterfaceTrait<ConcreteOp> {};

  /// Returns the raw address of the physical storage
  mlir::Value getStorage();

  /// Returns the byte offset where the variable begins within the physical storage
  std::uint64_t getStorageOffset();
  //===----------------------------------------------------------------===//
  // Inherited from fir::FortranVariableOpInterface
  //===----------------------------------------------------------------===//

  operator fir::FortranVariableOpInterface () const {
    if (!*this) return nullptr;
    return fir::FortranVariableOpInterface(*this, getImpl()->implFortranVariableOpInterface);
  }


  /// Get the address produced by the definition
  mlir::Value getBase();

  /// Get Fortran attributes
  std::optional<fir::FortranVariableFlagsEnum> getFortranAttrs();

  /// Get the shape of the variable. May be a null value.
  mlir::Value getShape();

  /// Get explicit type parameters of the variable
  mlir::OperandRange getExplicitTypeParams();

  /// Set Fortran attributes
  void setFortranAttrs(fir::FortranVariableFlagsEnum flags);


    /// Get the sequence type or scalar value type corresponding to this
    /// variable.
    mlir::Type getElementOrSequenceType() {
      mlir::Type type = fir::unwrapPassByRefType(fir::unwrapRefType(getBase().getType()));
      if (auto boxCharType = mlir::dyn_cast<fir::BoxCharType>(type))
        return boxCharType.getEleTy();
      return type;
    }

    /// Get the scalar value type corresponding to this variable.
    mlir::Type getElementType() {
      return fir::unwrapSequenceType(getElementOrSequenceType());
    }

    /// Is the variable an array?
    bool isArray() {
      return mlir::isa<fir::SequenceType>(getElementOrSequenceType());
    }

    /// Return the rank of the entity if it is known at compile time.
    std::optional<unsigned> getRank() {
      if (auto sequenceType =
            mlir::dyn_cast<fir::SequenceType>(getElementOrSequenceType())) {
        if (sequenceType.hasUnknownShape())
          return {};
        return sequenceType.getDimension();
      }
      return 0;
    }

    /// Is this variable a Fortran pointer?
    bool isPointer() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::pointer);
    }

    /// Is this variable a Fortran allocatable?
    bool isAllocatable() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::allocatable);
    }

    /// Is this variable a Fortran optional?
    bool isOptional() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::optional);
    }

    /// Does this variable have the Fortran CONTIGUOUS attribute?
    /// Note that not having this attribute does not imply the
    /// variable is not contiguous.
    bool hasContiguousAttr() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::contiguous);
    }

    /// Is this a Fortran character variable?
    bool isCharacter() {
      return mlir::isa<fir::CharacterType>(getElementType());
    }

    /// Is this a Fortran character variable with an explicit length?
    bool hasExplicitCharLen() {
      return isCharacter() && !getExplicitTypeParams().empty();
    }

    /// Return the length of explicit length character variable.
    mlir::Value getExplicitCharLen() {
      assert(hasExplicitCharLen() && "must be an explicit length character");
      return getExplicitTypeParams()[0];
    }

    /// Is this variable represented as a fir.box or fir.class value?
    bool isBoxValue() {
      return mlir::isa<fir::BaseBoxType>(getBase().getType());
    }

    /// Is this variable represented as a fir.box or fir.class address?
    bool isBoxAddress() {
      return fir::isBoxAddress(getBase().getType());
    }

    /// Is this variable represented as the value or address of a fir.box or
    /// fir.class?
    bool isBox() {
      return fir::isBoxAddressOrValue(getBase().getType());
    }

    /// Is this variable a Fortran parameter?
    bool isParameter() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::parameter);
    }

    /// Is this a host associated variable?
    bool isHostAssoc() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::host_assoc);
    }

    /// Is this variable a Fortran target?
    bool isTarget() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::target);
    }

    /// Is this variable captured in an internal procedure via Fortran host association?
    bool isCapturedInInternalProcedure() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::internal_assoc);
    }

    /// Is this variable a Fortran intent(in)?
    bool isIntentIn() {
      auto attrs = getFortranAttrs();
      return attrs && bitEnumContainsAny(*attrs,
                        fir::FortranVariableFlagsEnum::intent_in);
    }

    /// Interface verifier imlementation for declare operations.
    llvm::LogicalResult verifyDeclareLikeOpImpl(mlir::Value memRef);
};
namespace detail {
  template <typename ConcreteOp>
  struct FortranVariableStorageOpInterfaceTrait : public ::mlir::OpInterface<FortranVariableStorageOpInterface, detail::FortranVariableStorageOpInterfaceInterfaceTraits>::Trait<ConcreteOp> {

    /// Returns the raw address of the physical storage
    mlir::Value getStorage() {
      ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getStorage();
    }

    /// Returns the byte offset where the variable begins within the physical storage
    std::uint64_t getStorageOffset() {
      ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getStorageOffset();
    }
    static ::llvm::LogicalResult verifyTrait(::mlir::Operation *op) {
      return detail::verifyFortranVariableStorageOpInterface(op);
    }
  };
}// namespace detail
} // namespace fir
namespace fir {
template<typename ConcreteOp>
mlir::Value detail::FortranVariableOpInterfaceInterfaceTraits::Model<ConcreteOp>::getBase(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getBase();
}
template<typename ConcreteOp>
std::optional<fir::FortranVariableFlagsEnum> detail::FortranVariableOpInterfaceInterfaceTraits::Model<ConcreteOp>::getFortranAttrs(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getFortranAttrs();
}
template<typename ConcreteOp>
mlir::Value detail::FortranVariableOpInterfaceInterfaceTraits::Model<ConcreteOp>::getShape(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getShape();
}
template<typename ConcreteOp>
mlir::OperandRange detail::FortranVariableOpInterfaceInterfaceTraits::Model<ConcreteOp>::getExplicitTypeParams(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getExplicitTypeParams();
}
template<typename ConcreteOp>
void detail::FortranVariableOpInterfaceInterfaceTraits::Model<ConcreteOp>::setFortranAttrs(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, fir::FortranVariableFlagsEnum flags) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setFortranAttrs(flags);
}
template<typename ConcreteOp>
mlir::Value detail::FortranVariableOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getBase(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getBase(tablegen_opaque_val);
}
template<typename ConcreteOp>
std::optional<fir::FortranVariableFlagsEnum> detail::FortranVariableOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getFortranAttrs(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getFortranAttrs(tablegen_opaque_val);
}
template<typename ConcreteOp>
mlir::Value detail::FortranVariableOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getShape(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getShape(tablegen_opaque_val);
}
template<typename ConcreteOp>
mlir::OperandRange detail::FortranVariableOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getExplicitTypeParams(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getExplicitTypeParams(tablegen_opaque_val);
}
template<typename ConcreteOp>
void detail::FortranVariableOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setFortranAttrs(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, fir::FortranVariableFlagsEnum flags) {
  return static_cast<const ConcreteOp *>(impl)->setFortranAttrs(tablegen_opaque_val, flags);
}
template<typename ConcreteModel, typename ConcreteOp>
mlir::Value detail::FortranVariableOpInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getBase(::mlir::Operation *tablegen_opaque_val) const {
ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getResult();
}
template<typename ConcreteModel, typename ConcreteOp>
std::optional<fir::FortranVariableFlagsEnum> detail::FortranVariableOpInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getFortranAttrs(::mlir::Operation *tablegen_opaque_val) const {
ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getFortran_attrs();
}
template<typename ConcreteModel, typename ConcreteOp>
mlir::Value detail::FortranVariableOpInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getShape(::mlir::Operation *tablegen_opaque_val) const {
ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getShape();
}
template<typename ConcreteModel, typename ConcreteOp>
mlir::OperandRange detail::FortranVariableOpInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getExplicitTypeParams(::mlir::Operation *tablegen_opaque_val) const {
ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getTypeparams();
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::FortranVariableOpInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setFortranAttrs(::mlir::Operation *tablegen_opaque_val, fir::FortranVariableFlagsEnum flags) const {
ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        op.setFortran_attrs(fir::FortranVariableFlagsAttr::get(op->getContext(), flags));
}
} // namespace fir
namespace fir {
template<typename ConcreteOp>
mlir::Value detail::FortranVariableStorageOpInterfaceInterfaceTraits::Model<ConcreteOp>::getStorage(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getStorage();
}
template<typename ConcreteOp>
std::uint64_t detail::FortranVariableStorageOpInterfaceInterfaceTraits::Model<ConcreteOp>::getStorageOffset(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getStorageOffset();
}
template<typename ConcreteOp>
mlir::Value detail::FortranVariableStorageOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getStorage(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getStorage(tablegen_opaque_val);
}
template<typename ConcreteOp>
std::uint64_t detail::FortranVariableStorageOpInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getStorageOffset(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getStorageOffset(tablegen_opaque_val);
}
template<typename ConcreteModel, typename ConcreteOp>
mlir::Value detail::FortranVariableStorageOpInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getStorage(::mlir::Operation *tablegen_opaque_val) const {
ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getStorage();
}
template<typename ConcreteModel, typename ConcreteOp>
std::uint64_t detail::FortranVariableStorageOpInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getStorageOffset(::mlir::Operation *tablegen_opaque_val) const {
ConcreteOp op = mlir::cast<ConcreteOp>(this->getOperation());
        return op.getStorageOffset();
}
} // namespace fir
