/*
 * Decompiled with CFR 0.152.
 */
package com.instaclustr.cassandra.driver.auth;

import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.auth.AuthenticationException;
import com.datastax.oss.driver.api.core.auth.Authenticator;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.instaclustr.cassandra.driver.auth.ServerNameResolver;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KerberosAuthProviderBase
implements AuthProvider {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosAuthProviderBase.class);
    private final String logPrefix;

    public KerberosAuthProviderBase(String logPrefix) {
        this.logPrefix = logPrefix;
    }

    protected abstract KerberosAuthOptions getOptions(EndPoint var1);

    @NonNull
    public Authenticator newAuthenticator(@NonNull EndPoint endPoint, @NonNull String serverAuthenticator) throws AuthenticationException {
        return new KerberosAuthenticator(this.getOptions(endPoint), endPoint);
    }

    public void onMissingChallenge(@NonNull EndPoint endPoint) throws AuthenticationException {
        LOG.warn("[{}] {} did not send an authentication challenge; This is suspicious because the driver expects authentication", (Object)this.logPrefix, (Object)endPoint);
    }

    public void close() throws Exception {
    }

    public static enum KerberosOption implements DriverOption
    {
        AUTH_PROVIDER_AUTHORIZATION_ID("advanced.auth-provider.authorization-id"),
        AUTH_PROVIDER_SASL_PROTOCOL("advanced.auth-provider.sasl-protocol"),
        AUTH_PROVIDER_SASL_PROPERTIES("advanced.auth-provider.sasl-properties"),
        AUTH_PROVIDER_SERVER_NAME_RESOLVER("advanced.auth-provider.server-name-resolver");

        public static final String DEFAULT_SASL_PROTOCOL = "cassandra";
        protected static final Map<String, String> DEFAULT_SASL_PROPERTIES;
        private final String path;

        private KerberosOption(String path) {
            this.path = path;
        }

        @NonNull
        public String getPath() {
            return this.path;
        }

        static {
            DEFAULT_SASL_PROPERTIES = ImmutableMap.builder().put((Object)"javax.security.sasl.server.authentication", (Object)"true").put((Object)"javax.security.sasl.qop", (Object)"auth").build();
        }
    }

    private static class KerberosAuthenticator
    implements Authenticator {
        private static final Logger logger = LoggerFactory.getLogger(KerberosAuthenticator.class);
        private static final String JAAS_CONFIG_ITEM_NAME = "CassandraJavaClient";
        private static final String[] SASL_MECHANISMS = new String[]{"GSSAPI"};
        private final Subject subject;
        private final SaslClient saslClient;

        private KerberosAuthenticator(KerberosAuthOptions options, EndPoint endPoint) {
            Objects.requireNonNull(options.getSaslProperties(), "No SASL Properties supplied, unable to perform Kerberos authentication");
            this.subject = KerberosAuthenticator.loginAsSubject();
            String serverName = options.getServerNameResolver().resolve(endPoint);
            logger.debug("Creating SaslClient for {} on Server {} with {} mechanism. SASL Protocol: {} SASL Properties: {}", new Object[]{options.getAuthorizationId(), serverName, SASL_MECHANISMS, options.getSaslProtocol(), options.getSaslProperties()});
            try {
                this.saslClient = Sasl.createSaslClient(SASL_MECHANISMS, options.getAuthorizationId(), options.getSaslProtocol(), serverName, options.getSaslProperties(), null);
            }
            catch (SaslException e) {
                throw new RuntimeException(e);
            }
        }

        private static Subject loginAsSubject() {
            logger.debug("Logging in using login configuration entry named {}", (Object)JAAS_CONFIG_ITEM_NAME);
            try {
                LoginContext loginContext = new LoginContext(JAAS_CONFIG_ITEM_NAME, cbh -> {
                    throw new RuntimeException(new LoginException(String.format("Failed to establish a login context using login configuration entry named %s Check your JAAS config file.", JAAS_CONFIG_ITEM_NAME)));
                });
                loginContext.login();
                logger.debug("Login context established");
                return loginContext.getSubject();
            }
            catch (LoginException e) {
                throw new RuntimeException("Failed to establish a login context", e);
            }
        }

        public CompletionStage<ByteBuffer> initialResponse() {
            if (this.saslClient.hasInitialResponse()) {
                try {
                    byte[] response = Subject.doAs(this.subject, () -> this.saslClient.evaluateChallenge(new byte[0]));
                    return CompletableFuture.completedFuture(ByteBuffer.wrap(response));
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(e.getException());
                }
            }
            return CompletableFuture.completedFuture(ByteBuffer.wrap(new byte[0]));
        }

        public CompletionStage<ByteBuffer> evaluateChallenge(@Nullable ByteBuffer challenge) {
            try {
                byte[] bytes = new byte[challenge.capacity()];
                challenge.get(bytes, 0, bytes.length);
                byte[] evaluation = Subject.doAs(this.subject, () -> this.saslClient.evaluateChallenge(bytes));
                return CompletableFuture.completedFuture(ByteBuffer.wrap(evaluation));
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e.getException());
            }
        }

        public CompletionStage<Void> onAuthenticationSuccess(@Nullable ByteBuffer token) {
            if (this.saslClient.isComplete()) {
                logger.debug("Authenticated with QOP: {}", this.saslClient.getNegotiatedProperty("javax.security.sasl.qop"));
            } else {
                logger.error("Cassandra reports authentication success, however SASL authentication is not yet complete.");
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    public static class KerberosAuthOptions {
        private final String authorizationId;
        private final ServerNameResolver serverNameResolver;
        private final String saslProtocol;
        private final Map<String, ?> saslProperties;

        public static Builder builder() {
            return new Builder();
        }

        private KerberosAuthOptions(String authorizationId, ServerNameResolver serverNameResolver, String saslProtocol, Map<String, ?> saslProperties) {
            this.authorizationId = authorizationId;
            this.serverNameResolver = serverNameResolver;
            this.saslProtocol = saslProtocol;
            this.saslProperties = saslProperties;
        }

        public String getAuthorizationId() {
            return this.authorizationId;
        }

        public ServerNameResolver getServerNameResolver() {
            return this.serverNameResolver;
        }

        public String getSaslProtocol() {
            return this.saslProtocol;
        }

        public Map<String, ?> getSaslProperties() {
            return this.saslProperties;
        }

        public static class Builder {
            private String authorizationId = null;
            private ServerNameResolver serverNameResolver = new ServerNameResolver(){};
            private String saslProtocol = "cassandra";
            private Map<String, ?> saslProperties = KerberosOption.DEFAULT_SASL_PROPERTIES;

            private Builder() {
            }

            public Builder withAuthorizationId(String authorizationId) {
                this.authorizationId = authorizationId;
                return this;
            }

            public Builder withSaslProtocol(String saslProtocol) {
                this.saslProtocol = saslProtocol;
                return this;
            }

            public Builder withSaslProperties(Map<String, ?> saslProperties) {
                this.saslProperties = saslProperties;
                return this;
            }

            public Builder withServerNameResolver(ServerNameResolver serverNameResolver) {
                this.serverNameResolver = serverNameResolver;
                return this;
            }

            public KerberosAuthOptions build() {
                return new KerberosAuthOptions(this.authorizationId, this.serverNameResolver, this.saslProtocol, this.saslProperties);
            }
        }
    }
}

