/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.dataengine;

import com.databricks.client.dsi.core.impl.DSIDriverSingleton;
import com.databricks.client.dsi.core.utilities.ConnSettingRequestMap;
import com.databricks.client.dsi.dataengine.utilities.ColumnMetadata;
import com.databricks.client.dsi.dataengine.utilities.ExecutionContexts;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResults;
import com.databricks.client.dsi.dataengine.utilities.ParameterMetadata;
import com.databricks.client.dsi.exceptions.BadDefaultParamException;
import com.databricks.client.dsi.exceptions.ExecutingException;
import com.databricks.client.dsi.exceptions.OperationCanceledException;
import com.databricks.client.dsi.exceptions.ParsingException;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.api.IHiveClient;
import com.databricks.client.hivecommon.core.CoreUtils;
import com.databricks.client.hivecommon.core.HiveJDBCCommonConnection;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.core.HiveJDBCStatement;
import com.databricks.client.hivecommon.dataengine.HiveJDBCNativeQueryExecutor;
import com.databricks.client.hivecommon.dataengine.HiveJDBCResultSet;
import com.databricks.client.hivecommon.querytranslation.IQueryTranslator;
import com.databricks.client.jdbc.utils.ParseQueryUtils;
import com.databricks.client.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlQueryExecutor;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HiveJDBCDSIExtQueryExecutor
extends SqlQueryExecutor {
    private static final String EXPR_COL_NAME = "EXPR_";
    ArrayList<ParameterMetadata> m_cachedParameterMetadata = new ArrayList();
    private IHiveClient m_client;
    protected HiveJDBCCommonConnection m_connection;
    private boolean m_isDirectExecuteQuery;
    private HiveJDBCNativeQueryExecutor m_nativeQueryExecutor = null;
    private ConnSettingRequestMap m_requestMap;
    private HiveJDBCStatement m_statement;
    protected HiveJDBCSettings m_settings;

    public HiveJDBCDSIExtQueryExecutor(AEStatements aEStatements, SqlDataEngineContext sqlDataEngineContext, ILogger iLogger, HiveJDBCSettings hiveJDBCSettings, IHiveClient iHiveClient, HiveJDBCStatement hiveJDBCStatement, HiveJDBCCommonConnection hiveJDBCCommonConnection, boolean bl, ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        super(aEStatements, sqlDataEngineContext, iLogger);
        LogUtilities.logFunctionEntrance(iLogger, aEStatements, sqlDataEngineContext, iLogger, hiveJDBCSettings, iHiveClient, "...");
        this.m_aeStatements = aEStatements;
        this.m_client = iHiveClient;
        this.m_statement = hiveJDBCStatement;
        this.m_connection = hiveJDBCCommonConnection;
        this.m_settings = hiveJDBCSettings;
        this.m_isDirectExecuteQuery = bl;
        this.m_requestMap = connSettingRequestMap;
    }

    @Override
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_statement.clearCancel();
        super.clearCancel();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_nativeQueryExecutor) {
            this.m_nativeQueryExecutor.close();
        }
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, OperationCanceledException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, executionContexts, iWarningListener);
        try {
            if (null == this.m_nativeQueryExecutor) {
                this.m_nativeQueryExecutor = new HiveJDBCNativeQueryExecutor(this.m_log, this.m_client, this.m_statement, this.m_connection, this.m_isDirectExecuteQuery, this.getContext());
            }
            IQueryTranslator iQueryTranslator = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getQueryTranslator();
            ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
            String string = this.translateQuery(executionContexts, iQueryTranslator, arrayList);
            List<String> list = ParseQueryUtils.splitQueries(string);
            Object object = list.iterator();
            while (object.hasNext()) {
                String string2 = object.next();
                try {
                    this.m_nativeQueryExecutor.executeQuery(string2);
                }
                catch (ErrorException errorException) {
                    HiveJDBCNativeQueryExecutor hiveJDBCNativeQueryExecutor = this.m_nativeQueryExecutor;
                    this.m_nativeQueryExecutor = null;
                    hiveJDBCNativeQueryExecutor.close();
                    throw errorException;
                }
            }
            if (null == this.m_nativeQueryExecutor.getExeContext() || this.m_nativeQueryExecutor.getExeContext().m_isExecutionComplete) {
                if (arrayList.size() > 0 && ((ExecutionResults)(object = this.m_nativeQueryExecutor.getResults())).getResults().get(0).getResult() instanceof HiveJDBCResultSet) {
                    ((HiveJDBCResultSet)((ExecutionResults)object).getResults().get(0).getResult()).consolidateResultColumnNames(arrayList);
                }
            } else {
                this.m_nativeQueryExecutor.getExeContext().m_sencolumns = arrayList;
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            if (null != this.m_nativeQueryExecutor) {
                this.m_nativeQueryExecutor.close();
                this.m_nativeQueryExecutor = null;
            }
            throw operationCanceledException;
        }
        finally {
            super.clearPushedParamData();
        }
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_nativeQueryExecutor) {
            this.m_nativeQueryExecutor.setParameterMetadataForPrepareStatement(this.m_cachedParameterMetadata);
            return this.m_nativeQueryExecutor.getMetadataForParameters();
        }
        this.m_cachedParameterMetadata = super.getMetadataForParameters();
        return this.m_cachedParameterMetadata;
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_nativeQueryExecutor) {
            return this.m_nativeQueryExecutor.getResults();
        }
        ExecutionResults executionResults = super.getResults();
        if (!this.m_settings.m_platformVersionUtils.preservesAliasCase(this.m_settings)) {
            CoreUtils.modifyColumnNameToLowerCase(executionResults);
        }
        if (this.m_settings.m_platformVersionUtils.supportsNestedDataTypes(this.m_settings.m_serverVersion) && !this.m_settings.m_platformVersionUtils.supportsComplexTypesInResults()) {
            CoreUtils.removeComplexColumns(executionResults);
        }
        return executionResults;
    }

    public String getYarnATSGuid() {
        if (null != this.m_nativeQueryExecutor) {
            return this.m_nativeQueryExecutor.getYarnATSGuid();
        }
        return null;
    }

    public List<String> getQueryLog(boolean bl, int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_nativeQueryExecutor) {
            return this.m_nativeQueryExecutor.getQueryLog(bl, n);
        }
        return Collections.emptyList();
    }

    public boolean hasMoreLogs() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_nativeQueryExecutor) {
            return this.m_nativeQueryExecutor.hasMoreLogs();
        }
        return true;
    }

    protected String translateQuery(ExecutionContexts executionContexts, IQueryTranslator iQueryTranslator, ArrayList<ColumnMetadata> arrayList) throws ErrorException {
        String string = iQueryTranslator.translate(this.m_aeStatements, executionContexts, this, this.m_connection.getSettings().m_platformVersionUtils, this.m_connection.getSettings().m_serverVersion, this.m_settings, arrayList);
        return string;
    }
}

