/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

@Deprecated
public final class CharacterTranslator {
    private static final char[] DEFAULT_MAPPING = new char[65536];
    private static final int FULL_CHAR_RANGE = 65536;
    public static final CharacterTranslator IDENTITY_TRANSLATOR;
    private final char[] mapping;

    private CharacterTranslator(char[] mapping) {
        assert (mapping.length == 65536) : "Invalid length for mapping table";
        this.mapping = mapping;
    }

    public char[] getMapping() {
        return (char[])this.mapping.clone();
    }

    public char getMapping(char toMap) {
        return this.mapping[toMap];
    }

    public static CharacterTranslator create(String mappingPath) throws SQLException {
        Properties props = new Properties();
        try {
            ResourceBundle res = ResourceBundle.getBundle(mappingPath, Locale.getDefault(), CharacterTranslator.class.getClassLoader());
            Enumeration<String> en = res.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                String value = res.getString(key);
                props.put(key, value);
            }
            char[] mapping = (char[])DEFAULT_MAPPING.clone();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                char javaChar;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.startsWith("db.")) {
                    throw new SQLNonTransientException("Incorrect mapping format. All properties should start with \"db.\", but " + key + " found.");
                }
                if (key.length() != 4) {
                    throw new SQLNonTransientException("Incorrect mapping format. Key should consist only of 4 characters, but " + key + " found.");
                }
                if (value.length() != 1) {
                    throw new SQLNonTransientException("Incorrect mapping format. Mapped value should consist only of single character, but " + value + " found.");
                }
                char dbChar = key.charAt(3);
                mapping[dbChar] = javaChar = value.charAt(0);
                mapping[javaChar] = dbChar;
            }
            return new CharacterTranslator(mapping);
        }
        catch (MissingResourceException ex) {
            throw new SQLNonTransientException("Character translation " + mappingPath + " could not be found.");
        }
    }

    static {
        for (int i = 0; i < DEFAULT_MAPPING.length; ++i) {
            CharacterTranslator.DEFAULT_MAPPING[i] = (char)i;
        }
        IDENTITY_TRANSLATOR = new CharacterTranslator(DEFAULT_MAPPING);
    }
}

