/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum StatementState {
    NEW{

        EnumSet<StatementState> createValidTransitionSet() {
            return EnumSet.of(ERROR, ALLOCATED, CLOSING, NEW);
        }
    }
    ,
    CLOSING{

        @Override
        Set<StatementState> createValidTransitionSet() {
            return EnumSet.of(CLOSED, ERROR);
        }
    }
    ,
    CLOSED{

        EnumSet<StatementState> createValidTransitionSet() {
            return EnumSet.of(CLOSED);
        }
    }
    ,
    ALLOCATED{

        EnumSet<StatementState> createValidTransitionSet() {
            return EnumSet.of(ERROR, PREPARED, CLOSING);
        }
    }
    ,
    PREPARED{

        EnumSet<StatementState> createValidTransitionSet() {
            return EnumSet.of(ERROR, EXECUTING, CLOSING, PREPARED);
        }
    }
    ,
    EXECUTING{

        EnumSet<StatementState> createValidTransitionSet() {
            return EnumSet.of(ERROR, CURSOR_OPEN, PREPARED, CLOSING);
        }
    }
    ,
    CURSOR_OPEN{

        @Override
        public boolean isCursorOpen() {
            return true;
        }

        EnumSet<StatementState> createValidTransitionSet() {
            return EnumSet.of(ERROR, PREPARED, CLOSING);
        }
    }
    ,
    ERROR{

        @Override
        public boolean isCursorOpen() {
            return true;
        }

        EnumSet<StatementState> createValidTransitionSet() {
            return EnumSet.of(ERROR, CLOSING);
        }
    };

    private Set<StatementState> validTransitions;

    public boolean isCursorOpen() {
        return false;
    }

    public final boolean isValidTransition(StatementState toState) {
        return this.validTransitionSet().contains((Object)toState);
    }

    public final Set<StatementState> validTransitionSet() {
        if (this.validTransitions == null) {
            this.validTransitions = Collections.unmodifiableSet(this.createValidTransitionSet());
        }
        return this.validTransitions;
    }

    abstract Set<StatementState> createValidTransitionSet();
}

