/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version11;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;
import org.firebirdsql.gds.ng.wire.version10.V10ParameterConverter;

public class V11ParameterConverter
extends V10ParameterConverter {
    @Override
    protected void populateDefaultProperties(WireDatabaseConnection connection, DatabaseParameterBuffer dpb) throws SQLException {
        super.populateDefaultProperties(connection, dpb);
        this.addProcessName(dpb);
        this.addProcessId(dpb);
    }

    protected final void addProcessName(DatabaseParameterBuffer dpb) {
        String processName = V11ParameterConverter.getSystemPropertyPrivileged("org.firebirdsql.jdbc.processName");
        if (processName != null) {
            dpb.addArgument(74, processName);
        }
    }

    protected final void addProcessId(DatabaseParameterBuffer dpb) {
        String pidStr = V11ParameterConverter.getSystemPropertyPrivileged("org.firebirdsql.jdbc.pid");
        if (pidStr != null) {
            try {
                int pid = Integer.parseInt(pidStr);
                dpb.addArgument(71, pid);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static String getSystemPropertyPrivileged(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
    }
}

