/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { MessageBus } from '../confirmation-bus/message-bus.js';
import type { SessionStartSource, SessionEndReason, PreCompressTrigger } from '../hooks/types.js';
/**
 * Fires the SessionStart hook.
 *
 * @param messageBus The message bus to use for hook communication
 * @param source The source/trigger of the session start
 */
export declare function fireSessionStartHook(messageBus: MessageBus, source: SessionStartSource): Promise<void>;
/**
 * Fires the SessionEnd hook.
 *
 * @param messageBus The message bus to use for hook communication
 * @param reason The reason for the session end
 */
export declare function fireSessionEndHook(messageBus: MessageBus, reason: SessionEndReason): Promise<void>;
/**
 * Fires the PreCompress hook.
 *
 * @param messageBus The message bus to use for hook communication
 * @param trigger The trigger type (manual or auto)
 */
export declare function firePreCompressHook(messageBus: MessageBus, trigger: PreCompressTrigger): Promise<void>;
