type DefaultEncodingOption = 'utf8';
type TextEncodingOption =
  | DefaultEncodingOption
  | 'utf16le';

export type BufferEncodingOption = 'buffer';
export type BinaryEncodingOption =
  | BufferEncodingOption
  | 'hex'
  | 'base64'
  | 'base64url'
  | 'latin1'
  | 'ascii';

// `options.encoding`
export type EncodingOption =
	| TextEncodingOption
	| BinaryEncodingOption
	| undefined;
