/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import ghidra.graph.job.AbstractGraphTransitionJob;
import ghidra.graph.job.RelayoutFunctionGraphJob;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class RelayoutAndEnsureVisible<V extends VisualVertex, E extends VisualEdge<V>>
extends RelayoutFunctionGraphJob<V, E> {
    private static final int VIEW_BOUNDARY_PADDING = 50;
    private V primaryVertex;
    private V secondaryVertex;
    private Distance moveDistance;
    private Distance movedSoFar = new Distance(0, 0);

    public RelayoutAndEnsureVisible(GraphViewer<V, E> viewer, V primaryVertex, V secondaryVertex, boolean useAnimation) {
        super(viewer, useAnimation);
        this.primaryVertex = primaryVertex;
        this.secondaryVertex = secondaryVertex;
    }

    @Override
    protected void initializeVertexLocations() {
        super.initializeVertexLocations();
        Shape layoutViewerShape = GraphViewerUtils.translateShapeFromViewSpaceToLayoutSpace(this.viewer.getBounds(), this.viewer);
        Rectangle layoutViewerBounds = layoutViewerShape.getBounds();
        Rectangle primaryLayoutVertexBounds = GraphViewerUtils.getVertexBoundsInLayoutSpace(this.viewer, this.primaryVertex);
        Rectangle secondaryLayoutVertexBounds = GraphViewerUtils.getVertexBoundsInLayoutSpace(this.viewer, this.secondaryVertex);
        this.setRectangleLocationToFinalDestination(primaryLayoutVertexBounds, this.primaryVertex);
        this.setRectangleLocationToFinalDestination(secondaryLayoutVertexBounds, this.secondaryVertex);
        this.padVertexBounds(primaryLayoutVertexBounds);
        this.padVertexBounds(secondaryLayoutVertexBounds);
        Distance secondaryMoveDistance = this.getMoveDistanceToContainVertexInView(layoutViewerBounds, secondaryLayoutVertexBounds);
        layoutViewerBounds.x -= secondaryMoveDistance.deltaX;
        layoutViewerBounds.y -= secondaryMoveDistance.deltaY;
        Distance primaryMoveDistance = this.getMoveDistanceToContainVertexInView(layoutViewerBounds, primaryLayoutVertexBounds);
        this.moveDistance = secondaryMoveDistance.add(primaryMoveDistance);
    }

    private Distance getMoveDistanceToContainVertexInView(Rectangle layoutViewerBounds, Rectangle layoutVertexBounds) {
        if (layoutViewerBounds.contains(layoutVertexBounds)) {
            return new Distance(0, 0);
        }
        int deltaX = 0;
        int deltaY = 0;
        int view1x = layoutViewerBounds.x;
        int view1y = layoutViewerBounds.y;
        int view2x = layoutViewerBounds.x + layoutViewerBounds.width;
        int view2y = layoutViewerBounds.y + layoutViewerBounds.height;
        int vertex1x = layoutVertexBounds.x;
        int vertex1y = layoutVertexBounds.y;
        int vertex2x = layoutVertexBounds.x + layoutVertexBounds.width;
        int vertex2y = layoutVertexBounds.y + layoutVertexBounds.height;
        if (view1x > vertex1x) {
            deltaX = -(vertex1x - view1x);
        } else if (view2x < vertex2x) {
            deltaX = -(vertex2x - view2x);
        }
        if (view1y > vertex1y) {
            deltaY = -(vertex1y - view1y);
        } else if (view2y < vertex2y) {
            deltaY = -(vertex2y - view2y);
        }
        return new Distance(deltaX, deltaY);
    }

    private void padVertexBounds(Rectangle layoutVertexBounds) {
        layoutVertexBounds.x -= 50;
        layoutVertexBounds.y -= 50;
        layoutVertexBounds.width += 100;
        layoutVertexBounds.height += 100;
    }

    private void setRectangleLocationToFinalDestination(Rectangle layoutVertexBounds, V v) {
        AbstractGraphTransitionJob.TransitionPoints transitionPoints = (AbstractGraphTransitionJob.TransitionPoints)this.vertexLocations.get(v);
        Point2D centerPoint = transitionPoints.destinationPoint;
        int upperLeftCornerX = (int)centerPoint.getX() - layoutVertexBounds.width / 2;
        int upperLeftCornerY = (int)centerPoint.getY() - layoutVertexBounds.height / 2;
        layoutVertexBounds.setLocation(upperLeftCornerX, upperLeftCornerY);
    }

    @Override
    public void setPercentComplete(double percentComplete) {
        super.setPercentComplete(percentComplete);
        Distance newMovedSoFar = this.moveDistance.scale(percentComplete);
        double deltaX = newMovedSoFar.deltaX - this.movedSoFar.deltaX;
        double deltaY = newMovedSoFar.deltaY - this.movedSoFar.deltaY;
        RenderContext renderContext = this.viewer.getRenderContext();
        MultiLayerTransformer xform = renderContext.getMultiLayerTransformer();
        xform.getTransformer(Layer.LAYOUT).translate(deltaX, deltaY);
        this.viewer.repaint();
        this.movedSoFar = newMovedSoFar;
    }

    private record Distance(int deltaX, int deltaY) {
        Distance scale(double scale) {
            return new Distance((int)((double)this.deltaX * scale), (int)((double)this.deltaY * scale));
        }

        public Distance add(Distance other) {
            return new Distance(this.deltaX + other.deltaX, this.deltaY + other.deltaY);
        }
    }
}

