/*
 * Decompiled with CFR 0.152.
 */
package utilities.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class SuppressableCallback<T> {
    private final ThreadLocal<ListWithView<T>> stack = ThreadLocal.withInitial(ListWithView::new);

    public Suppression suppress(T value) {
        return new Suppression(this, Thread.currentThread(), value);
    }

    public void invoke(Runnable callback) {
        if (this.stack.get().isEmpty()) {
            callback.run();
        }
    }

    public <R> R invoke(Supplier<R> callback, R fallback) {
        if (this.stack.get().isEmpty()) {
            return callback.get();
        }
        return fallback;
    }

    public void invokeWithTop(Consumer<T> callback) {
        ListWithView<T> s = this.stack.get();
        if (s.isEmpty()) {
            callback.accept(null);
        } else {
            callback.accept(s.get(0));
        }
    }

    public <R> R invokeWithTop(Function<T, R> callback) {
        ListWithView<T> s = this.stack.get();
        return s.isEmpty() ? callback.apply(null) : callback.apply(s.get(0));
    }

    public void invokeWithStack(Consumer<List<T>> callback) {
        callback.accept(this.stack.get().view);
    }

    public <R> R invokeWithStack(Function<List<T>, R> callback) {
        return callback.apply(this.stack.get().view);
    }

    public static class Suppression
    implements AutoCloseable {
        private final SuppressableCallback<?> cb;
        private final Thread thread;

        private <T> Suppression(SuppressableCallback<T> cb, Thread thread, T value) {
            this.cb = cb;
            this.thread = thread;
            cb.stack.get().push(value);
        }

        @Override
        public void close() {
            if (this.thread != Thread.currentThread()) {
                throw new IllegalStateException("Must close on the same thread as suppressed the callback");
            }
            this.cb.stack.get().pop();
        }
    }

    private static class ListWithView<T>
    extends LinkedList<T> {
        private final List<T> view = Collections.unmodifiableList(this);

        private ListWithView() {
        }
    }
}

