/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import java.util.Map;
import java.util.stream.Stream;

public abstract class AbstractPcodeExecutorState<A, T>
implements PcodeExecutorState<T> {
    protected final PcodeExecutorStatePiece<A, T> piece;

    public AbstractPcodeExecutorState(PcodeExecutorStatePiece<A, T> piece) {
        this.piece = piece;
    }

    @Override
    public Language getLanguage() {
        return this.piece.getLanguage();
    }

    @Override
    public PcodeArithmetic<T> getArithmetic() {
        return this.piece.getArithmetic();
    }

    @Override
    public Stream<PcodeExecutorStatePiece<?, ?>> streamPieces() {
        return this.piece.streamPieces();
    }

    protected abstract A extractAddress(T var1);

    @Override
    public T getVar(AddressSpace space, T offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        return this.piece.getVar(space, this.extractAddress(offset), size, quantize, reason);
    }

    @Override
    public T getVarInternal(AddressSpace space, T offset, int size, PcodeExecutorStatePiece.Reason reason) {
        return this.piece.getVarInternal(space, this.extractAddress(offset), size, reason);
    }

    @Override
    public T getVar(AddressSpace space, long offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        return this.piece.getVar(space, offset, size, quantize, reason);
    }

    @Override
    public T getVarInternal(AddressSpace space, long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        return this.piece.getVarInternal(space, offset, size, reason);
    }

    @Override
    public void setVar(AddressSpace space, T offset, int size, boolean quantize, T val) {
        this.piece.setVar(space, this.extractAddress(offset), size, quantize, val);
    }

    @Override
    public void setVarInternal(AddressSpace space, T offset, int size, T val) {
        this.piece.setVarInternal(space, this.extractAddress(offset), size, val);
    }

    @Override
    public void setVar(AddressSpace space, long offset, int size, boolean quantize, T val) {
        this.piece.setVar(space, offset, size, quantize, val);
    }

    @Override
    public void setVarInternal(AddressSpace space, long offset, int size, T val) {
        this.piece.setVarInternal(space, offset, size, val);
    }

    @Override
    public Map<Register, T> getRegisterValues() {
        return this.piece.getRegisterValues();
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        return this.piece.getConcreteBuffer(address, purpose);
    }

    @Override
    public void clear() {
        this.piece.clear();
    }
}

