/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.console;

import docking.widgets.table.CustomToStringCellRenderer;
import ghidra.app.plugin.core.debug.gui.console.MonitorCellRenderer;
import ghidra.debug.api.progress.MonitorReceiver;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Component;
import javax.swing.JTable;

public enum HtmlOrProgressCellRenderer implements GColumnRenderer<Object>
{
    INSTANCE;

    static final CustomToStringCellRenderer<String> FOR_STRING;
    static final MonitorCellRenderer FOR_MONITOR;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return FOR_STRING.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        if (value instanceof String) {
            String message = (String)value;
            return FOR_STRING.getTableCellRendererComponent(table, (Object)message, isSelected, hasFocus, row, column);
        }
        if (value instanceof MonitorReceiver) {
            MonitorReceiver monitor = (MonitorReceiver)value;
            return FOR_MONITOR.getTableCellRendererComponent(table, monitor, isSelected, hasFocus, row, column);
        }
        throw new AssertionError();
    }

    int getRowHeight(int colWidth) {
        return FOR_STRING.getRowHeight(colWidth);
    }

    public String getFilterString(Object t, Settings settings) {
        if (t == null) {
            return FOR_STRING.getFilterString(null, settings);
        }
        if (t instanceof String) {
            String message = (String)t;
            return FOR_STRING.getFilterString((Object)message, settings);
        }
        if (t instanceof MonitorReceiver) {
            MonitorReceiver monitor = (MonitorReceiver)t;
            return FOR_MONITOR.getFilterString(monitor, settings);
        }
        throw new AssertionError();
    }

    static {
        FOR_STRING = CustomToStringCellRenderer.HTML;
        FOR_MONITOR = MonitorCellRenderer.INSTANCE;
    }
}

