/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import ghidra.framework.ApplicationProperties;
import ghidra.framework.ApplicationVersion;
import utility.application.ApplicationUtilities;

public class ApplicationIdentifier {
    private String applicationName;
    private ApplicationVersion applicationVersion;
    private String applicationReleaseName;

    public ApplicationIdentifier(ApplicationProperties applicationProperties) throws IllegalArgumentException {
        this.applicationName = ApplicationUtilities.normalizeApplicationName(applicationProperties.getApplicationName());
        if (this.applicationName.isEmpty()) {
            throw new IllegalArgumentException("Application name is undefined.");
        }
        this.applicationVersion = new ApplicationVersion(applicationProperties.getApplicationVersion());
        this.applicationReleaseName = applicationProperties.getApplicationReleaseName().replaceAll("\\s", "").toUpperCase();
        if (this.applicationReleaseName.isEmpty()) {
            throw new IllegalArgumentException("Application release name is undefined.");
        }
    }

    public ApplicationIdentifier(String identifier) throws IllegalArgumentException {
        this.parse(identifier);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public ApplicationVersion getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getApplicationReleaseName() {
        return this.applicationReleaseName;
    }

    public String toString() {
        return this.applicationName + "_" + String.valueOf(this.applicationVersion) + "_" + this.applicationReleaseName;
    }

    public int hashCode() {
        return (this.applicationName + this.applicationReleaseName).hashCode() * this.applicationVersion.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationIdentifier other = (ApplicationIdentifier)obj;
        if (!this.applicationName.equals(other.applicationName)) {
            return false;
        }
        if (!this.applicationReleaseName.equals(other.applicationReleaseName)) {
            return false;
        }
        return this.applicationVersion.equals(other.applicationVersion);
    }

    private void parse(String identifier) throws IllegalArgumentException {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        String[] identifierParts = identifier.split("_");
        if (identifierParts.length < 3) {
            throw new IllegalArgumentException("Identifier has " + identifierParts.length + " parts but 3 are required");
        }
        this.applicationName = identifierParts[0].replaceAll("\\s", "").toLowerCase();
        this.applicationVersion = new ApplicationVersion(identifierParts[1]);
        this.applicationReleaseName = identifierParts[2].replaceAll("\\s", "").toUpperCase();
    }
}

