/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.util;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.Table;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressRecordDeleter;
import ghidra.program.database.util.RecordFilter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DatabaseTableUtils {
    public static void updateIndexedAddressField(Table table, int addrCol, AddressMap addrMap, Address fromAddr, Address toAddr, long length, RecordFilter filter, TaskMonitor monitor) throws IOException, CancelledException {
        if (length <= 0L) {
            throw new IllegalArgumentException("length must be > 0");
        }
        try {
            fromAddr.addNoWrap(length - 1L);
            toAddr.addNoWrap(length - 1L);
        }
        catch (AddressOverflowException e) {
            throw new IllegalArgumentException("Illegal range: end range overflow");
        }
        boolean startFromTop = fromAddr.compareTo(toAddr) > 0;
        AddressIndexPrimaryKeyIterator it = new AddressIndexPrimaryKeyIterator(table, addrCol, addrMap, new AddressSet(fromAddr, fromAddr.add(length - 1L)), startFromTop);
        while (startFromTop ? it.hasNext() : it.hasPrevious()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Field key = startFromTop ? it.next() : it.previous();
            DBRecord rec = table.getRecord(key);
            if (filter != null && !filter.matches(rec)) continue;
            Address addr = addrMap.decodeAddress(rec.getLongValue(addrCol));
            addr = toAddr.add(addr.subtract(fromAddr));
            rec.setLongValue(addrCol, addrMap.getKey(addr, true));
            table.putRecord(rec);
        }
    }

    public static void updateAddressKey(Table table, AddressMap addrMap, Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws IOException, CancelledException {
        Address endAddr;
        if (length <= 0L) {
            throw new IllegalArgumentException("length must be > 0");
        }
        try {
            endAddr = fromAddr.addNoWrap(length - 1L);
        }
        catch (AddressOverflowException e) {
            throw new IllegalArgumentException("Illegal range: end range overflow");
        }
        DatabaseTableUtils.updateAddressKey(table, addrMap, fromAddr, endAddr, toAddr, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAddressKey(Table table, AddressMap addrMap, Address fromAddr, Address endAddr, Address toAddr, TaskMonitor monitor) throws IOException, CancelledException {
        long length = endAddr.subtract(fromAddr);
        if (length < 0L) {
            throw new IllegalArgumentException("endAddr must be greater than fromAddr");
        }
        try {
            toAddr.addNoWrap(length);
        }
        catch (AddressOverflowException e) {
            throw new IllegalArgumentException("Illegal range: end range overflow");
        }
        try (DBHandle tmp = new DBHandle();){
            DBRecord rec;
            tmp.startTransaction();
            Table tmpTable = tmp.createTable("tmp", table.getSchema());
            AddressKeyRecordIterator it = new AddressKeyRecordIterator(table, addrMap, fromAddr, endAddr, fromAddr, true);
            while (it.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                rec = it.next();
                Address addr = addrMap.decodeAddress(rec.getKey());
                long offset = addr.subtract(fromAddr);
                addr = toAddr.add(offset);
                rec.setKey(addrMap.getKey(addr, true));
                tmpTable.putRecord(rec);
            }
            AddressRecordDeleter.deleteRecords(table, addrMap, fromAddr, endAddr);
            it = tmpTable.iterator();
            while (it.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                rec = it.next();
                table.putRecord(rec);
            }
        }
    }
}

