/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.ListLinked;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.SequenceNumber;
import java.util.Iterator;
import java.util.TreeMap;

public class PcodeOpBank {
    private TreeMap<SequenceNumber, PcodeOpAST> opTree = new TreeMap();
    private ListLinked<Object> deadList = new ListLinked();
    private ListLinked<Object> aliveList = new ListLinked();
    private int nextUnique = 0;

    public int size() {
        return this.opTree.size();
    }

    public void clear() {
        this.opTree.clear();
        this.deadList.clear();
        this.aliveList.clear();
    }

    public PcodeOp create(int opcode, int numinputs, Address pc) {
        PcodeOpAST op = new PcodeOpAST(pc, this.nextUnique, opcode, numinputs);
        ++this.nextUnique;
        this.opTree.put(op.getSeqnum(), op);
        op.setInsertIter(this.deadList.add(op));
        return op;
    }

    public PcodeOp create(int opcode, int numinputs, SequenceNumber sq) {
        PcodeOpAST op = new PcodeOpAST(sq, opcode, numinputs);
        if (sq.getTime() > this.nextUnique) {
            this.nextUnique = sq.getTime() + 1;
        }
        this.opTree.put(op.getSeqnum(), op);
        op.setInsertIter(this.deadList.add(op));
        return op;
    }

    public void destroy(PcodeOp op) {
        PcodeOpAST op_ast = (PcodeOpAST)op;
        if (!op_ast.isDead()) {
            return;
        }
        this.opTree.remove(op.getSeqnum());
        this.deadList.remove(op.getInsertIter());
    }

    public void changeOpcode(PcodeOp op, int newopc) {
        PcodeOpAST op_ast = (PcodeOpAST)op;
        op_ast.setOpcode(newopc);
    }

    public void markAlive(PcodeOp op) {
        PcodeOpAST op_ast = (PcodeOpAST)op;
        this.deadList.remove(op_ast.getInsertIter());
        op_ast.setInsertIter(this.aliveList.add(op_ast));
    }

    public void markDead(PcodeOp op) {
        PcodeOpAST op_ast = (PcodeOpAST)op;
        this.aliveList.remove(op_ast.getInsertIter());
        op_ast.setInsertIter(this.deadList.add(op_ast));
    }

    public boolean isEmpty() {
        return this.opTree.isEmpty();
    }

    public PcodeOp findOp(SequenceNumber num) {
        return this.opTree.get(num);
    }

    public Iterator<PcodeOpAST> allOrdered() {
        return this.opTree.values().iterator();
    }

    public Iterator<PcodeOpAST> allOrdered(Address pc) {
        SequenceNumber min = new SequenceNumber(pc, 0);
        SequenceNumber max = new SequenceNumber(pc, Integer.MAX_VALUE);
        return this.opTree.subMap(min, max).values().iterator();
    }

    public Iterator<Object> allAlive() {
        return this.aliveList.iterator();
    }

    public Iterator<Object> allDead() {
        return this.deadList.iterator();
    }
}

