/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.sarif;

import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.LogicalLocation;
import com.contrastsecurity.sarif.Message;
import com.contrastsecurity.sarif.PhysicalLocation;
import com.contrastsecurity.sarif.PropertyBag;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.plugin.core.decompiler.taint.AbstractTaintState;
import ghidra.app.plugin.core.decompiler.taint.TaintQueryResult;
import ghidra.app.plugin.core.decompiler.taint.TaintRule;
import ghidra.app.plugin.core.decompiler.taint.TaintService;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramTask;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import resources.Icons;
import sarif.SarifUtils;
import sarif.handlers.SarifResultHandler;
import sarif.model.SarifDataFrame;
import sarif.view.SarifResultsTableProvider;

public class SarifTaintResultHandler
extends SarifResultHandler {
    public String getKey() {
        return "Address";
    }

    public boolean isEnabled(SarifDataFrame dframe) {
        return dframe.getToolID().equals(AbstractTaintState.ENGINE_NAME);
    }

    public void handle(SarifDataFrame dframe, Run r, Result res, Map<String, Object> map) {
        Map additionalProperties;
        this.df = dframe;
        this.controller = this.df.getController();
        this.run = r;
        this.result = res;
        String ruleId = this.result.getRuleId();
        if (ruleId == null || ruleId.equals("C0001")) {
            return;
        }
        map.put("type", (Object)TaintRule.fromRuleId(ruleId));
        Message msg = this.result.getMessage();
        map.put("comment", msg.getText());
        List locs = this.result.getLocations();
        if (locs != null) {
            map.put("Locations", locs);
            this.populate(map, locs);
        }
        PropertyBag properties = this.result.getProperties();
        String label = "UNSPECIFIED";
        if (properties != null && (additionalProperties = properties.getAdditionalProperties()) != null) {
            for (Map.Entry entry : additionalProperties.entrySet()) {
                map.put((String)entry.getKey(), entry.getValue());
                if (!((String)entry.getKey()).equals("taintLabels")) continue;
                label = entry.getValue().toString();
                label = label.substring(1, label.length() - 1);
            }
        }
        map.put("value", label);
    }

    protected Object parse() {
        return null;
    }

    public String getActionName() {
        return "Apply taint";
    }

    public ProgramTask getTask(SarifResultsTableProvider prov) {
        return new ApplyTaintViaVarnodesTask(prov);
    }

    private void populate(Map<String, Object> map, List<Location> locs) {
        Long offset;
        Address addr;
        PhysicalLocation pl;
        Location loc = locs.get(0);
        Program program = this.controller.getProgram();
        LogicalLocation ll = SarifUtils.getLogicalLocation((Run)this.run, (Location)loc);
        if (ll != null) {
            String name = ll.getName();
            String fqname = ll.getFullyQualifiedName();
            String displayName = SarifUtils.extractDisplayName((LogicalLocation)ll);
            map.put("originalName", name);
            map.put("name", displayName);
            Address faddr = SarifUtils.extractFunctionEntryAddr((Program)program, (String)fqname);
            if (faddr != null && faddr.getOffset() >= 0L) {
                map.put("entry", faddr);
                map.put("Address", faddr);
            }
            map.put("location", fqname);
            map.put("kind", ll.getKind());
            map.put("function", SarifUtils.extractFQNameFunction((String)fqname));
        }
        if ((pl = loc.getPhysicalLocation()) != null && (addr = SarifUtils.getAddress((Program)program, (Long)(offset = pl.getAddress().getAbsoluteAddress()))) != null) {
            map.put("Address", addr);
        }
    }

    public DockingAction createAction(SarifResultsTableProvider prov) {
        this.provider = prov;
        this.isEnabled = this.isEnabled(this.provider.getDataFrame());
        DockingAction byVarnode = new DockingAction(this.getActionName(), this.getKey()){

            public void actionPerformed(ActionContext context) {
                ProgramTask task = SarifTaintResultHandler.this.getTask(SarifTaintResultHandler.this.provider);
                TaskLauncher.launch((Task)task);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return SarifTaintResultHandler.this.isEnabled;
            }

            public boolean isAddToPopup(ActionContext context) {
                return SarifTaintResultHandler.this.isEnabled;
            }
        };
        byVarnode.setPopupMenuData(new MenuData(new String[]{this.getActionName()}));
        this.provider.addLocalAction((DockingActionIf)byVarnode);
        DockingAction applyAll = new DockingAction("Apply all", this.getKey()){

            public void actionPerformed(ActionContext context) {
                ((SarifTaintResultHandler)SarifTaintResultHandler.this).provider.filterTable.getTable().selectAll();
                TaskLauncher.launch((Task)new ApplyTaintViaVarnodesTask(SarifTaintResultHandler.this.provider));
            }

            public boolean isEnabledForContext(ActionContext context) {
                return SarifTaintResultHandler.this.isEnabled;
            }

            public boolean isAddToPopup(ActionContext context) {
                return SarifTaintResultHandler.this.isEnabled;
            }
        };
        applyAll.setDescription("Apply all");
        applyAll.setToolBarData(new ToolBarData(Icons.EXPAND_ALL_ICON));
        this.provider.addLocalAction((DockingActionIf)applyAll);
        DockingAction clearTaint = new DockingAction("Clear taint", this.getKey()){

            public void actionPerformed(ActionContext context) {
                TaskLauncher.launch((Task)new ClearTaintTask(SarifTaintResultHandler.this.provider));
            }

            public boolean isEnabledForContext(ActionContext context) {
                return SarifTaintResultHandler.this.isEnabled;
            }

            public boolean isAddToPopup(ActionContext context) {
                return SarifTaintResultHandler.this.isEnabled;
            }
        };
        clearTaint.setPopupMenuData(new MenuData(new String[]{"Clear taint"}));
        return clearTaint;
    }

    private void removeTaintedVariable(Map<Address, Set<TaintQueryResult>> map, Map<String, Object> r) {
        Address faddr = (Address)r.get("entry");
        Set<TaintQueryResult> vset = this.getSet(map, faddr);
        vset.remove(new TaintQueryResult(r));
    }

    private void removeTaintedInstruction(Map<Address, Set<TaintQueryResult>> map, Map<String, Object> r) {
        Address faddr = (Address)r.get("entry");
        String fqname = (String)r.get("location");
        Set<TaintQueryResult> vset = this.getSet(map, faddr);
        Set edgeIds = SarifUtils.getEdgeSet((String)fqname);
        if (edgeIds != null) {
            for (String edgeId : edgeIds) {
                LogicalLocation[] dstNodes;
                LogicalLocation[] srcNodes;
                String srcId = SarifUtils.getEdgeSource((String)edgeId);
                for (LogicalLocation lloc : srcNodes = SarifUtils.getNodeLocs((String)srcId)) {
                    TaintQueryResult res = new TaintQueryResult(r, this.run, lloc);
                    vset.remove(res);
                }
                String dstId = SarifUtils.getEdgeDest((String)edgeId);
                for (LogicalLocation lloc : dstNodes = SarifUtils.getNodeLocs((String)dstId)) {
                    TaintQueryResult res = new TaintQueryResult(r, this.run, lloc);
                    vset.remove(res);
                }
            }
            map.put(faddr, vset);
        }
    }

    private Set<TaintQueryResult> getSet(Map<Address, Set<TaintQueryResult>> map, Address faddr) {
        Set<TaintQueryResult> vset = map.get(faddr);
        if (vset == null) {
            vset = new HashSet<TaintQueryResult>();
            map.put(faddr, vset);
        }
        return vset;
    }

    private class ApplyTaintViaVarnodesTask
    extends ProgramTask {
        private SarifResultsTableProvider tableProvider;
        protected TaintState.TaskType taskType;

        protected ApplyTaintViaVarnodesTask(SarifResultsTableProvider provider) {
            super(provider.getController().getProgram(), "ApplyTaintViaVarnodesTask", true, true, true);
            this.taskType = TaintState.TaskType.SET_TAINT;
            this.tableProvider = provider;
        }

        protected void doRun(TaskMonitor monitor) {
            int[] selected = this.tableProvider.filterTable.getTable().getSelectedRows();
            HashMap<Address, Set<TaintQueryResult>> map = new HashMap<Address, Set<TaintQueryResult>>();
            AddressSet set = new AddressSet();
            for (int row : selected) {
                Address addr;
                Map r = this.tableProvider.getRow(row);
                String kind = (String)r.get("kind");
                if (kind.equals("member") || kind.startsWith("path ")) {
                    this.getTaintedInstruction(map, r);
                }
                if (kind.equals("variable")) {
                    this.getTaintedVariable(map, r);
                }
                if ((addr = (Address)r.get("Address")) == null) continue;
                set.add(addr);
            }
            PluginTool tool = this.tableProvider.getController().getPlugin().getTool();
            TaintService service = (TaintService)tool.getService(TaintService.class);
            if (service != null) {
                service.setVarnodeMap(map, true, this.taskType);
                service.setAddressSet(set, false);
            }
        }

        private void getTaintedVariable(Map<Address, Set<TaintQueryResult>> map, Map<String, Object> r) {
            Address faddr = (Address)r.get("entry");
            Set<TaintQueryResult> vset = this.getSet(map, faddr);
            vset.add(new TaintQueryResult(r));
        }

        private void getTaintedInstruction(Map<Address, Set<TaintQueryResult>> map, Map<String, Object> r) {
            Address faddr = (Address)r.get("entry");
            String fqname = (String)r.get("location");
            Set<TaintQueryResult> vset = this.getSet(map, faddr);
            Set edgeIds = SarifUtils.getEdgeSet((String)fqname);
            if (edgeIds != null) {
                for (String edgeId : edgeIds) {
                    LogicalLocation[] dstNodes;
                    LogicalLocation[] srcNodes;
                    String srcId = SarifUtils.getEdgeSource((String)edgeId);
                    for (LogicalLocation lloc : srcNodes = SarifUtils.getNodeLocs((String)srcId)) {
                        vset.add(new TaintQueryResult(r, SarifTaintResultHandler.this.run, lloc));
                    }
                    String dstId = SarifUtils.getEdgeDest((String)edgeId);
                    for (LogicalLocation lloc : dstNodes = SarifUtils.getNodeLocs((String)dstId)) {
                        vset.add(new TaintQueryResult(r, SarifTaintResultHandler.this.run, lloc));
                    }
                }
            }
        }

        private Set<TaintQueryResult> getSet(Map<Address, Set<TaintQueryResult>> map, Address faddr) {
            Set<TaintQueryResult> vset = map.get(faddr);
            if (vset == null) {
                vset = new HashSet<TaintQueryResult>();
                map.put(faddr, vset);
            }
            return vset;
        }
    }

    private class ClearTaintTask
    extends ProgramTask {
        private SarifResultsTableProvider tableProvider;

        protected ClearTaintTask(SarifResultsTableProvider provider) {
            super(provider.getController().getProgram(), "ClearTaintTask", true, true, true);
            this.tableProvider = provider;
        }

        protected void doRun(TaskMonitor monitor) {
            int rowCount = this.tableProvider.filterTable.getTable().getRowCount();
            int[] selected = this.tableProvider.filterTable.getTable().getSelectedRows();
            PluginTool tool = this.tableProvider.getController().getPlugin().getTool();
            TaintService service = (TaintService)tool.getService(TaintService.class);
            if (service == null) {
                return;
            }
            if (selected.length == 0 || selected.length == rowCount) {
                service.clearTaint();
                return;
            }
            AddressSet set = service.getAddressSet();
            AddressSet setX = new AddressSet();
            for (AddressRange range : set.getAddressRanges()) {
                setX.add(range);
            }
            Map<Address, Set<TaintQueryResult>> map = service.getVarnodeMap();
            HashMap mapX = new HashMap();
            for (Map.Entry<Address, Set<TaintQueryResult>> entry : map.entrySet()) {
                HashSet entryX = new HashSet();
                entryX.addAll(entry.getValue());
                mapX.put(entry.getKey(), entryX);
            }
            for (Object row : (Object)selected) {
                Address addr;
                Map r = this.tableProvider.getRow((int)row);
                String kind = (String)r.get("kind");
                if (kind.equals("member")) {
                    SarifTaintResultHandler.this.removeTaintedInstruction(map, r);
                }
                if (kind.equals("variable")) {
                    SarifTaintResultHandler.this.removeTaintedVariable(map, r);
                }
                if ((addr = (Address)r.get("Address")) == null) continue;
                set.delete(addr, addr);
            }
            service.setVarnodeMap(map, false, TaintState.TaskType.SET_TAINT);
            service.setAddressSet(set, false);
        }
    }
}

