/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.propertylist;

import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GDLabel;
import ghidra.app.merge.propertylist.ConflictInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;

class ConflictPanel
extends JPanel {
    public static final String LATEST_BUTTON_NAME = "Latest";
    public static final String CHECKED_OUT_BUTTON_NAME = "Checked Out";
    public static final String ORIGINAL_BUTTON_NAME = "Original";
    private JRadioButton latestRB;
    private JRadioButton myRB;
    private JRadioButton originalRB;
    private static final String USE_FOR_ALL_CHECKBOX = "UseForAllConflictCheckBox";
    private JCheckBox useForAllCB;
    private ButtonGroup group;
    private JLabel propertyGroupLabel;
    private ChangeListener listener;

    ConflictPanel(ChangeListener listener) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Resolve Property Name Conflict"));
        this.create();
        this.listener = listener;
    }

    void setConflictInfo(ConflictInfo info) {
        this.propertyGroupLabel.setText("Property Group: " + info.getGroupName());
        Object origText = null;
        Object origValue = info.getOrigValue();
        if (origValue == null) {
            origText = "Value deleted (Original)";
        }
        if (info.isTypeMatch()) {
            this.setBorder(BorderFactory.createTitledBorder("Resolve Type Mismatch for Property " + info.getDisplayedPropertyName()));
            this.latestRB.setText("Use type '" + info.getLatestTypeString() + "', value = '" + String.valueOf(info.getLatestValue()) + "' (Latest)");
            this.myRB.setText("Use type '" + info.getMyTypeString() + "', value = '" + String.valueOf(info.getMyValue()) + "' (Checked Out)");
            if (origValue != null) {
                origText = "Use type '" + info.getOrigTypeString() + "', value = '" + String.valueOf(info.getOrigValue()) + "' (Original)";
            }
        } else {
            this.setBorder(BorderFactory.createTitledBorder("Resolve Property Conflict for " + info.getDisplayedPropertyName()));
            this.latestRB.setText("Use value '" + String.valueOf(info.getLatestValue()) + "' (Latest)");
            this.myRB.setText("Use value '" + String.valueOf(info.getMyValue()) + "' (Checked Out )");
            if (origValue != null) {
                origText = "Use value '" + String.valueOf(origValue) + "' (Original )";
            }
        }
        this.originalRB.setText((String)origText);
        this.resetButtons();
    }

    int getSelectedOption() {
        if (this.latestRB.isSelected()) {
            return 1;
        }
        if (this.myRB.isSelected()) {
            return 2;
        }
        if (this.originalRB.isSelected()) {
            return 3;
        }
        return -1;
    }

    private void resetButtons() {
        this.group.remove(this.latestRB);
        this.group.remove(this.myRB);
        this.group.remove(this.originalRB);
        this.latestRB.setSelected(false);
        this.myRB.setSelected(false);
        this.originalRB.setSelected(false);
        this.group.add(this.latestRB);
        this.group.add(this.myRB);
        this.group.add(this.originalRB);
        this.invalidate();
    }

    private void create() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.propertyGroupLabel = new GDLabel("Property Group:  ");
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        namePanel.add(this.propertyGroupLabel);
        this.latestRB = new GRadioButton("Use Latest");
        this.myRB = new GRadioButton("Use Checked Out");
        this.originalRB = new GRadioButton("Use Original");
        this.latestRB.setName(LATEST_BUTTON_NAME);
        this.myRB.setName(CHECKED_OUT_BUTTON_NAME);
        this.originalRB.setName(ORIGINAL_BUTTON_NAME);
        this.group = new ButtonGroup();
        this.group.add(this.latestRB);
        this.group.add(this.myRB);
        this.group.add(this.originalRB);
        JPanel rbPanel = new JPanel();
        rbPanel.setLayout(new BoxLayout(rbPanel, 1));
        rbPanel.add(this.latestRB);
        rbPanel.add(this.myRB);
        rbPanel.add(this.originalRB);
        panel.add((Component)namePanel, "North");
        panel.add((Component)rbPanel, "Center");
        panel.add((Component)this.createUseForAllCheckBox(), "South");
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ConflictPanel.this.listener != null) {
                    ConflictPanel.this.listener.stateChanged(null);
                }
            }
        };
        this.latestRB.addItemListener(itemListener);
        this.myRB.addItemListener(itemListener);
        this.originalRB.addItemListener(itemListener);
        this.add(panel);
    }

    protected JCheckBox createUseForAllCheckBox() {
        this.useForAllCB = new GCheckBox(this.getUseAllString("Property"));
        this.useForAllCB.setName(USE_FOR_ALL_CHECKBOX);
        return this.useForAllCB;
    }

    protected String getUseAllString(String conflictType) {
        return "Use the selected option for resolving all remaining '" + conflictType + "' conflicts.";
    }

    void setUseForAll(boolean useForAll) {
        this.useForAllCB.setSelected(useForAll);
    }

    boolean getUseForAll() {
        return this.useForAllCB.isSelected();
    }
}

