/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableUtils;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import docking.widgets.table.threaded.ThreadedTableModelListenerAdapter;
import ghidra.app.plugin.core.symtable.SymbolRowObject;
import ghidra.app.plugin.core.symtable.SymbolTableDnDAdapter;
import ghidra.app.plugin.core.symtable.TransientSymbolTableModel;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.table.GhidraTable;
import ghidra.util.task.TaskLauncher;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;

public class TransientSymbolTableDnDAdapter
extends SymbolTableDnDAdapter {
    private TransientSymbolTableModel model;

    public TransientSymbolTableDnDAdapter(GhidraTable table, TransientSymbolTableModel model) {
        super(table, (RowObjectTableModel<SymbolRowObject>)model);
        this.model = model;
    }

    @Override
    protected void addSymbols(List<Symbol> symbols) {
        final ArrayList<SymbolRowObject> rowObjects = new ArrayList<SymbolRowObject>();
        for (Symbol s : symbols) {
            rowObjects.add(new SymbolRowObject(s));
        }
        this.model.addInitialLoadListener((ThreadedTableModelListener)new ThreadedTableModelListenerAdapter(){

            public void loadingFinished(boolean wasCancelled) {
                TableUtils.setSelectedItems((JTable)TransientSymbolTableDnDAdapter.this.table, (List)rowObjects);
            }
        });
        TaskLauncher.launchModal((String)"Copying Symbols", () -> this.model.addSymbols(rowObjects));
    }
}

