/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import ghidra.app.plugin.core.symtable.AbstractSymbolTableModel;
import ghidra.app.plugin.core.symtable.SymbolRowObject;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListenerBuilder;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.List;

public class TransientSymbolTableModel
extends AbstractSymbolTableModel {
    private HashSet<SymbolRowObject> rowObjects;
    private SwingUpdateManager updater = new SwingUpdateManager(() -> this.fireTableDataChanged());

    public TransientSymbolTableModel(PluginTool tool, Program program, HashSet<SymbolRowObject> rowObjects) {
        super(tool);
        this.rowObjects = rowObjects;
        this.setProgram(program);
        this.symbolTable = program.getSymbolTable();
        program.addListener(((DomainObjectListenerBuilder)new DomainObjectListenerBuilder((Object)this).any(new EventType[]{DomainObjectEvent.RESTORED, ProgramEvent.MEMORY_BLOCK_ADDED, ProgramEvent.MEMORY_BLOCK_REMOVED}).terminate(this::handleRemovedSymbols)).with(ProgramChangeRecord.class).any(new EventType[]{ProgramEvent.SYMBOL_REMOVED}).call(() -> this.symbolChanged()).any(new EventType[]{ProgramEvent.CODE_ADDED, ProgramEvent.CODE_REMOVED, ProgramEvent.SYMBOL_RENAMED, ProgramEvent.SYMBOL_SCOPE_CHANGED, ProgramEvent.SYMBOL_DATA_CHANGED, ProgramEvent.SYMBOL_SOURCE_CHANGED, ProgramEvent.SYMBOL_PRIMARY_STATE_CHANGED, ProgramEvent.REFERENCE_ADDED, ProgramEvent.REFERENCE_REMOVED, ProgramEvent.EXTERNAL_ENTRY_ADDED, ProgramEvent.EXTERNAL_ENTRY_REMOVED}).call(() -> this.symbolChanged()).build());
    }

    private void handleRemovedSymbols() {
        this.updater.update();
    }

    private void symbolChanged() {
        this.updater.update();
    }

    protected void doLoad(Accumulator<SymbolRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        for (SymbolRowObject ro : this.rowObjects) {
            monitor.checkCancelled();
            accumulator.add((Object)ro);
        }
    }

    public void addSymbols(List<SymbolRowObject> symbolRowObjects) {
        for (SymbolRowObject ro : symbolRowObjects) {
            this.addObject(ro);
        }
        super.reload();
    }

    public void addObject(SymbolRowObject obj) {
        this.rowObjects.add(obj);
        super.addObject((Object)obj);
    }

    public void removeObject(SymbolRowObject obj) {
        this.rowObjects.remove(obj);
        super.removeObject((Object)obj);
    }

    protected void clearData() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.rowObjects.clear();
    }
}

