/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class RangeMappedByteProvider
implements ByteProvider {
    private ByteProvider delegate;
    private TreeMap<Long, Long> offsetMap = new TreeMap();
    private long length;
    private FSRL fsrl;

    public RangeMappedByteProvider(ByteProvider provider, FSRL fsrl) {
        this.delegate = provider;
        this.fsrl = fsrl;
    }

    public void addRange(long offset, long rangeLen) {
        if (rangeLen <= 0L) {
            throw new IllegalArgumentException();
        }
        Map.Entry<Long, Long> lastEntry = this.offsetMap.lastEntry();
        if (lastEntry != null) {
            long lastRangeOffset = lastEntry.getValue();
            if (offset == -1L && lastRangeOffset == -1L) {
                this.length += rangeLen;
                return;
            }
            long lastRangeLen = this.length - lastEntry.getKey();
            if (lastRangeOffset + lastRangeLen == offset) {
                this.length += rangeLen;
                return;
            }
        }
        this.offsetMap.put(this.length, offset);
        this.length += rangeLen;
    }

    public void addSparseRange(long rangeLen) {
        this.addRange(-1L, rangeLen);
    }

    public int getRangeCount() {
        return this.offsetMap.size();
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getName() {
        return this.fsrl != null ? this.fsrl.getName() : null;
    }

    @Override
    public FSRL getFSRL() {
        return this.fsrl;
    }

    @Override
    public String getAbsolutePath() {
        return this.fsrl != null ? this.fsrl.getPath() : null;
    }

    @Override
    public long length() throws IOException {
        return this.length;
    }

    @Override
    public boolean isValidIndex(long index) {
        return 0L <= index && index < this.length;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public byte readByte(long index) throws IOException {
        this.ensureBounds(index, 1L);
        Map.Entry<Long, Long> entry = this.offsetMap.floorEntry(index);
        long rangeStart = entry.getKey();
        long rangeOffset = index - rangeStart;
        long delegateRangeStart = entry.getValue();
        return delegateRangeStart != -1L ? this.delegate.readByte(delegateRangeStart + rangeOffset) : (byte)0;
    }

    @Override
    public byte[] readBytes(long index, long longCount) throws IOException {
        if (longCount >= Integer.MAX_VALUE) {
            throw new IOException("Unable to read " + longCount + " bytes at once");
        }
        this.ensureBounds(index, longCount);
        int count = (int)longCount;
        byte[] result = new byte[count];
        int bytesRead = this.readBytes(index, result, 0, count);
        if (bytesRead != count) {
            throw new IOException("Unable to read " + count + " bytes at " + index);
        }
        return result;
    }

    public int readBytes(long index, byte[] buffer, int offset, int len) throws IOException {
        this.ensureBounds(index, 0L);
        len = (int)Math.min(this.length - index, (long)len);
        int totalBytesRead = 0;
        int bufferDest = offset;
        long currentIndex = index;
        while (totalBytesRead < len) {
            Map.Entry<Long, Long> entry = this.offsetMap.floorEntry(currentIndex);
            Map.Entry<Long, Long> nextEntry = this.offsetMap.higherEntry(entry.getKey());
            long rangeStart = entry.getKey();
            long rangeOffset = currentIndex - rangeStart;
            long rangeEnd = nextEntry != null ? nextEntry.getKey() : this.length;
            long delegateRangeStart = entry.getValue();
            int bytesToRead = (int)Math.min((long)(len - totalBytesRead), rangeEnd - rangeStart - rangeOffset);
            if (delegateRangeStart != -1L) {
                long delegateOffsetToRead = delegateRangeStart + rangeOffset;
                byte[] rangeBytes = this.delegate.readBytes(delegateOffsetToRead, bytesToRead);
                System.arraycopy(rangeBytes, 0, buffer, bufferDest, bytesToRead);
            } else {
                Arrays.fill(buffer, bufferDest, bufferDest + bytesToRead, (byte)0);
            }
            totalBytesRead += bytesToRead;
            bufferDest += bytesToRead;
            currentIndex += (long)bytesToRead;
        }
        return totalBytesRead;
    }

    private void ensureBounds(long index, long count) throws IOException {
        if (index < 0L || index > this.length) {
            throw new IOException("Invalid index: " + index);
        }
        if (index + count > this.length) {
            throw new IOException("Unable to read past EOF: " + index + ", " + count);
        }
    }
}

