/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfRelocationTable;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.ElfSymbolTable;
import ghidra.app.util.bin.format.elf.extend.ElfLoadAdapter;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandlerFactory;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import java.util.Map;

public class ElfRelocationContext<H extends ElfRelocationHandler> {
    protected final H handler;
    protected final ElfLoadHelper loadHelper;
    protected final Map<ElfSymbol, Address> symbolMap;
    protected final Program program;
    protected ElfRelocationTable relocationTable;
    protected ElfSymbolTable symbolTable;
    private ElfSymbol nullSymbol;

    protected ElfRelocationContext(H handler, ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        this.handler = handler;
        this.loadHelper = loadHelper;
        this.symbolMap = symbolMap;
        this.program = loadHelper.getProgram();
        if (handler == null) {
            loadHelper.log("Unable to process ELF relocations: relocation handler not found");
        }
    }

    public void startRelocationTableProcessing(ElfRelocationTable relocTable) {
        this.relocationTable = relocTable;
        this.symbolTable = relocTable.getAssociatedSymbolTable();
        if (this.symbolTable == null) {
            this.nullSymbol = new ElfSymbol();
        }
    }

    public void endRelocationTableProcessing() {
        this.relocationTable = null;
    }

    public final RelocationResult processRelocation(ElfRelocation relocation, Address relocationAddress) {
        int symbolIndex = relocation.getSymbolIndex();
        ElfSymbol sym = this.getSymbol(symbolIndex);
        if (this.handler == null) {
            String symbolName = sym != null ? sym.getNameAsString() : null;
            ElfRelocationHandler.bookmarkNoHandlerError(this.program, relocationAddress, relocation.getType(), symbolIndex, symbolName);
            return RelocationResult.FAILURE;
        }
        if (sym == null) {
            ((ElfRelocationHandler)this.handler).markAsError(this.program, relocationAddress, relocation.getType(), null, -1, "Invalid symbol index (" + symbolIndex + ")", this.getLog());
            return RelocationResult.FAILURE;
        }
        if (sym.isTLS()) {
            ((ElfRelocationHandler)this.handler).markAsWarning(this.program, relocationAddress, relocation.getType(), sym.getNameAsString(), symbolIndex, "Relocation for TLS Symbol not supported", this.getLog());
            return RelocationResult.UNSUPPORTED;
        }
        try {
            return this.processRelocation(relocation, sym, relocationAddress);
        }
        catch (MemoryAccessException | NotFoundException e) {
            this.loadHelper.log(e);
            ((ElfRelocationHandler)this.handler).markAsError(this.program, relocationAddress, relocation.getType(), sym.getNameAsString(), symbolIndex, "Processing Failure - " + e.getMessage(), this.getLog());
            return RelocationResult.FAILURE;
        }
    }

    protected RelocationResult processRelocation(ElfRelocation relocation, ElfSymbol elfSymbol, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        return ((ElfRelocationHandler)this.handler).relocate(this, relocation, relocationAddress);
    }

    public final void markRelocationError(Address relocationAddress, int typeId, int symbolIndex, String symbolName, String msg) {
        if (this.handler != null) {
            ((ElfRelocationHandler)this.handler).markAsError(this.program, relocationAddress, typeId, symbolName, -1, msg, this.getLog());
        } else {
            ElfRelocationHandler.markAsError(this.program, relocationAddress, typeId, symbolIndex, symbolName, msg, this.getLog());
        }
    }

    public int getRelrRelocationType() {
        return this.handler != null ? ((ElfRelocationHandler)this.handler).getRelrRelocationType() : 0;
    }

    public static ElfRelocationContext<?> getRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        ElfHeader elf = loadHelper.getElfHeader();
        ElfRelocationContext<ElfRelocationHandler> context = null;
        ElfRelocationHandler handler = ElfRelocationHandlerFactory.getHandler(elf);
        if (handler != null) {
            context = handler.createRelocationContext(loadHelper, symbolMap);
        }
        if (context == null) {
            context = new ElfRelocationContext<ElfRelocationHandler>(handler, loadHelper, symbolMap);
        }
        return context;
    }

    public final boolean hasRelocationHandler() {
        return this.handler != null;
    }

    public long getImageBaseWordAdjustmentOffset() {
        return this.loadHelper.getImageBaseWordAdjustmentOffset();
    }

    public boolean extractAddend() {
        return !this.relocationTable.hasAddendRelocations();
    }

    public final Program getProgram() {
        return this.program;
    }

    public final boolean isBigEndian() {
        return this.program.getMemory().isBigEndian();
    }

    public final ElfHeader getElfHeader() {
        return this.loadHelper.getElfHeader();
    }

    public final ElfLoadHelper getLoadHelper() {
        return this.loadHelper;
    }

    public final ElfLoadAdapter getLoadAdapter() {
        return this.getElfHeader().getLoadAdapter();
    }

    public final MessageLog getLog() {
        return this.loadHelper.getLog();
    }

    public final ElfSymbol getSymbol(int symbolIndex) {
        if (this.symbolTable == null) {
            return symbolIndex == 0 ? this.nullSymbol : null;
        }
        return this.symbolTable.getSymbol(symbolIndex);
    }

    public final String getSymbolName(int symbolIndex) {
        return this.symbolTable != null ? this.symbolTable.getSymbolName(symbolIndex) : null;
    }

    public Address getSymbolAddress(ElfSymbol symbol) {
        return symbol != null ? this.symbolMap.get(symbol) : null;
    }

    public long getSymbolValue(ElfSymbol symbol) {
        Address symAddr = symbol != null ? this.symbolMap.get(symbol) : null;
        return symAddr != null ? symAddr.getAddressableWordOffset() : 0L;
    }

    public long getGOTValue() throws NotFoundException {
        Long gotValue = this.loadHelper.getGOTValue();
        if (gotValue == null) {
            throw new NotFoundException("Failed to identify _GLOBAL_OFFSET_TABLE_");
        }
        return gotValue;
    }

    public void dispose() {
        Listing listing = this.program.getListing();
        try {
            String extendedBlockName = "EXTERNAL.ext";
            ProgramFragment extendedFragment = listing.getFragment("Program Tree", extendedBlockName);
            if (extendedFragment != null) {
                ProgramFragment externalFragment = listing.getFragment("Program Tree", "EXTERNAL");
                if (externalFragment == null) {
                    extendedFragment.setName("EXTERNAL");
                } else {
                    externalFragment.move(extendedFragment.getMinAddress(), extendedFragment.getMaxAddress());
                    externalFragment.getParents()[0].removeChild(extendedBlockName);
                }
            }
        }
        catch (DuplicateNameException | NotEmptyException | NotFoundException e) {
            this.loadHelper.log("Failed to reconcile extended EXTERNAL block fragment");
        }
    }

    public Address getRelocationAddress(Address baseAddress, long relocOffset) {
        return baseAddress.addWrap(relocOffset);
    }
}

