/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_InstanceVariable;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ObjectiveC2_InstanceVariableList
implements StructConverter {
    public static final String NAME = "ivar_list_t";
    private ObjectiveC2_State _state;
    private long _index;
    private int entsize;
    private int count;
    private List<ObjectiveC2_InstanceVariable> ivars = new ArrayList<ObjectiveC2_InstanceVariable>();

    public ObjectiveC2_InstanceVariableList(ObjectiveC2_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        this.entsize = reader.readNextInt();
        this.count = reader.readNextInt();
        for (int i = 0; i < this.count; ++i) {
            this.ivars.add(new ObjectiveC2_InstanceVariable(state, reader));
        }
    }

    public long getEntsize() {
        return this.entsize;
    }

    public long getCount() {
        return this.count;
    }

    public List<ObjectiveC2_InstanceVariable> getIvars() {
        return this.ivars;
    }

    public long getIndex() {
        return this._index;
    }

    public static DataType toGenericDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, "entsize", null);
        struct.add(DWORD, "count", null);
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("ivar_list_t_" + this.count + "_", 0);
        struct.add(DWORD, "entsize", null);
        struct.add(DWORD, "count", null);
        for (int i = 0; i < this.ivars.size(); ++i) {
            struct.add(this.ivars.get(i).toDataType(), "var" + i, null);
        }
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }

    public void applyTo(Namespace namespace) throws Exception {
        Address address = ObjectiveC1_Utilities.toAddress(this._state.program, this.getIndex());
        try {
            ObjectiveC1_Utilities.applyData(this._state.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Namespace instanceVariableNamespace = ObjectiveC1_Utilities.createNamespace(this._state.program, "objc", NAME);
            ObjectiveC1_Utilities.createSymbol(this._state.program, instanceVariableNamespace, namespace.getName(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ObjectiveC2_InstanceVariable ivar : this.getIvars()) {
            ivar.applyTo(namespace);
        }
    }
}

