/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import ghidra.features.base.memsearch.combiner.Combiner;
import ghidra.features.base.memsearch.gui.MemoryMatchTableLoader;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.features.base.memsearch.searcher.MemorySearcher;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.ListAccumulator;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;

public class CombinedMatchTableLoader
implements MemoryMatchTableLoader {
    private MemorySearcher memSearcher;
    private List<MemoryMatch> previousResults;
    private Combiner combiner;
    private boolean completedSearch;
    private MemoryMatch firstMatch;

    public CombinedMatchTableLoader(MemorySearcher memSearcher, List<MemoryMatch> previousResults, Combiner combiner) {
        this.memSearcher = memSearcher;
        this.previousResults = previousResults;
        this.combiner = combiner;
    }

    @Override
    public void loadResults(Accumulator<MemoryMatch> accumulator, TaskMonitor monitor) {
        ListAccumulator listAccumulator = new ListAccumulator();
        this.completedSearch = this.memSearcher.findAll((Accumulator<MemoryMatch>)listAccumulator, monitor);
        List followOnResults = listAccumulator.asList();
        this.firstMatch = followOnResults.isEmpty() ? null : (MemoryMatch)followOnResults.get(0);
        Collection<MemoryMatch> results = this.combiner.combine(this.previousResults, followOnResults);
        accumulator.addAll(results);
    }

    @Override
    public boolean didTerminateEarly() {
        return !this.completedSearch;
    }

    @Override
    public void dispose() {
        this.previousResults = null;
    }

    @Override
    public MemoryMatch getFirstMatch() {
        return this.firstMatch;
    }

    @Override
    public boolean hasResults() {
        return this.firstMatch != null;
    }
}

