/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.handler;

import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.replace.SearchAndReplaceHandler;
import ghidra.features.base.replace.SearchAndReplaceQuery;
import ghidra.features.base.replace.SearchType;
import ghidra.features.base.replace.items.RenameSymbolQuickFix;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SymbolsSearchAndReplaceHandler
extends SearchAndReplaceHandler {
    public SymbolsSearchAndReplaceHandler() {
        this.addType(new SymbolSearchType(this, SymbolType.LABEL, "Labels", "Search and replace label names"));
        this.addType(new SymbolSearchType(this, SymbolType.FUNCTION, "Functions", "Search and replace function names"));
        this.addType(new SymbolSearchType(this, SymbolType.NAMESPACE, "Namespaces", "Search and replace generic namespace names"));
        this.addType(new SymbolSearchType(this, SymbolType.CLASS, "Classes", "Search and replace class names"));
        this.addType(new SymbolSearchType(this, SymbolType.LOCAL_VAR, "Local Variables", "Search and replace local variable names"));
        this.addType(new SymbolSearchType(this, SymbolType.PARAMETER, "Parameters", "Search and replace parameter names"));
    }

    @Override
    public void findAll(Program program, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator, TaskMonitor monitor) throws CancelledException {
        SymbolTable symbolTable = program.getSymbolTable();
        int symbolCount = symbolTable.getNumSymbols();
        monitor.initialize((long)symbolCount, "Searching Labels...");
        Pattern pattern = query.getSearchPattern();
        Set<SymbolType> selectedSymbolTypes = this.getSelectedSymbolTypes(query);
        for (Symbol symbol : symbolTable.getDefinedSymbols()) {
            Matcher matcher;
            Function function;
            SymbolType symbolType;
            monitor.increment();
            if (symbol.isExternal() || !selectedSymbolTypes.contains(symbolType = symbol.getSymbolType()) || symbolType == SymbolType.FUNCTION && (function = (Function)symbol.getObject()).isThunk() || !(matcher = pattern.matcher(symbol.getName())).find()) continue;
            String newName = matcher.replaceAll(query.getReplacementText());
            RenameSymbolQuickFix item = new RenameSymbolQuickFix(symbol, newName);
            accumulator.add((Object)item);
        }
    }

    private Set<SymbolType> getSelectedSymbolTypes(SearchAndReplaceQuery query) {
        HashSet<SymbolType> symbolTypes = new HashSet<SymbolType>();
        Set<SearchType> selectedSearchTypes = query.getSelectedSearchTypes();
        for (SearchType searchType : selectedSearchTypes) {
            if (!(searchType instanceof SymbolSearchType)) continue;
            SymbolSearchType symbolSearchType = (SymbolSearchType)searchType;
            symbolTypes.add(symbolSearchType.getSymbolType());
        }
        return symbolTypes;
    }

    private class SymbolSearchType
    extends SearchType {
        private final SymbolType symbolType;

        SymbolSearchType(SymbolsSearchAndReplaceHandler symbolsSearchAndReplaceHandler, SymbolType symbolType, String name, String description) {
            super(symbolsSearchAndReplaceHandler, name, description);
            this.symbolType = symbolType;
        }

        SymbolType getSymbolType() {
            return this.symbolType;
        }
    }
}

