/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.datatype.modifier;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;

public class MDManagedProperties
extends MDParsableItem {
    boolean isPointer;
    boolean isReference;
    boolean isGC;
    boolean isPin;
    boolean isC;
    String special;
    boolean isCLI;
    boolean isCliArray;
    int arrayRank;

    public MDManagedProperties(MDMang dmang, boolean isPointer, boolean isReference) {
        super(dmang);
        this.isPointer = isPointer;
        this.isReference = isReference;
    }

    public boolean isGC() {
        return this.isGC;
    }

    public boolean isPin() {
        return this.isPin;
    }

    public boolean isC() {
        return this.isC;
    }

    public String getSpecial() {
        return this.special;
    }

    @Override
    protected void parseInternal() throws MDException {
        char ch = this.dmang.peek();
        this.special = "";
        if (ch == '$') {
            this.dmang.increment();
            ch = this.dmang.getAndIncrement();
            switch (ch) {
                case 'A': {
                    this.special = "^";
                    this.isGC = true;
                    this.isCLI = true;
                    break;
                }
                case 'B': {
                    this.special = "*";
                    this.isPin = true;
                    this.isCLI = true;
                    break;
                }
                case 'C': {
                    this.special = "%";
                    this.isC = true;
                    this.isCLI = true;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.special = "^";
                    if (ch >= '0' && ch <= '9') {
                        this.arrayRank = ch - 48;
                    } else if (ch >= 'A' && ch <= 'F') {
                        this.arrayRank = ch - 65 + 10;
                    } else {
                        throw new MDException("invalid cli:array rank");
                    }
                    ch = this.dmang.getAndIncrement();
                    if (ch >= '0' && ch <= '9') {
                        this.arrayRank = this.arrayRank * 16 + ch - 48;
                    } else if (ch >= 'A' && ch <= 'F') {
                        this.arrayRank = this.arrayRank * 16 + ch - 65 + 10;
                    } else {
                        throw new MDException("invalid cli:array rank");
                    }
                    this.dmang.increment();
                    this.isCliArray = true;
                    this.isCLI = true;
                }
            }
        }
    }

    public String emit(String typeName) {
        if ("*".equals(typeName)) {
            if (this.isGC) {
                typeName = "^";
            } else if (this.isC) {
                typeName = "%";
            }
        } else if ("&".equals(typeName)) {
            if (this.isGC) {
                typeName = "%";
            } else if (this.isC) {
                typeName = "%";
            }
        } else if (this.isC && (this.isPointer || this.isReference)) {
            typeName = (String)typeName + "%";
        }
        return typeName;
    }
}

