/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.feature.fid.service.FidMatch;
import ghidra.feature.fid.service.NameVersions;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class MatchNameAnalysis {
    private Set<String> finalNameList = null;
    private TreeMap<String, NameVersions> versionMap = null;
    private TreeSet<String> rawNames = null;
    private TreeSet<String> similarBaseNames = null;
    private TreeSet<String> demangledNameNoTemplate = null;
    private TreeSet<String> exactDemangledBaseNames = null;
    private TreeSet<String> libraries = null;
    private float overallScore = 0.0f;

    public int numNames() {
        return this.finalNameList.size();
    }

    public Iterator<String> getRawNameIterator() {
        return this.rawNames.iterator();
    }

    public boolean containsRawName(String name) {
        return this.rawNames.contains(name);
    }

    public Iterator<String> getNameIterator() {
        return this.finalNameList.iterator();
    }

    public int numLibraries() {
        return this.libraries.size();
    }

    public Iterator<String> getLibraryIterator() {
        return this.libraries.iterator();
    }

    public NameVersions getVersions(String raw) {
        return this.versionMap.get(raw);
    }

    public int getMostOptimisticCount() {
        int count = this.rawNames.size();
        if (this.similarBaseNames.size() < count) {
            count = this.similarBaseNames.size();
        }
        if (this.demangledNameNoTemplate != null && this.demangledNameNoTemplate.size() < count) {
            count = this.demangledNameNoTemplate.size();
        }
        if (this.exactDemangledBaseNames != null && this.exactDemangledBaseNames.size() < count) {
            count = this.exactDemangledBaseNames.size();
        }
        return count;
    }

    public String getMostOptimisticName() {
        if (this.rawNames.size() == 1) {
            return this.rawNames.first();
        }
        if (this.similarBaseNames.size() == 1) {
            return this.similarBaseNames.first();
        }
        if (this.demangledNameNoTemplate != null && this.demangledNameNoTemplate.size() == 1) {
            return this.demangledNameNoTemplate.first();
        }
        if (this.exactDemangledBaseNames != null && this.exactDemangledBaseNames.size() == 1) {
            return this.exactDemangledBaseNames.first();
        }
        return null;
    }

    public float getOverallScore() {
        return this.overallScore;
    }

    public void analyzeNames(List<FidMatch> matches, Program program, TaskMonitor monitor) throws CancelledException {
        this.versionMap = new TreeMap();
        this.rawNames = new TreeSet();
        this.similarBaseNames = new TreeSet();
        this.demangledNameNoTemplate = new TreeSet();
        this.exactDemangledBaseNames = new TreeSet();
        for (FidMatch match : matches) {
            monitor.checkCancelled();
            FunctionRecord function = match.getFunctionRecord();
            NameVersions nameVersions = NameVersions.generate(function.getName(), program);
            if (nameVersions.rawName == null) continue;
            this.versionMap.put(nameVersions.rawName, nameVersions);
            this.rawNames.add(nameVersions.rawName);
            this.similarBaseNames.add(nameVersions.similarName);
            if (nameVersions.demangledNoTemplate != null && this.demangledNameNoTemplate != null) {
                this.demangledNameNoTemplate.add(nameVersions.demangledNoTemplate);
            } else {
                this.demangledNameNoTemplate = null;
            }
            if (nameVersions.demangledBaseName != null && this.exactDemangledBaseNames != null) {
                this.exactDemangledBaseNames.add(nameVersions.demangledBaseName);
                continue;
            }
            this.exactDemangledBaseNames = null;
        }
        this.finalNameList = this.rawNames;
        String singleName = this.findCommonBaseName();
        if (singleName != null) {
            this.finalNameList = Collections.singleton(singleName);
        } else if (this.rawNames.size() > this.similarBaseNames.size()) {
            this.finalNameList = this.similarBaseNames;
        }
        if (matches.size() > 0) {
            this.overallScore = matches.get(0).getOverallScore();
        }
    }

    public void analyzeLibraries(Collection<FidMatch> matches, int libraryLimit, TaskMonitor monitor) throws CancelledException {
        Object familyVersion;
        LibraryRecord libraryRecord;
        this.libraries = new TreeSet();
        for (FidMatch match : matches) {
            String library = match.getLibraryRecord().toString();
            if (library != null) {
                this.libraries.add(library);
            }
            if (this.libraries.size() < libraryLimit) continue;
            break;
        }
        if (this.libraries.size() >= libraryLimit) {
            this.libraries.clear();
            for (FidMatch match : matches) {
                monitor.checkCancelled();
                libraryRecord = match.getLibraryRecord();
                familyVersion = libraryRecord.getLibraryFamilyName() + " " + libraryRecord.getLibraryVersion();
                this.libraries.add((String)familyVersion);
                if (this.libraries.size() < libraryLimit) continue;
                break;
            }
        }
        if (this.libraries.size() >= libraryLimit) {
            this.libraries.clear();
            for (FidMatch match : matches) {
                monitor.checkCancelled();
                libraryRecord = match.getLibraryRecord();
                familyVersion = libraryRecord.getLibraryFamilyName();
                this.libraries.add((String)familyVersion);
            }
        }
    }

    private String findCommonBaseName() {
        if (this.rawNames.size() == 1 || this.similarBaseNames.size() == 1) {
            return this.rawNames.first();
        }
        return null;
    }
}

