/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.data.ContentHandler;
import ghidra.framework.model.ToolTemplate;

public class ToolAssociationInfo {
    private ToolTemplate currentTemplate;
    private final ContentHandler contentHandler;
    private String associatedToolName;
    private final ToolTemplate defaultTemplate;

    public ToolAssociationInfo(ContentHandler contentHandler, String associatedToolName, ToolTemplate currentToolTemplate, ToolTemplate defaultTemplate) {
        this.contentHandler = contentHandler;
        this.currentTemplate = currentToolTemplate;
        this.associatedToolName = associatedToolName;
        this.defaultTemplate = defaultTemplate;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public ToolTemplate getCurrentTemplate() {
        return this.currentTemplate;
    }

    public ToolTemplate getDefaultTemplate() {
        return this.defaultTemplate;
    }

    public String getAssociatedToolName() {
        return this.associatedToolName;
    }

    public boolean isDefault() {
        if (this.associatedToolName == null) {
            return true;
        }
        return this.associatedToolName.equals(this.contentHandler.getDefaultToolName());
    }

    public void setCurrentTool(ToolTemplate toolTemplate) {
        this.currentTemplate = toolTemplate;
        this.associatedToolName = toolTemplate.getName();
    }

    public void restoreDefaultAssociation() {
        this.currentTemplate = this.defaultTemplate;
        this.associatedToolName = this.contentHandler.getDefaultToolName();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[\n\tContent Type: " + this.contentHandler.getContentType() + ",\n\tDefault Tool: " + this.contentHandler.getDefaultToolName() + ",\n\tCurrent Tool: " + String.valueOf(this.currentTemplate) + "\n]";
    }
}

