/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.util;

import ghidra.app.cmd.label.RenameLabelCmd;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.NoisyStructureBuilder;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FillOutStructureHelper {
    private static final String DEFAULT_BASENAME = "astruct";
    private static final String DEFAULT_CATEGORY = "/auto_structs";
    private Program currentProgram;
    private TaskMonitor monitor;
    private static final int maxCallDepth = 1;
    private int currentCallDepth;
    private NoisyStructureBuilder componentMap = new NoisyStructureBuilder();
    private HashMap<Address, Address> addressToCallInputMap = new HashMap();
    private List<OffsetPcodeOpPair> storePcodeOps = new ArrayList<OffsetPcodeOpPair>();
    private List<OffsetPcodeOpPair> loadPcodeOps = new ArrayList<OffsetPcodeOpPair>();

    public FillOutStructureHelper(Program program, TaskMonitor monitor) {
        this.currentProgram = program;
        this.monitor = monitor;
    }

    public Structure processStructure(HighVariable var, Function function, boolean createNewStructure, boolean createClassIfNeeded, DecompInterface decomplib) {
        long size;
        if (var == null) {
            return null;
        }
        this.init();
        Structure structDT = null;
        if (!createNewStructure && (structDT = FillOutStructureHelper.getStructureForExtending(var.getDataType())) != null) {
            this.componentMap.populateOriginalStructure(structDT);
        }
        this.fillOutStructureDef(var);
        if (decomplib != null) {
            this.pushIntoCalls(decomplib);
        }
        if ((size = this.componentMap.getSize()) == 0L) {
            return null;
        }
        if (size < 0L || size > Integer.MAX_VALUE) {
            Msg.error((Object)this, (Object)("Computed structure length out-of-range: " + size));
            return null;
        }
        if (structDT == null) {
            structDT = createClassIfNeeded && DecompilerUtils.isThisParameter(var, function) ? this.createUniqueClassNamespaceAndStructure(var, (int)size, function) : this.createUniqueStructure((int)size);
        } else {
            this.expandStructureSizeIfNeeded(structDT, (int)size);
        }
        this.populateStructure(structDT);
        return structDT;
    }

    private void expandStructureSizeIfNeeded(Structure struct, int size) {
        int len;
        int n = len = struct.isZeroLength() ? 0 : struct.getLength();
        if (size > len) {
            struct.growStructure(size - len);
        }
    }

    private void init() {
        this.currentCallDepth = 0;
        this.componentMap = new NoisyStructureBuilder();
        this.addressToCallInputMap = new HashMap();
        this.storePcodeOps = new ArrayList<OffsetPcodeOpPair>();
        this.loadPcodeOps = new ArrayList<OffsetPcodeOpPair>();
    }

    public NoisyStructureBuilder getComponentMap() {
        return this.componentMap;
    }

    public List<OffsetPcodeOpPair> getStorePcodeOps() {
        return this.storePcodeOps;
    }

    public List<OffsetPcodeOpPair> getLoadPcodeOps() {
        return this.loadPcodeOps;
    }

    private Address computeParamAddress(Varnode[] inputs, int slot) {
        Address funcAddr = inputs[0].getAddress();
        Function function = this.currentProgram.getFunctionManager().getFunctionAt(funcAddr);
        if (function == null) {
            return null;
        }
        Parameter[] parameters = function.getParameters();
        if (slot - 1 < parameters.length) {
            return parameters[slot - 1].getMinAddress();
        }
        PrototypeModel model = function.getCallingConvention();
        if (model == null && (model = this.currentProgram.getCompilerSpec().getDefaultCallingConvention()) == null) {
            return null;
        }
        DataType[] typeList = new DataType[slot + 1];
        typeList[0] = DataType.DEFAULT;
        for (int i = 1; i < slot + 1; ++i) {
            typeList[i] = inputs[i].getHigh().getDataType();
        }
        VariableStorage[] storageLocations = model.getStorageLocations(this.currentProgram, typeList, false);
        return storageLocations[slot].getMinAddress();
    }

    private void pushIntoCalls(DecompInterface decomplib) {
        AddressSet doneSet = new AddressSet();
        while (this.addressToCallInputMap.size() > 0) {
            ++this.currentCallDepth;
            if (this.currentCallDepth > 1) {
                return;
            }
            HashMap<Address, Address> savedList = this.addressToCallInputMap;
            this.addressToCallInputMap = new HashMap();
            Set<Address> keys = savedList.keySet();
            for (Address addr : keys) {
                if (doneSet.contains(addr)) continue;
                doneSet.addRange(addr, addr);
                Function func = this.currentProgram.getFunctionManager().getFunctionAt(addr);
                Address storageAddr = savedList.get(addr);
                HighVariable paramHighVar = this.computeHighVariable(storageAddr, func, decomplib);
                if (paramHighVar == null) continue;
                this.fillOutStructureDef(paramHighVar);
            }
        }
    }

    public HighVariable computeHighVariable(Address storageAddress, Function function, DecompInterface decomplib) {
        if (storageAddress == null) {
            return null;
        }
        HighVariable highVar = null;
        DecompileResults results = decomplib.decompileFunction(function, decomplib.getOptions().getDefaultTimeout(), this.monitor);
        if (this.monitor.isCancelled()) {
            return null;
        }
        HighFunction highFunc = results.getHighFunction();
        if (highFunc == null) {
            return null;
        }
        HighSymbol sym = highFunc.getMappedSymbol(storageAddress, function.getEntryPoint().subtractWrap(1L));
        if (sym == null) {
            sym = highFunc.getMappedSymbol(storageAddress, null);
        }
        if (sym == null) {
            sym = highFunc.getMappedSymbol(storageAddress, function.getEntryPoint());
        }
        if (sym == null) {
            sym = highFunc.getLocalSymbolMap().findLocal(storageAddress, function.getEntryPoint().subtractWrap(1L));
        }
        if (sym == null) {
            sym = highFunc.getLocalSymbolMap().findLocal(storageAddress, null);
        }
        if (sym == null) {
            sym = highFunc.getLocalSymbolMap().findLocal(storageAddress, function.getEntryPoint());
        }
        if (sym == null) {
            return null;
        }
        highVar = sym.getHighVariable();
        return highVar;
    }

    public DecompInterface setUpDecompiler(DecompileOptions options) {
        DecompInterface decomplib = new DecompInterface();
        decomplib.setOptions(options);
        decomplib.toggleCCode(true);
        decomplib.toggleSyntaxTree(true);
        decomplib.setSimplificationStyle("decompile");
        if (!decomplib.openProgram(this.currentProgram)) {
            return null;
        }
        return decomplib;
    }

    private void populateStructure(Structure structDT) {
        for (Map.Entry entry : this.componentMap) {
            Long key = (Long)entry.getKey();
            DataType valDT = (DataType)entry.getValue();
            if (key.intValue() < 0 || structDT.getLength() < key.intValue() + valDT.getLength()) continue;
            try {
                DataTypeComponent existing = structDT.getComponentAt(key.intValue());
                String name = null;
                String comment = null;
                if (existing != null) {
                    name = existing.getFieldName();
                    comment = existing.getComment();
                }
                structDT.replaceAtOffset(key.intValue(), valDT, valDT.getLength(), name, comment);
            }
            catch (IllegalArgumentException e) {
                Msg.debug((Object)this, (Object)"Unexpected error changing structure offset", (Throwable)e);
            }
        }
    }

    private Structure createUniqueStructure(int size) {
        ProgramBasedDataTypeManager dtm = this.currentProgram.getDataTypeManager();
        String structName = dtm.getUniqueName(new CategoryPath(DEFAULT_CATEGORY), DEFAULT_BASENAME);
        StructureDataType dt = new StructureDataType(new CategoryPath(DEFAULT_CATEGORY), structName, size, (DataTypeManager)dtm);
        return dt;
    }

    private Structure createUniqueClassNamespaceAndStructure(HighVariable var, int size, Function f) {
        Namespace newNamespace = this.createUniqueClassName();
        if (newNamespace == null) {
            return null;
        }
        RenameLabelCmd command = new RenameLabelCmd(f.getSymbol(), f.getName(), newNamespace, SourceType.USER_DEFINED);
        if (!command.applyTo(this.currentProgram)) {
            return null;
        }
        Structure structDT = VariableUtilities.findOrCreateClassStruct((Function)f);
        if (structDT == null) {
            return null;
        }
        this.expandStructureSizeIfNeeded(structDT, size);
        return structDT;
    }

    private boolean programContainsNamedStructure(String structName) {
        ProgramBasedDataTypeManager dtm = this.currentProgram.getDataTypeManager();
        ArrayList list = new ArrayList();
        dtm.findDataTypes(structName, list, true, this.monitor);
        for (DataType dt : list) {
            if (!(dt instanceof Structure)) continue;
            return true;
        }
        return false;
    }

    private Namespace createUniqueClassName() {
        String newClassName;
        Namespace rootNamespace = this.currentProgram.getGlobalNamespace();
        SymbolTable symbolTable = this.currentProgram.getSymbolTable();
        String newClassBase = "AutoClass";
        int index = 1;
        while (symbolTable.getNamespace(newClassName = newClassBase + Integer.toString(index++), rootNamespace) != null || this.programContainsNamedStructure(newClassName)) {
        }
        try {
            return symbolTable.createClass(rootNamespace, newClassName, SourceType.USER_DEFINED);
        }
        catch (DuplicateNameException | InvalidInputException e) {
            Msg.error((Object)this, (Object)("Error creating class '" + newClassName + "'"), (Throwable)e);
            return null;
        }
    }

    private boolean sanityCheck(long offset, long existingSize) {
        if (offset < 0L) {
            return false;
        }
        if (offset < existingSize) {
            return true;
        }
        return offset <= 4096L;
    }

    private void fillOutStructureDef(HighVariable var) {
        Varnode[] instances;
        Varnode startVN = var.getRepresentative();
        ArrayList<PointerRef> todoList = new ArrayList<PointerRef>();
        HashSet<Varnode> doneList = new HashSet<Varnode>();
        todoList.add(new PointerRef(startVN, 0L));
        for (Varnode vn : instances = var.getInstances()) {
            doneList.add(vn);
            if (vn == startVN) continue;
            todoList.add(new PointerRef(vn, 0L));
        }
        while (!todoList.isEmpty()) {
            PointerRef currentRef = (PointerRef)todoList.remove(0);
            if (currentRef.varnode == null) continue;
            Iterator descendants = currentRef.varnode.getDescendants();
            block15: while (descendants.hasNext()) {
                PcodeOp pcodeOp = (PcodeOp)descendants.next();
                Varnode output = pcodeOp.getOutput();
                Varnode[] inputs = pcodeOp.getInputs();
                switch (pcodeOp.getOpcode()) {
                    case 19: 
                    case 20: {
                        if (!inputs[1].isConstant()) break;
                        long value = this.getSigned(inputs[1]);
                        long newOff = currentRef.offset + (pcodeOp.getOpcode() == 19 ? value : -value);
                        if (!this.sanityCheck(newOff, this.componentMap.getSize())) break;
                        this.putOnList(output, newOff, todoList, doneList);
                        this.componentMap.setMinimumSize(newOff);
                        break;
                    }
                    case 65: {
                        long newOff;
                        if (!inputs[1].isConstant() || !inputs[2].isConstant() || !this.sanityCheck(newOff = currentRef.offset + this.getSigned(inputs[1]) * inputs[2].getOffset(), this.componentMap.getSize())) break;
                        this.putOnList(output, newOff, todoList, doneList);
                        this.componentMap.setMinimumSize(newOff);
                        break;
                    }
                    case 66: {
                        long subOff;
                        if (!inputs[1].isConstant() || !this.sanityCheck(subOff = currentRef.offset + this.getSigned(inputs[1]), this.componentMap.getSize())) break;
                        this.putOnList(output, subOff, todoList, doneList);
                        this.componentMap.setMinimumSize(subOff);
                        break;
                    }
                    case 67: {
                        this.putOnList(output, currentRef.offset, todoList, doneList);
                        this.componentMap.setMinimumSize(currentRef.offset);
                        break;
                    }
                    case 2: {
                        DataType outDt = DecompilerUtils.getDataTypeTraceForward(output);
                        this.componentMap.addDataType(currentRef.offset, outDt);
                        if (outDt == null) break;
                        this.loadPcodeOps.add(new OffsetPcodeOpPair(currentRef.offset, pcodeOp));
                        break;
                    }
                    case 3: {
                        if (pcodeOp.getSlot(currentRef.varnode) != 1) break;
                        DataType outDt = DecompilerUtils.getDataTypeTraceBackward(inputs[2]);
                        this.componentMap.addDataType(currentRef.offset, outDt);
                        if (outDt == null) break;
                        this.storePcodeOps.add(new OffsetPcodeOpPair(currentRef.offset, pcodeOp));
                        break;
                    }
                    case 64: {
                        this.putOnList(output, currentRef.offset, todoList, doneList);
                        break;
                    }
                    case 60: {
                        this.putOnList(output, currentRef.offset, todoList, doneList);
                        break;
                    }
                    case 1: {
                        this.putOnList(output, currentRef.offset, todoList, doneList);
                        break;
                    }
                    case 7: {
                        if (currentRef.offset == 0L) {
                            Address storageAddr;
                            int slot = pcodeOp.getSlot(currentRef.varnode);
                            if (slot <= 0 || slot >= pcodeOp.getNumInputs() || (storageAddr = this.computeParamAddress(inputs, slot)) == null) continue block15;
                            this.addressToCallInputMap.put(inputs[0].getAddress(), storageAddr);
                            break;
                        }
                        DataType outDt = DecompilerUtils.getDataTypeTraceBackward(currentRef.varnode);
                        this.componentMap.addReference(currentRef.offset, outDt);
                        break;
                    }
                    case 8: {
                        DataType outDt = DecompilerUtils.getDataTypeTraceBackward(currentRef.varnode);
                        this.componentMap.addReference(currentRef.offset, outDt);
                    }
                }
            }
        }
    }

    private long getSigned(Varnode varnode) {
        long mask = 128L << (varnode.getSize() - 1) * 8;
        long value = varnode.getOffset();
        if ((value & mask) != 0L) {
            value |= -1L << (varnode.getSize() - 1) * 8;
        }
        return value;
    }

    private void putOnList(Varnode output, long offset, ArrayList<PointerRef> todoList, HashSet<Varnode> doneList) {
        if (doneList.contains(output)) {
            return;
        }
        todoList.add(new PointerRef(output, offset));
        doneList.add(output);
    }

    public static Structure getStructureForExtending(DataType dt) {
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (!(dt instanceof Pointer)) {
            return null;
        }
        dt = ((Pointer)dt).getDataType();
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (dt instanceof Structure) {
            return (Structure)dt;
        }
        return null;
    }

    private static class PointerRef {
        Varnode varnode;
        long offset;

        public PointerRef(Varnode ref, long off) {
            this.varnode = ref;
            this.offset = off;
        }
    }

    public static class OffsetPcodeOpPair {
        private Long offset;
        private PcodeOp pcodeOp;

        public OffsetPcodeOpPair(Long offset, PcodeOp pcodeOp) {
            this.offset = offset;
            this.pcodeOp = pcodeOp;
        }

        public Long getOffset() {
            return this.offset;
        }

        public PcodeOp getPcodeOp() {
            return this.pcodeOp;
        }
    }
}

