/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import ghidra.pcode.exec.ConcretionError;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Endian;
import ghidra.trace.model.memory.TraceMemoryState;
import java.math.BigInteger;

public enum TraceMemoryStatePcodeArithmetic implements PcodeArithmetic<TraceMemoryState>
{
    INSTANCE;


    public Class<TraceMemoryState> getDomain() {
        return TraceMemoryState.class;
    }

    public Endian getEndian() {
        return null;
    }

    public TraceMemoryState unaryOp(int opcode, int sizeout, int sizein1, TraceMemoryState in1) {
        return in1;
    }

    public TraceMemoryState binaryOp(int opcode, int sizeout, int sizein1, TraceMemoryState in1, int sizein2, TraceMemoryState in2) {
        if (in1 == TraceMemoryState.KNOWN && in2 == TraceMemoryState.KNOWN) {
            return TraceMemoryState.KNOWN;
        }
        return TraceMemoryState.UNKNOWN;
    }

    public TraceMemoryState modBeforeStore(int sizeinOffset, AddressSpace space, TraceMemoryState inOffset, int sizeinValue, TraceMemoryState inValue) {
        return inValue;
    }

    public TraceMemoryState modAfterLoad(int sizeinOffset, AddressSpace space, TraceMemoryState inOffset, int sizeinValue, TraceMemoryState inValue) {
        if (inOffset == TraceMemoryState.KNOWN && inValue == TraceMemoryState.KNOWN) {
            return TraceMemoryState.KNOWN;
        }
        return TraceMemoryState.UNKNOWN;
    }

    public TraceMemoryState fromConst(byte[] value) {
        return TraceMemoryState.KNOWN;
    }

    public TraceMemoryState fromConst(BigInteger value, int size, boolean isContextreg) {
        return TraceMemoryState.KNOWN;
    }

    public TraceMemoryState fromConst(long value, int size) {
        return TraceMemoryState.KNOWN;
    }

    public byte[] toConcrete(TraceMemoryState value, PcodeArithmetic.Purpose purpose) {
        throw new ConcretionError("Cannot make TraceMemoryState concrete", purpose);
    }

    public long sizeOf(TraceMemoryState value) {
        throw new AssertionError((Object)"Cannot get size of a TraceMemoryState");
    }
}

