/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.util.NumericUtilities;
import ghidra.util.database.spatial.rect.EuclideanSpace2D;
import java.util.HashMap;
import java.util.Map;
import utilities.util.IDHashed;

public class TraceAddressSnapSpace
implements EuclideanSpace2D<Address, Long> {
    private static final Map<IDHashed<AddressSpace>, TraceAddressSnapSpace> SPACES = new HashMap<IDHashed<AddressSpace>, TraceAddressSnapSpace>();
    private ImmutableTraceAddressSnapRange full;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TraceAddressSnapSpace forAddressSpace(AddressSpace space) {
        Map<IDHashed<AddressSpace>, TraceAddressSnapSpace> map = SPACES;
        synchronized (map) {
            return SPACES.computeIfAbsent((IDHashed<AddressSpace>)new IDHashed((Object)space), s -> new TraceAddressSnapSpace(space));
        }
    }

    private TraceAddressSnapSpace(AddressSpace space) {
        this.full = new ImmutableTraceAddressSnapRange(space.getMinAddress(), space.getMaxAddress(), Long.MIN_VALUE, Long.MAX_VALUE, this);
    }

    public int compareX(Address x1, Address x2) {
        return x1.compareTo((Object)x2);
    }

    public int compareY(Long y1, Long y2) {
        return y1.compareTo(y2);
    }

    public double distX(Address x1, Address x2) {
        if (x2.compareTo((Object)x1) > 0) {
            return NumericUtilities.unsignedLongToDouble((long)x2.subtract(x1));
        }
        return NumericUtilities.unsignedLongToDouble((long)x1.subtract(x2));
    }

    public double distY(Long y1, Long y2) {
        if (y2 == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (y1 == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (y2 > y1) {
            return y2 - y1;
        }
        return y1 - y2;
    }

    public Address midX(Address x1, Address x2) {
        return x1.add(Long.divideUnsigned(x2.subtract(x1), 2L));
    }

    public Long midY(Long y1, Long y2) {
        if (y1 == null || y2 == null) {
            return null;
        }
        return y1 + (y2 - y1) / 2L;
    }

    public TraceAddressSnapRange getFull() {
        return this.full;
    }
}

