/*
 * Decompiled with CFR 0.152.
 */
package generic.util.action;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class DeleteToEndOfWordAction
extends TextAction {
    public static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(127, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    private static final String ACTION_NAME = "delete-to-end-of-word-word";

    public DeleteToEndOfWordAction() {
        super(ACTION_NAME);
    }

    private void error(Component component) {
        UIManager.getLookAndFeel().provideErrorFeedback(component);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent textComponent = this.getTextComponent(e);
        if (textComponent == null || !textComponent.isEditable()) {
            this.error(textComponent);
            return;
        }
        try {
            Document document = textComponent.getDocument();
            Caret caret = textComponent.getCaret();
            int caretIndex = caret.getDot();
            int markIndex = caret.getMark();
            int selectionStartIndex = Math.min(caretIndex, markIndex);
            int selectionEndIndex = Math.max(caretIndex, markIndex);
            int wordEndIndex = this.getEndOfWordIndex(textComponent, selectionStartIndex);
            if (wordEndIndex != selectionEndIndex) {
                document.remove(selectionStartIndex, wordEndIndex - selectionStartIndex);
            } else if (caretIndex > 0) {
                this.error(textComponent);
            }
        }
        catch (BadLocationException ble) {
            this.error(textComponent);
        }
    }

    private int getEndOfWordIndex(JTextComponent textComponent, int offset) throws BadLocationException {
        Element currentParagraph = Utilities.getParagraphElement(textComponent, offset);
        int currentParagraphEndOffset = currentParagraph.getEndOffset();
        int currentParagraphEnd = currentParagraphEndOffset - 1;
        if (textComponent instanceof JPasswordField) {
            return currentParagraphEnd;
        }
        int wordOffset = offset;
        try {
            int startOfNextWord = Utilities.getNextWord(textComponent, offset);
            int endOfCurrentWord = Utilities.getWordEnd(textComponent, offset);
            boolean isWhiteSpace = startOfNextWord == endOfCurrentWord;
            wordOffset = isWhiteSpace ? Utilities.getWordEnd(textComponent, startOfNextWord) : endOfCurrentWord;
            if (wordOffset >= currentParagraphEndOffset && offset != currentParagraphEnd) {
                wordOffset = currentParagraphEnd;
            }
        }
        catch (BadLocationException ble) {
            Document document = textComponent.getDocument();
            int documentEnd = document.getLength();
            if (wordOffset != documentEnd) {
                wordOffset = offset != currentParagraphEnd ? currentParagraphEnd : documentEnd;
            }
            throw ble;
        }
        return wordOffset;
    }
}

