/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net;

import ghidra.net.ApplicationKeyManagerUtils;
import ghidra.util.Msg;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;

public class ApplicationKeyStore {
    private ApplicationKeyStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore getCertificateStoreInstance(String cacertsPath) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        int certCount = 0;
        KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
        store.load(null);
        FileInputStream fis = new FileInputStream(cacertsPath);
        try (BufferedInputStream bis = new BufferedInputStream(fis);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (bis.available() > 0) {
                try {
                    Certificate cert = cf.generateCertificate(bis);
                    if (!(cert instanceof X509Certificate)) continue;
                    X509Certificate x509Cert = (X509Certificate)cert;
                    String name = ApplicationKeyStore.getCommonName(x509Cert.getSubjectDN());
                    store.setCertificateEntry(name, cert);
                    ++certCount;
                }
                catch (CertificateException e) {
                    Throwable cause = e.getCause();
                    if (cause == null || !"Empty input".equals(cause.getMessage())) {
                        throw e;
                    }
                    break;
                }
            }
        }
        if (certCount == 0) {
            return ApplicationKeyStore.getKeyStoreInstance(cacertsPath, null);
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStoreInstance(String keystorePath, char[] pwd) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        File keystoreFile = new File(keystorePath);
        boolean isPKCS12 = ApplicationKeyManagerUtils.PKCS_FILENAME_FILTER.accept(keystoreFile);
        String type = isPKCS12 ? "PKCS12" : "JKS";
        KeyStore ks = KeyStore.getInstance(type);
        FileInputStream fis = new FileInputStream(keystorePath);
        try (BufferedInputStream bis = new BufferedInputStream(fis);){
            ks.load(bis, pwd);
        }
        return ks;
    }

    public static String detectKeyStoreType(String keystorePath) throws IOException {
        try (FileInputStream fis = new FileInputStream(keystorePath);){
            byte[] header = new byte[4];
            int read = fis.read(header);
            if (read < 4) {
                String string = null;
                return string;
            }
            if ((header[0] & 0xFF) == 254 && (header[1] & 0xFF) == 237 && (header[2] & 0xFF) == 254 && (header[3] & 0xFF) == 237) {
                String string = "JKS";
                return string;
            }
            if ((header[0] & 0xFF) == 48 && (header[1] & 0xFF) == 130) {
                String string = "PKCS12";
                return string;
            }
            String string = null;
            return string;
        }
    }

    private static String getCommonName(Principal subject) {
        String name = subject.getName();
        int commaIndex = name.indexOf(44);
        String firstElement = commaIndex < 0 ? name : name.substring(0, commaIndex);
        int equalsIndex = firstElement.indexOf(61);
        if (equalsIndex <= 0) {
            return name;
        }
        String fieldName = firstElement.substring(0, equalsIndex).trim();
        String fieldValue = firstElement.substring(equalsIndex + 1).trim();
        if (!fieldName.equalsIgnoreCase("CN")) {
            return name;
        }
        return fieldValue;
    }

    static void logCerts(KeyStore keyStore) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate certificate = keyStore.getCertificate(alias);
                if (certificate == null) continue;
                if (certificate instanceof X509Certificate) {
                    ApplicationKeyStore.logCert(alias, (X509Certificate)certificate);
                    continue;
                }
                Msg.warn(ApplicationKeyStore.class, (Object)("Ignore unrecognized certificate: alias=" + alias + ", type=" + certificate.getType()));
            }
        }
        catch (KeyStoreException e) {
            Msg.error(ApplicationKeyStore.class, (Object)"KeyStore failure", (Throwable)e);
        }
    }

    public static void logCerts(X509Certificate[] x509Certs) {
        for (X509Certificate x509Cert : x509Certs) {
            ApplicationKeyStore.logCert(null, x509Cert);
        }
    }

    static void logCert(String alias, X509Certificate x509Cert) {
        Object label;
        X500Principal subj = x509Cert.getSubjectX500Principal();
        X500Principal issuer = x509Cert.getIssuerX500Principal();
        Date now = new Date();
        Object object = label = alias != null ? alias + ": " : "";
        if (now.compareTo(x509Cert.getNotAfter()) > 0) {
            Msg.warn(ApplicationKeyStore.class, (Object)("   " + (String)label + ApplicationKeyStore.getCommonName(subj) + ", issued by " + ApplicationKeyStore.getCommonName(issuer) + ", S/N " + x509Cert.getSerialNumber().toString(16) + ", expired " + String.valueOf(x509Cert.getNotAfter()) + " **EXPIRED**"));
        } else {
            Msg.info(ApplicationKeyStore.class, (Object)("   " + (String)label + ApplicationKeyStore.getCommonName(subj) + ", issued by " + ApplicationKeyStore.getCommonName(issuer) + ", S/N " + x509Cert.getSerialNumber().toString(16) + ", expires " + String.valueOf(x509Cert.getNotAfter())));
        }
    }
}

